/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import io.trino.plugin.pinot.PinotSessionProperties;
import io.trino.plugin.pinot.PinotSplit;
import io.trino.plugin.pinot.PinotTableHandle;
import io.trino.plugin.pinot.client.PinotClient;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.pinot.spi.config.table.TableType;

public class PinotSplitManager
implements ConnectorSplitManager {
    private static final Logger LOG = Logger.get(PinotSplitManager.class);
    private static final String REALTIME_SUFFIX = "_" + TableType.REALTIME;
    private static final String OFFLINE_SUFFIX = "_" + TableType.OFFLINE;
    private final PinotClient pinotClient;

    @Inject
    public PinotSplitManager(PinotClient pinotClient) {
        this.pinotClient = Objects.requireNonNull(pinotClient, "pinotClient is null");
    }

    protected ConnectorSplitSource generateSplitForBrokerBasedScan(PinotTableHandle pinotTableHandle) {
        return new FixedSplitSource(Collections.singletonList(PinotSplit.createBrokerSplit()));
    }

    protected ConnectorSplitSource generateSplitsForSegmentBasedScan(PinotTableHandle tableHandle, ConnectorSession session) {
        String tableName = tableHandle.getTableName();
        Map<String, Map<String, List<String>>> routingTable = this.pinotClient.getRoutingTableForTable(tableName);
        LOG.info("Got routing table for %s: %s", new Object[]{tableName, routingTable});
        ArrayList<ConnectorSplit> splits = new ArrayList<ConnectorSplit>();
        if (!routingTable.isEmpty()) {
            PinotClient.TimeBoundary timeBoundary = new PinotClient.TimeBoundary(null, null);
            if (routingTable.containsKey(tableName + REALTIME_SUFFIX) && routingTable.containsKey(tableName + OFFLINE_SUFFIX)) {
                timeBoundary = this.pinotClient.getTimeBoundaryForTable(tableName);
            }
            this.generateSegmentSplits(splits, routingTable, tableName, REALTIME_SUFFIX, session, timeBoundary.getOnlineTimePredicate());
            this.generateSegmentSplits(splits, routingTable, tableName, OFFLINE_SUFFIX, session, timeBoundary.getOfflineTimePredicate());
        }
        Collections.shuffle(splits);
        return new FixedSplitSource(splits);
    }

    protected void generateSegmentSplits(List<ConnectorSplit> splits, Map<String, Map<String, List<String>>> routingTable, String tableName, String tableNameSuffix, ConnectorSession session, Optional<String> timePredicate) {
        String finalTableName = tableName + tableNameSuffix;
        int segmentsPerSplitConfigured = PinotSessionProperties.getSegmentsPerSplit(session);
        for (String routingTableName : routingTable.keySet()) {
            if (!routingTableName.equalsIgnoreCase(finalTableName)) continue;
            Map<String, List<String>> hostToSegmentsMap = routingTable.get(routingTableName);
            hostToSegmentsMap.forEach((host, segments) -> {
                int numSegmentsInThisSplit = Math.min(segments.size(), segmentsPerSplitConfigured);
                Iterables.partition((Iterable)segments, (int)numSegmentsInThisSplit).forEach(segmentsForThisSplit -> splits.add(PinotSplit.createSegmentSplit(tableNameSuffix, segmentsForThisSplit, host, timePredicate)));
            });
        }
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableHandle tableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
        PinotTableHandle pinotTableHandle = (PinotTableHandle)tableHandle;
        Supplier<TrinoException> errorSupplier = () -> new QueryNotAdequatelyPushedDownException(QueryNotAdequatelyPushedDownErrorCode.PQL_NOT_PRESENT, pinotTableHandle, "");
        if (!PinotSplitManager.isBrokerQuery(session, pinotTableHandle)) {
            if (PinotSessionProperties.isForbidSegmentQueries(session)) {
                throw errorSupplier.get();
            }
            return this.generateSplitsForSegmentBasedScan(pinotTableHandle, session);
        }
        return this.generateSplitForBrokerBasedScan(pinotTableHandle);
    }

    private static boolean isBrokerQuery(ConnectorSession session, PinotTableHandle tableHandle) {
        return tableHandle.getQuery().isPresent() || PinotSessionProperties.isPreferBrokerQueries(session) && tableHandle.getLimit().orElse(Integer.MAX_VALUE) < (long)PinotSessionProperties.getNonAggregateLimitForBrokerQueries(session);
    }

    public static class QueryNotAdequatelyPushedDownException
    extends TrinoException {
        private final String connectorId;
        private final ConnectorTableHandle connectorTableHandle;

        public QueryNotAdequatelyPushedDownException(QueryNotAdequatelyPushedDownErrorCode errorCode, ConnectorTableHandle connectorTableHandle, String connectorId) {
            super((ErrorCodeSupplier)Objects.requireNonNull(errorCode, "errorCode is null"), (String)null);
            this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
            this.connectorTableHandle = Objects.requireNonNull(connectorTableHandle, "connectorTableHandle is null");
        }

        public String getMessage() {
            return super.getMessage() + String.format(" table: %s:%s", this.connectorId, this.connectorTableHandle);
        }
    }

    public static enum QueryNotAdequatelyPushedDownErrorCode implements ErrorCodeSupplier
    {
        PQL_NOT_PRESENT(1, ErrorType.USER_ERROR, "Query uses unsupported expressions that cannot be pushed into the storage engine.");

        private final ErrorCode errorCode;

        private QueryNotAdequatelyPushedDownErrorCode(int code, ErrorType type, String guidance) {
            this.errorCode = new ErrorCode(code + 103088128, this.name() + ": " + guidance, type);
        }

        public ErrorCode toErrorCode() {
            return this.errorCode;
        }
    }
}

