/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotMetadata;
import io.trino.plugin.pinot.PinotTypeConverter;
import io.trino.plugin.pinot.client.PinotClient;
import io.trino.plugin.pinot.query.DynamicTable;
import io.trino.plugin.pinot.query.OrderByExpression;
import io.trino.plugin.pinot.query.PinotExpressionRewriter;
import io.trino.plugin.pinot.query.PinotSqlFormatter;
import io.trino.plugin.pinot.query.PinotTypeResolver;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.reduce.PostAggregationHandler;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextConverterUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;

public final class DynamicTableBuilder {
    public static final String OFFLINE_SUFFIX = "_OFFLINE";
    public static final String REALTIME_SUFFIX = "_REALTIME";
    private static final Set<AggregationFunctionType> NON_NULL_ON_EMPTY_AGGREGATIONS = EnumSet.of(AggregationFunctionType.COUNT, AggregationFunctionType.DISTINCTCOUNT, AggregationFunctionType.DISTINCTCOUNTHLL);

    private DynamicTableBuilder() {
    }

    public static DynamicTable buildFromPql(PinotMetadata pinotMetadata, SchemaTableName schemaTableName, PinotClient pinotClient, PinotTypeConverter typeConverter) {
        Objects.requireNonNull(pinotMetadata, "pinotMetadata is null");
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        Objects.requireNonNull(typeConverter, "typeConverter is null");
        String query = schemaTableName.getTableName();
        BrokerRequest request = CalciteSqlCompiler.compileToBrokerRequest((String)query);
        PinotQuery pinotQuery = request.getPinotQuery();
        QueryContext queryContext = QueryContextConverterUtils.getQueryContext((PinotQuery)pinotQuery);
        String tableName = request.getQuerySource().getTableName();
        String trinoTableName = DynamicTableBuilder.stripSuffix(tableName).toLowerCase(Locale.ENGLISH);
        String pinotTableName = pinotClient.getPinotTableNameFromTrinoTableName(trinoTableName);
        Optional<String> suffix = DynamicTableBuilder.getSuffix(tableName);
        Map<String, ColumnHandle> columnHandles = pinotMetadata.getPinotColumnHandles(trinoTableName);
        ImmutableList orderBy = ImmutableList.of();
        PinotTypeResolver pinotTypeResolver = new PinotTypeResolver(pinotClient, typeConverter, pinotTableName);
        Object selectColumns = ImmutableList.of();
        Object aggregateTypes = ImmutableMap.of();
        if (queryContext.getAggregationFunctions() != null) {
            Preconditions.checkState((queryContext.getAggregationFunctions().length > 0 ? 1 : 0) != 0, (Object)"Aggregation Functions is empty");
            aggregateTypes = DynamicTableBuilder.getAggregateTypes(schemaTableName, queryContext, columnHandles, typeConverter);
        }
        if (queryContext.getSelectExpressions() != null) {
            Preconditions.checkState((!queryContext.getSelectExpressions().isEmpty() ? 1 : 0) != 0, (Object)"Pinot selections is empty");
            selectColumns = DynamicTableBuilder.getPinotColumns(schemaTableName, queryContext.getSelectExpressions(), queryContext.getAliasList(), columnHandles, pinotTypeResolver, (Map<String, PinotColumnNameAndTrinoType>)aggregateTypes);
        }
        if (queryContext.getOrderByExpressions() != null) {
            ImmutableList.Builder orderByBuilder = ImmutableList.builder();
            for (OrderByExpressionContext orderByExpressionContext : queryContext.getOrderByExpressions()) {
                ExpressionContext expressionContext = orderByExpressionContext.getExpression();
                PinotColumnHandle pinotColumnHandle = DynamicTableBuilder.getPinotColumnHandle(schemaTableName, expressionContext, Optional.empty(), columnHandles, pinotTypeResolver, (Map<String, PinotColumnNameAndTrinoType>)aggregateTypes);
                orderByBuilder.add((Object)new OrderByExpression(pinotColumnHandle.getExpression(), orderByExpressionContext.isAsc()));
            }
            orderBy = orderByBuilder.build();
        }
        Object groupByColumns = ImmutableList.of();
        if (queryContext.getGroupByExpressions() != null) {
            groupByColumns = DynamicTableBuilder.getPinotColumns(schemaTableName, queryContext.getGroupByExpressions(), (List<String>)ImmutableList.of(), columnHandles, pinotTypeResolver, (Map<String, PinotColumnNameAndTrinoType>)aggregateTypes);
        }
        Optional<String> havingExpression = Optional.empty();
        if (queryContext.getHavingFilter() != null) {
            String formatted = PinotSqlFormatter.formatFilter(schemaTableName, queryContext.getHavingFilter(), columnHandles);
            havingExpression = Optional.of(formatted);
        }
        Optional<String> filter = Optional.empty();
        if (pinotQuery.getFilterExpression() != null) {
            String formatted = PinotSqlFormatter.formatFilter(schemaTableName, queryContext.getFilter(), columnHandles);
            filter = Optional.of(formatted);
        }
        return new DynamicTable(pinotTableName, suffix, (List<PinotColumnHandle>)selectColumns, filter, (List<PinotColumnHandle>)groupByColumns, (List<PinotColumnHandle>)ImmutableList.of(), havingExpression, (List<OrderByExpression>)orderBy, OptionalLong.of(queryContext.getLimit()), DynamicTableBuilder.getOffset(queryContext), query);
    }

    private static List<PinotColumnHandle> getPinotColumns(SchemaTableName schemaTableName, List<ExpressionContext> expressions, List<String> aliases, Map<String, ColumnHandle> columnHandles, PinotTypeResolver pinotTypeResolver, Map<String, PinotColumnNameAndTrinoType> aggregateTypes) {
        ImmutableList.Builder pinotColumnsBuilder = ImmutableList.builder();
        for (int index = 0; index < expressions.size(); ++index) {
            ExpressionContext expressionContext = expressions.get(index);
            Optional<String> alias = DynamicTableBuilder.getAlias(aliases, index);
            if (expressionContext.getType() == ExpressionContext.Type.IDENTIFIER && expressionContext.getIdentifier().equals("*")) {
                pinotColumnsBuilder.addAll((Iterable)columnHandles.values().stream().map(PinotColumnHandle.class::cast).map(PinotMetadata::toNonAggregateColumnHandle).collect(ImmutableList.toImmutableList()));
                continue;
            }
            pinotColumnsBuilder.add((Object)DynamicTableBuilder.getPinotColumnHandle(schemaTableName, expressionContext, alias, columnHandles, pinotTypeResolver, aggregateTypes));
        }
        return pinotColumnsBuilder.build();
    }

    private static PinotColumnHandle getPinotColumnHandle(SchemaTableName schemaTableName, ExpressionContext expressionContext, Optional<String> alias, Map<String, ColumnHandle> columnHandles, PinotTypeResolver pinotTypeResolver, Map<String, PinotColumnNameAndTrinoType> aggregateTypes) {
        Type trinoType;
        ExpressionContext rewritten = PinotExpressionRewriter.rewriteExpression(schemaTableName, expressionContext, columnHandles);
        String columnName = rewritten.toString();
        String pinotExpression = PinotSqlFormatter.formatExpression(schemaTableName, rewritten);
        boolean isAggregate = DynamicTableBuilder.hasAggregate(rewritten);
        if (isAggregate) {
            trinoType = Objects.requireNonNull(aggregateTypes.get(columnName).getTrinoType(), String.format("Unexpected aggregate expression: '%s'", rewritten));
            columnName = aggregateTypes.get(columnName).getPinotColumnName();
        } else {
            trinoType = pinotTypeResolver.resolveExpressionType(rewritten, schemaTableName, columnHandles);
            if (!aggregateTypes.isEmpty() && trinoType instanceof ArrayType) {
                trinoType = ((ArrayType)trinoType).getElementType();
            }
        }
        return new PinotColumnHandle(alias.orElse(columnName), trinoType, pinotExpression, alias.isPresent(), isAggregate, DynamicTableBuilder.isReturnNullOnEmptyGroup(expressionContext), Optional.empty(), Optional.empty());
    }

    private static Optional<String> getAlias(List<String> aliases, int index) {
        if (index >= aliases.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(aliases.get(index));
    }

    private static boolean isAggregate(ExpressionContext expressionContext) {
        return expressionContext.getType() == ExpressionContext.Type.FUNCTION && expressionContext.getFunction().getType() == FunctionContext.Type.AGGREGATION;
    }

    private static boolean hasAggregate(ExpressionContext expressionContext) {
        switch (expressionContext.getType()) {
            case IDENTIFIER: 
            case LITERAL: {
                return false;
            }
            case FUNCTION: {
                if (DynamicTableBuilder.isAggregate(expressionContext)) {
                    return true;
                }
                for (ExpressionContext argument : expressionContext.getFunction().getArguments()) {
                    if (!DynamicTableBuilder.hasAggregate(argument)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.empty(), String.format("Unsupported expression type '%s'", expressionContext.getType()));
    }

    private static Map<String, PinotColumnNameAndTrinoType> getAggregateTypes(SchemaTableName schemaTableName, QueryContext queryContext, Map<String, ColumnHandle> columnHandles, PinotTypeConverter typeConverter) {
        List aggregateColumnExpressions = (List)queryContext.getSelectExpressions().stream().filter(DynamicTableBuilder::hasAggregate).collect(ImmutableList.toImmutableList());
        queryContext = new QueryContext.Builder().setAliasList(queryContext.getAliasList()).setSelectExpressions(aggregateColumnExpressions).build();
        DataSchema preAggregationSchema = DynamicTableBuilder.getPreAggregationDataSchema(queryContext);
        PostAggregationHandler postAggregationHandler = new PostAggregationHandler(queryContext, preAggregationSchema);
        DataSchema postAggregationSchema = postAggregationHandler.getResultDataSchema();
        ImmutableMap.Builder aggregationTypesBuilder = ImmutableMap.builder();
        for (int index = 0; index < postAggregationSchema.size(); ++index) {
            aggregationTypesBuilder.put((Object)PinotExpressionRewriter.rewriteExpression(schemaTableName, (ExpressionContext)aggregateColumnExpressions.get(index), columnHandles).toString(), (Object)new PinotColumnNameAndTrinoType(postAggregationSchema.getColumnName(index), typeConverter.toTrinoType(postAggregationSchema.getColumnDataType(index))));
        }
        return aggregationTypesBuilder.buildOrThrow();
    }

    private static DataSchema getPreAggregationDataSchema(QueryContext queryContext) {
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        int numAggregationFunctions = aggregationFunctions.length;
        String[] columnNames = new String[numAggregationFunctions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = aggregationFunctions[i];
            columnNames[i] = aggregationFunction.getResultColumnName();
            columnDataTypes[i] = aggregationFunction.getFinalResultColumnType();
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    private static boolean isReturnNullOnEmptyGroup(ExpressionContext expressionContext) {
        if (DynamicTableBuilder.isAggregate(expressionContext)) {
            return !NON_NULL_ON_EMPTY_AGGREGATIONS.contains(AggregationFunctionType.getAggregationFunctionType((String)expressionContext.getFunction().getFunctionName()));
        }
        return true;
    }

    private static OptionalLong getOffset(QueryContext queryContext) {
        if (queryContext.getOffset() > 0) {
            return OptionalLong.of(queryContext.getOffset());
        }
        return OptionalLong.empty();
    }

    private static String stripSuffix(String tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(OFFLINE_SUFFIX)) {
            return tableName.substring(0, tableName.length() - OFFLINE_SUFFIX.length());
        }
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(REALTIME_SUFFIX)) {
            return tableName.substring(0, tableName.length() - REALTIME_SUFFIX.length());
        }
        return tableName;
    }

    private static Optional<String> getSuffix(String tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(OFFLINE_SUFFIX)) {
            return Optional.of(OFFLINE_SUFFIX);
        }
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(REALTIME_SUFFIX)) {
            return Optional.of(REALTIME_SUFFIX);
        }
        return Optional.empty();
    }

    private static class PinotColumnNameAndTrinoType {
        private final String pinotColumnName;
        private final Type trinoType;

        public PinotColumnNameAndTrinoType(String pinotColumnName, Type trinoType) {
            this.pinotColumnName = Objects.requireNonNull(pinotColumnName, "pinotColumnName is null");
            this.trinoType = Objects.requireNonNull(trinoType, "trinoType is null");
        }

        public String getPinotColumnName() {
            return this.pinotColumnName;
        }

        public Type getTrinoType() {
            return this.trinoType;
        }
    }
}

