/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.io.netty.handler.codec.http;

import io.trino.hadoop.$internal.io.netty.buffer.ByteBuf;
import io.trino.hadoop.$internal.io.netty.buffer.ByteBufHolder;
import io.trino.hadoop.$internal.io.netty.buffer.CompositeByteBuf;
import io.trino.hadoop.$internal.io.netty.buffer.Unpooled;
import io.trino.hadoop.$internal.io.netty.channel.ChannelFuture;
import io.trino.hadoop.$internal.io.netty.channel.ChannelFutureListener;
import io.trino.hadoop.$internal.io.netty.channel.ChannelHandlerContext;
import io.trino.hadoop.$internal.io.netty.handler.codec.DecoderResult;
import io.trino.hadoop.$internal.io.netty.handler.codec.MessageToMessageDecoder;
import io.trino.hadoop.$internal.io.netty.handler.codec.TooLongFrameException;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.FullHttpMessage;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.FullHttpRequest;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.FullHttpResponse;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpContent;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpHeaders;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpMessage;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpMessageUtil;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpMethod;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpObject;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpRequest;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpResponse;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpResponseStatus;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.HttpVersion;
import io.trino.hadoop.$internal.io.netty.handler.codec.http.LastHttpContent;
import java.util.List;

public class HttpObjectAggregator
extends MessageToMessageDecoder<HttpObject> {
    public static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse EXPECTATION_FAILED = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER);
    private final int maxContentLength;
    private AggregatedFullHttpMessage currentMessage;
    private final boolean closeOnExpectationFailed;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;

    public HttpObjectAggregator(int maxContentLength) {
        this(maxContentLength, false);
    }

    public HttpObjectAggregator(int maxContentLength, boolean closeOnExpectationFailed) {
        if (maxContentLength <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + maxContentLength);
        }
        this.maxContentLength = maxContentLength;
        this.closeOnExpectationFailed = closeOnExpectationFailed;
    }

    public final int getMaxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int maxCumulationBufferComponents) {
        if (maxCumulationBufferComponents < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + maxCumulationBufferComponents + " (expected: >= 2)");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.maxCumulationBufferComponents = maxCumulationBufferComponents;
    }

    @Override
    protected void decode(final ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        if (msg instanceof HttpMessage) {
            if (this.currentMessage != null) {
                this.currentMessage.release();
                this.currentMessage = null;
                throw new IllegalStateException("Start of new message received before existing message completed.");
            }
            HttpMessage m = (HttpMessage)msg;
            if (HttpHeaders.is100ContinueExpected(m)) {
                if (HttpHeaders.getContentLength(m, 0L) > (long)this.maxContentLength) {
                    ChannelFuture future = ctx.writeAndFlush(EXPECTATION_FAILED.duplicate().retain());
                    future.addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                ctx.fireExceptionCaught(future.cause());
                            }
                        }
                    });
                    if (this.closeOnExpectationFailed) {
                        future.addListener(ChannelFutureListener.CLOSE);
                    }
                    ctx.pipeline().fireUserEventTriggered(HttpExpectationFailedEvent.INSTANCE);
                    return;
                }
                ctx.writeAndFlush(CONTINUE.duplicate().retain()).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            ctx.fireExceptionCaught(future.cause());
                        }
                    }
                });
            }
            if (!m.getDecoderResult().isSuccess()) {
                HttpHeaders.removeTransferEncodingChunked(m);
                out.add(HttpObjectAggregator.toFullMessage(m));
                return;
            }
            if (msg instanceof HttpRequest) {
                HttpRequest header = (HttpRequest)msg;
                this.currentMessage = new AggregatedFullHttpRequest(header, (ByteBuf)ctx.alloc().compositeBuffer(this.maxCumulationBufferComponents), null);
            } else if (msg instanceof HttpResponse) {
                HttpResponse header = (HttpResponse)msg;
                this.currentMessage = new AggregatedFullHttpResponse(header, (ByteBuf)ctx.alloc().compositeBuffer(this.maxCumulationBufferComponents), null);
            } else {
                throw new Error();
            }
            HttpHeaders.removeTransferEncodingChunked(this.currentMessage);
        } else if (msg instanceof HttpContent) {
            boolean last;
            if (this.currentMessage == null) {
                return;
            }
            HttpContent chunk = (HttpContent)msg;
            CompositeByteBuf content = (CompositeByteBuf)this.currentMessage.content();
            if (content.readableBytes() > this.maxContentLength - chunk.content().readableBytes()) {
                this.currentMessage.release();
                this.currentMessage = null;
                throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
            }
            if (chunk.content().isReadable()) {
                content.addComponent(true, chunk.content().retain());
            }
            if (!chunk.getDecoderResult().isSuccess()) {
                this.currentMessage.setDecoderResult(DecoderResult.failure(chunk.getDecoderResult().cause()));
                last = true;
            } else {
                last = chunk instanceof LastHttpContent;
            }
            if (last) {
                if (chunk instanceof LastHttpContent) {
                    LastHttpContent trailer = (LastHttpContent)chunk;
                    this.currentMessage.setTrailingHeaders(trailer.trailingHeaders());
                } else {
                    this.currentMessage.setTrailingHeaders(new DefaultHttpHeaders());
                }
                if (!HttpHeaders.isContentLengthSet(this.currentMessage)) {
                    this.currentMessage.headers().set("Content-Length", (Object)String.valueOf(content.readableBytes()));
                }
                AggregatedFullHttpMessage currentMessage = this.currentMessage;
                this.currentMessage = null;
                out.add(currentMessage);
            }
        } else {
            throw new Error();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            super.channelInactive(ctx);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        try {
            super.handlerRemoved(ctx);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    private void releaseCurrentMessage() {
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
        }
    }

    private static FullHttpMessage toFullMessage(HttpMessage msg) {
        AggregatedFullHttpMessage fullMsg;
        if (msg instanceof FullHttpMessage) {
            return ((FullHttpMessage)msg).retain();
        }
        if (msg instanceof HttpRequest) {
            fullMsg = new AggregatedFullHttpRequest((HttpRequest)msg, Unpooled.EMPTY_BUFFER, (HttpHeaders)new DefaultHttpHeaders());
        } else if (msg instanceof HttpResponse) {
            fullMsg = new AggregatedFullHttpResponse((HttpResponse)msg, Unpooled.EMPTY_BUFFER, (HttpHeaders)new DefaultHttpHeaders());
        } else {
            throw new IllegalStateException();
        }
        return fullMsg;
    }

    static {
        HttpHeaders.setContentLength(EXPECTATION_FAILED, 0L);
    }

    private static final class AggregatedFullHttpResponse
    extends AggregatedFullHttpMessage
    implements FullHttpResponse {
        AggregatedFullHttpResponse(HttpResponse message, ByteBuf content, HttpHeaders trailingHeaders) {
            super(message, content, trailingHeaders);
        }

        @Override
        public FullHttpResponse copy() {
            DefaultFullHttpResponse copy = new DefaultFullHttpResponse(this.getProtocolVersion(), this.getStatus(), this.content().copy());
            copy.headers().set(this.headers());
            copy.trailingHeaders().set(this.trailingHeaders());
            return copy;
        }

        @Override
        public FullHttpResponse duplicate() {
            DefaultFullHttpResponse duplicate = new DefaultFullHttpResponse(this.getProtocolVersion(), this.getStatus(), this.content().duplicate());
            duplicate.headers().set(this.headers());
            duplicate.trailingHeaders().set(this.trailingHeaders());
            return duplicate;
        }

        @Override
        public FullHttpResponse setStatus(HttpResponseStatus status) {
            ((HttpResponse)this.message).setStatus(status);
            return this;
        }

        @Override
        public HttpResponseStatus getStatus() {
            return ((HttpResponse)this.message).getStatus();
        }

        @Override
        public FullHttpResponse setProtocolVersion(HttpVersion version) {
            super.setProtocolVersion(version);
            return this;
        }

        @Override
        public FullHttpResponse retain(int increment) {
            super.retain(increment);
            return this;
        }

        @Override
        public FullHttpResponse retain() {
            super.retain();
            return this;
        }

        public String toString() {
            return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
        }
    }

    private static final class AggregatedFullHttpRequest
    extends AggregatedFullHttpMessage
    implements FullHttpRequest {
        AggregatedFullHttpRequest(HttpRequest request, ByteBuf content, HttpHeaders trailingHeaders) {
            super(request, content, trailingHeaders);
        }

        @Override
        public FullHttpRequest copy() {
            DefaultFullHttpRequest copy = new DefaultFullHttpRequest(this.getProtocolVersion(), this.getMethod(), this.getUri(), this.content().copy());
            copy.headers().set(this.headers());
            copy.trailingHeaders().set(this.trailingHeaders());
            return copy;
        }

        @Override
        public FullHttpRequest duplicate() {
            DefaultFullHttpRequest duplicate = new DefaultFullHttpRequest(this.getProtocolVersion(), this.getMethod(), this.getUri(), this.content().duplicate());
            duplicate.headers().set(this.headers());
            duplicate.trailingHeaders().set(this.trailingHeaders());
            return duplicate;
        }

        @Override
        public FullHttpRequest retain(int increment) {
            super.retain(increment);
            return this;
        }

        @Override
        public FullHttpRequest retain() {
            super.retain();
            return this;
        }

        @Override
        public FullHttpRequest setMethod(HttpMethod method) {
            ((HttpRequest)this.message).setMethod(method);
            return this;
        }

        @Override
        public FullHttpRequest setUri(String uri) {
            ((HttpRequest)this.message).setUri(uri);
            return this;
        }

        @Override
        public HttpMethod getMethod() {
            return ((HttpRequest)this.message).getMethod();
        }

        @Override
        public String getUri() {
            return ((HttpRequest)this.message).getUri();
        }

        @Override
        public FullHttpRequest setProtocolVersion(HttpVersion version) {
            super.setProtocolVersion(version);
            return this;
        }

        public String toString() {
            return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
        }
    }

    private static abstract class AggregatedFullHttpMessage
    implements ByteBufHolder,
    FullHttpMessage {
        protected final HttpMessage message;
        private final ByteBuf content;
        private HttpHeaders trailingHeaders;

        AggregatedFullHttpMessage(HttpMessage message, ByteBuf content, HttpHeaders trailingHeaders) {
            this.message = message;
            this.content = content;
            this.trailingHeaders = trailingHeaders;
        }

        @Override
        public HttpHeaders trailingHeaders() {
            HttpHeaders trailingHeaders = this.trailingHeaders;
            if (trailingHeaders == null) {
                return HttpHeaders.EMPTY_HEADERS;
            }
            return trailingHeaders;
        }

        void setTrailingHeaders(HttpHeaders trailingHeaders) {
            this.trailingHeaders = trailingHeaders;
        }

        @Override
        public HttpVersion getProtocolVersion() {
            return this.message.getProtocolVersion();
        }

        @Override
        public FullHttpMessage setProtocolVersion(HttpVersion version) {
            this.message.setProtocolVersion(version);
            return this;
        }

        @Override
        public HttpHeaders headers() {
            return this.message.headers();
        }

        @Override
        public DecoderResult getDecoderResult() {
            return this.message.getDecoderResult();
        }

        @Override
        public void setDecoderResult(DecoderResult result) {
            this.message.setDecoderResult(result);
        }

        @Override
        public ByteBuf content() {
            return this.content;
        }

        @Override
        public int refCnt() {
            return this.content.refCnt();
        }

        @Override
        public FullHttpMessage retain() {
            this.content.retain();
            return this;
        }

        @Override
        public FullHttpMessage retain(int increment) {
            this.content.retain(increment);
            return this;
        }

        @Override
        public boolean release() {
            return this.content.release();
        }

        @Override
        public boolean release(int decrement) {
            return this.content.release(decrement);
        }

        @Override
        public abstract FullHttpMessage copy();

        @Override
        public abstract FullHttpMessage duplicate();
    }
}

