/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.enc;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.cksum.HashProvider;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.enc.KeKiEnc;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.key.DkKeyMaker;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.util.Hmac;
import java.nio.charset.StandardCharsets;

public abstract class KeKiHmacSha1Enc
extends KeKiEnc {
    private DkKeyMaker km;

    public KeKiHmacSha1Enc(EncryptProvider encProvider, HashProvider hashProvider, DkKeyMaker km) {
        super(encProvider, hashProvider);
        this.km = km;
    }

    @Override
    public byte[] prf(byte[] key, byte[] seed) throws KrbException {
        byte[] prfConst = "prf".getBytes(StandardCharsets.UTF_8);
        int cksumSize = this.hashProvider().hashSize() / this.encProvider().blockSize() * this.encProvider().blockSize();
        byte[] cksum = new byte[cksumSize];
        byte[] output = new byte[this.prfSize()];
        this.hashProvider().hash(seed);
        System.arraycopy(this.hashProvider().output(), 0, cksum, 0, cksumSize);
        byte[] kp = this.km.dk(key, prfConst);
        this.encProvider().encrypt(kp, cksum);
        System.arraycopy(cksum, 0, output, 0, this.prfSize());
        return output;
    }

    @Override
    protected byte[] makeChecksum(byte[] key, byte[] data, int hashSize) throws KrbException {
        byte[] hash = Hmac.hmac(this.hashProvider(), key, data);
        byte[] output = new byte[hashSize];
        System.arraycopy(hash, 0, output, 0, hashSize);
        return output;
    }
}

