/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageStatistics;

@InterfaceAudience.Public
public enum GlobalStorageStatistics {
    INSTANCE;

    private final NavigableMap<String, StorageStatistics> map = new TreeMap<String, StorageStatistics>();

    public synchronized StorageStatistics get(String name) {
        return name == null ? null : (StorageStatistics)this.map.get(name);
    }

    public synchronized StorageStatistics put(String name, StorageStatisticsProvider provider) {
        Preconditions.checkNotNull(name, "Storage statistics can not have a null name!");
        StorageStatistics stats = (StorageStatistics)this.map.get(name);
        if (stats != null) {
            return stats;
        }
        stats = provider.provide();
        if (stats == null) {
            throw new RuntimeException("StorageStatisticsProvider for " + name + " should not provide a null StorageStatistics object.");
        }
        if (!stats.getName().equals(name)) {
            throw new RuntimeException("StorageStatisticsProvider for " + name + " provided a StorageStatistics object for " + stats.getName() + " instead.");
        }
        this.map.put(name, stats);
        return stats;
    }

    public synchronized void reset() {
        for (StorageStatistics statistics : this.map.values()) {
            statistics.reset();
        }
    }

    public synchronized Iterator<StorageStatistics> iterator() {
        Map.Entry<String, StorageStatistics> first = this.map.firstEntry();
        return new StorageIterator(first == null ? null : first.getValue());
    }

    private class StorageIterator
    implements Iterator<StorageStatistics> {
        private StorageStatistics next = null;

        StorageIterator(StorageStatistics first) {
            this.next = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StorageStatistics next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            GlobalStorageStatistics globalStorageStatistics = GlobalStorageStatistics.this;
            synchronized (globalStorageStatistics) {
                StorageStatistics cur = this.next;
                Map.Entry nextEntry = GlobalStorageStatistics.this.map.higherEntry(cur.getName());
                this.next = nextEntry == null ? null : (StorageStatistics)nextEntry.getValue();
                return cur;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface StorageStatisticsProvider {
        public StorageStatistics provide();
    }
}

