/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.math.LongMath;
import io.airlift.slice.Slice;
import io.trino.plugin.base.expression.ConnectorExpressions;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DateType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ConstraintExtractor {
    private ConstraintExtractor() {
    }

    public static ExtractionResult extractTupleDomain(Constraint constraint) {
        TupleDomain result = constraint.getSummary().transformKeys(IcebergColumnHandle.class::cast);
        ImmutableList.Builder remainingExpressions = ImmutableList.builder();
        for (ConnectorExpression conjunct : ConnectorExpressions.extractConjuncts((ConnectorExpression)constraint.getExpression())) {
            Optional<TupleDomain<IcebergColumnHandle>> converted = ConstraintExtractor.toTupleDomain(conjunct, (Map<String, ColumnHandle>)constraint.getAssignments());
            if (converted.isEmpty()) {
                remainingExpressions.add((Object)conjunct);
                continue;
            }
            if (!(result = result.intersect(converted.get())).isNone()) continue;
            return new ExtractionResult((TupleDomain<IcebergColumnHandle>)TupleDomain.none(), (ConnectorExpression)Constant.TRUE);
        }
        return new ExtractionResult((TupleDomain<IcebergColumnHandle>)result, ConnectorExpressions.and((List)remainingExpressions.build()));
    }

    private static Optional<TupleDomain<IcebergColumnHandle>> toTupleDomain(ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        if (expression instanceof Call) {
            Call call = (Call)expression;
            return ConstraintExtractor.toTupleDomain(call, assignments);
        }
        return Optional.empty();
    }

    private static Optional<TupleDomain<IcebergColumnHandle>> toTupleDomain(Call call, Map<String, ColumnHandle> assignments) {
        if (call.getArguments().size() == 2) {
            Object e;
            Call firstAsCall;
            ConnectorExpression firstArgument = (ConnectorExpression)call.getArguments().get(0);
            ConnectorExpression secondArgument = (ConnectorExpression)call.getArguments().get(1);
            if (firstArgument instanceof Call && (firstAsCall = (Call)firstArgument).getFunctionName().equals((Object)StandardFunctions.CAST_FUNCTION_NAME) && secondArgument instanceof Constant) {
                Constant constant = (Constant)secondArgument;
                if (firstArgument.getType().equals(secondArgument.getType())) {
                    return ConstraintExtractor.unwrapCastInComparison(call.getFunctionName(), (ConnectorExpression)Iterables.getOnlyElement((Iterable)firstAsCall.getArguments()), constant, assignments);
                }
            }
            if (firstArgument instanceof Call && (firstAsCall = (Call)firstArgument).getFunctionName().equals((Object)new FunctionName("date_trunc")) && firstAsCall.getArguments().size() == 2 && (e = firstAsCall.getArguments().get(0)) instanceof Constant) {
                Constant unit = (Constant)e;
                if (secondArgument instanceof Constant) {
                    Constant constant = (Constant)secondArgument;
                    if (firstArgument.getType().equals(secondArgument.getType())) {
                        return ConstraintExtractor.unwrapDateTruncInComparison(call.getFunctionName(), unit, (ConnectorExpression)firstAsCall.getArguments().get(1), constant, assignments);
                    }
                }
            }
        }
        return Optional.empty();
    }

    private static Optional<TupleDomain<IcebergColumnHandle>> unwrapCastInComparison(FunctionName functionName, ConnectorExpression castSource, Constant constant, Map<String, ColumnHandle> assignments) {
        if (!(castSource instanceof Variable)) {
            return Optional.empty();
        }
        Variable sourceVariable = (Variable)castSource;
        if (constant.getValue() == null) {
            return Optional.empty();
        }
        IcebergColumnHandle column = ConstraintExtractor.resolve(sourceVariable, assignments);
        Type type = column.getType();
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType sourceType = (TimestampWithTimeZoneType)type;
            Preconditions.checkArgument((sourceType.getPrecision() == 6 ? 1 : 0) != 0, (String)"Unexpected type: %s", (Object)column.getType());
            if (constant.getType() == DateType.DATE) {
                return ConstraintExtractor.unwrapTimestampTzToDateCast(column, functionName, (Long)constant.getValue()).map(domain -> TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain)));
            }
        }
        return Optional.empty();
    }

    private static Optional<Domain> unwrapTimestampTzToDateCast(IcebergColumnHandle column, FunctionName functionName, long date) {
        Type type = column.getType();
        Preconditions.checkArgument((boolean)type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS), (String)"Column of unexpected type %s: %s ", (Object)type, (Object)column);
        Verify.verify((date <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Date value out of range: %s", (long)date);
        LongTimestampWithTimeZone startOfDate = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)(date * 86400000L), (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        LongTimestampWithTimeZone startOfNextDate = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)((date + 1L) * 86400000L), (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        if (functionName.equals((Object)StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)startOfDate, (boolean)true, (Object)startOfNextDate, (boolean)false), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)startOfDate), (Range[])new Range[]{Range.greaterThanOrEqual((Type)type, (Object)startOfNextDate)}), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)startOfDate), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)startOfNextDate), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)startOfNextDate), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)startOfDate), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)startOfDate), (Range[])new Range[]{Range.greaterThanOrEqual((Type)type, (Object)startOfNextDate)}), (boolean)true));
        }
        return Optional.empty();
    }

    private static Optional<TupleDomain<IcebergColumnHandle>> unwrapDateTruncInComparison(FunctionName functionName, Constant unit, ConnectorExpression dateTruncSource, Constant constant, Map<String, ColumnHandle> assignments) {
        if (!(dateTruncSource instanceof Variable)) {
            return Optional.empty();
        }
        Variable sourceVariable = (Variable)dateTruncSource;
        if (unit.getValue() == null) {
            return Optional.empty();
        }
        if (constant.getValue() == null) {
            return Optional.empty();
        }
        IcebergColumnHandle column = ConstraintExtractor.resolve(sourceVariable, assignments);
        Type type = column.getType();
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType type2 = (TimestampWithTimeZoneType)type;
            Preconditions.checkArgument((type2.getPrecision() == 6 ? 1 : 0) != 0, (String)"Unexpected type: %s", (Object)column.getType());
            Verify.verify((boolean)constant.getType().equals(type2), (String)"This method should not be invoked when type mismatch (i.e. surely not a comparison)", (Object[])new Object[0]);
            return ConstraintExtractor.unwrapDateTruncInComparison(((Slice)unit.getValue()).toStringUtf8(), functionName, constant).map(domain -> TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain)));
        }
        return Optional.empty();
    }

    private static Optional<Domain> unwrapDateTruncInComparison(String unit, FunctionName functionName, Constant constant) {
        ZonedDateTime nextPeriodStart;
        ZonedDateTime periodStart;
        Type type = constant.getType();
        Preconditions.checkArgument((constant.getValue() != null && type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS) ? 1 : 0) != 0, (String)"Unexpected constant: %s", (Object)constant);
        ZonedDateTime dateTime = Instant.ofEpochMilli(((LongTimestampWithTimeZone)constant.getValue()).getEpochMillis()).plusNanos(LongMath.divide((long)((LongTimestampWithTimeZone)constant.getValue()).getPicosOfMilli(), (long)1000L, (RoundingMode)RoundingMode.UNNECESSARY)).atZone(ZoneOffset.UTC);
        switch (unit.toLowerCase(Locale.ENGLISH)) {
            case "hour": {
                periodStart = ZonedDateTime.of(dateTime.toLocalDate(), LocalTime.of(dateTime.getHour(), 0), ZoneOffset.UTC);
                nextPeriodStart = periodStart.plusHours(1L);
                break;
            }
            case "day": {
                periodStart = dateTime.toLocalDate().atStartOfDay().atZone(ZoneOffset.UTC);
                nextPeriodStart = periodStart.plusDays(1L);
                break;
            }
            case "month": {
                periodStart = dateTime.toLocalDate().withDayOfMonth(1).atStartOfDay().atZone(ZoneOffset.UTC);
                nextPeriodStart = periodStart.plusMonths(1L);
                break;
            }
            case "year": {
                periodStart = dateTime.toLocalDate().withMonth(1).withDayOfMonth(1).atStartOfDay().atZone(ZoneOffset.UTC);
                nextPeriodStart = periodStart.plusYears(1L);
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        boolean constantAtPeriodStart = dateTime.equals(periodStart);
        LongTimestampWithTimeZone start = LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)periodStart.toEpochSecond(), (long)0L, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        LongTimestampWithTimeZone end = LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)nextPeriodStart.toEpochSecond(), (long)0L, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        if (functionName.equals((Object)StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME)) {
            if (!constantAtPeriodStart) {
                return Optional.of(Domain.none((Type)type));
            }
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)start, (boolean)true, (Object)end, (boolean)false), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME)) {
            if (!constantAtPeriodStart) {
                return Optional.of(Domain.notNull((Type)type));
            }
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)start), (Range[])new Range[]{Range.greaterThanOrEqual((Type)type, (Object)end)}), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME)) {
            if (!constantAtPeriodStart) {
                return Optional.of(Domain.all((Type)type));
            }
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)start), (Range[])new Range[]{Range.greaterThanOrEqual((Type)type, (Object)end)}), (boolean)true));
        }
        if (functionName.equals((Object)StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME)) {
            if (constantAtPeriodStart) {
                return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)start), (Range[])new Range[0]), (boolean)false));
            }
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)end), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)end), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME)) {
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)end), (Range[])new Range[0]), (boolean)false));
        }
        if (functionName.equals((Object)StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME)) {
            if (constantAtPeriodStart) {
                return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)start), (Range[])new Range[0]), (boolean)false));
            }
            return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)end), (Range[])new Range[0]), (boolean)false));
        }
        return Optional.empty();
    }

    private static IcebergColumnHandle resolve(Variable variable, Map<String, ColumnHandle> assignments) {
        ColumnHandle columnHandle = assignments.get(variable.getName());
        Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"No assignment for %s", (Object)variable);
        return (IcebergColumnHandle)columnHandle;
    }

    public record ExtractionResult(TupleDomain<IcebergColumnHandle> tupleDomain, ConnectorExpression remainingExpression) {
        public ExtractionResult {
            Objects.requireNonNull(tupleDomain, "tupleDomain is null");
            Objects.requireNonNull(remainingExpression, "remainingExpression is null");
        }
    }
}

