/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergFileWriterFactory;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.delete.IcebergPositionDeletePageSink;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.MergePage;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.types.Type;
import org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;
import org.roaringbitmap.longlong.LongBitmapDataProvider;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public class IcebergMergeSink
implements ConnectorMergeSink {
    private final LocationProvider locationProvider;
    private final IcebergFileWriterFactory fileWriterFactory;
    private final TrinoFileSystem fileSystem;
    private final JsonCodec<CommitTaskData> jsonCodec;
    private final ConnectorSession session;
    private final IcebergFileFormat fileFormat;
    private final Map<String, String> storageProperties;
    private final Schema schema;
    private final Map<Integer, PartitionSpec> partitionsSpecs;
    private final ConnectorPageSink insertPageSink;
    private final int columnCount;
    private final Map<Slice, FileDeletion> fileDeletions = new HashMap<Slice, FileDeletion>();

    public IcebergMergeSink(LocationProvider locationProvider, IcebergFileWriterFactory fileWriterFactory, TrinoFileSystem fileSystem, JsonCodec<CommitTaskData> jsonCodec, ConnectorSession session, IcebergFileFormat fileFormat, Map<String, String> storageProperties, Schema schema, Map<Integer, PartitionSpec> partitionsSpecs, ConnectorPageSink insertPageSink, int columnCount) {
        this.locationProvider = Objects.requireNonNull(locationProvider, "locationProvider is null");
        this.fileWriterFactory = Objects.requireNonNull(fileWriterFactory, "fileWriterFactory is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        this.storageProperties = ImmutableMap.copyOf(Objects.requireNonNull(storageProperties, "storageProperties is null"));
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.partitionsSpecs = ImmutableMap.copyOf(Objects.requireNonNull(partitionsSpecs, "partitionsSpecs is null"));
        this.insertPageSink = Objects.requireNonNull(insertPageSink, "insertPageSink is null");
        this.columnCount = columnCount;
    }

    public void storeMergedRows(Page page) {
        MergePage mergePage = MergePage.createDeleteAndInsertPages((Page)page, (int)this.columnCount);
        mergePage.getInsertionsPage().ifPresent(arg_0 -> ((ConnectorPageSink)this.insertPageSink).appendPage(arg_0));
        mergePage.getDeletionsPage().ifPresent(deletions -> {
            ColumnarRow rowIdRow = ColumnarRow.toColumnarRow((Block)deletions.getBlock(deletions.getChannelCount() - 1));
            int position = 0;
            while (position < rowIdRow.getPositionCount()) {
                Slice filePath = VarcharType.VARCHAR.getSlice(rowIdRow.getField(0), position);
                long rowPosition = BigintType.BIGINT.getLong(rowIdRow.getField(1), position);
                int index = position++;
                FileDeletion deletion = this.fileDeletions.computeIfAbsent(filePath, ignored -> {
                    long fileRecordCount = BigintType.BIGINT.getLong(rowIdRow.getField(2), index);
                    int partitionSpecId = Math.toIntExact(IntegerType.INTEGER.getLong(rowIdRow.getField(3), index));
                    String partitionData = VarcharType.VARCHAR.getSlice(rowIdRow.getField(4), index).toStringUtf8();
                    return new FileDeletion(partitionSpecId, partitionData, fileRecordCount);
                });
                deletion.rowsToDelete().addLong(rowPosition);
            }
        });
    }

    public CompletableFuture<Collection<Slice>> finish() {
        ArrayList fragments = new ArrayList((Collection)this.insertPageSink.finish().join());
        this.fileDeletions.forEach((dataFilePath, deletion) -> {
            ConnectorPageSink sink = this.createPositionDeletePageSink(dataFilePath.toStringUtf8(), this.partitionsSpecs.get(deletion.partitionSpecId()), deletion.partitionDataJson(), deletion.fileRecordCount());
            fragments.addAll(IcebergMergeSink.writePositionDeletes(sink, (ImmutableLongBitmapDataProvider)deletion.rowsToDelete()));
        });
        return CompletableFuture.completedFuture(fragments);
    }

    public void abort() {
        this.insertPageSink.abort();
    }

    private ConnectorPageSink createPositionDeletePageSink(String dataFilePath, PartitionSpec partitionSpec, String partitionDataJson, long fileRecordCount) {
        Optional<PartitionData> partitionData = Optional.empty();
        if (partitionSpec.isPartitioned()) {
            Type[] columnTypes = (Type[])partitionSpec.fields().stream().map(field -> field.transform().getResultType(this.schema.findType(field.sourceId()))).toArray(Type[]::new);
            partitionData = Optional.of(PartitionData.fromJson(partitionDataJson, columnTypes));
        }
        return new IcebergPositionDeletePageSink(dataFilePath, partitionSpec, partitionData, this.locationProvider, this.fileWriterFactory, this.fileSystem, this.jsonCodec, this.session, this.fileFormat, this.storageProperties, fileRecordCount);
    }

    private static Collection<Slice> writePositionDeletes(ConnectorPageSink sink, ImmutableLongBitmapDataProvider rowsToDelete) {
        try {
            return IcebergMergeSink.doWritePositionDeletes(sink, rowsToDelete);
        }
        catch (Throwable t) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
            autoCloseableArray[0] = () -> ((ConnectorPageSink)sink).abort();
            Closables.closeAllSuppress((Throwable)t, (AutoCloseable[])autoCloseableArray);
            throw t;
        }
    }

    private static Collection<Slice> doWritePositionDeletes(ConnectorPageSink sink, ImmutableLongBitmapDataProvider rowsToDelete) {
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT));
        rowsToDelete.forEach(rowPosition -> {
            BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(0), rowPosition);
            pageBuilder.declarePosition();
            if (pageBuilder.isFull()) {
                sink.appendPage(pageBuilder.build());
                pageBuilder.reset();
            }
        });
        if (!pageBuilder.isEmpty()) {
            sink.appendPage(pageBuilder.build());
        }
        return (Collection)sink.finish().join();
    }

    private static class FileDeletion {
        private final int partitionSpecId;
        private final String partitionDataJson;
        private final long fileRecordCount;
        private final LongBitmapDataProvider rowsToDelete = new Roaring64Bitmap();

        public FileDeletion(int partitionSpecId, String partitionDataJson, long fileRecordCount) {
            this.partitionSpecId = partitionSpecId;
            this.partitionDataJson = Objects.requireNonNull(partitionDataJson, "partitionDataJson is null");
            this.fileRecordCount = fileRecordCount;
        }

        public int partitionSpecId() {
            return this.partitionSpecId;
        }

        public String partitionDataJson() {
            return this.partitionDataJson;
        }

        public long fileRecordCount() {
            return this.fileRecordCount;
        }

        public LongBitmapDataProvider rowsToDelete() {
            return this.rowsToDelete;
        }
    }
}

