/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.classloader.ClassLoaderSafeSystemTable;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.hive.HiveApplyProjectionUtil;
import io.trino.plugin.hive.HiveWrittenPartitions;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.ConstraintExtractor;
import io.trino.plugin.iceberg.ExpressionConverter;
import io.trino.plugin.iceberg.FilesTable;
import io.trino.plugin.iceberg.HistoryTable;
import io.trino.plugin.iceberg.IcebergAnalyzeProperties;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergInputInfo;
import io.trino.plugin.iceberg.IcebergMergeTableHandle;
import io.trino.plugin.iceberg.IcebergMetadataColumn;
import io.trino.plugin.iceberg.IcebergPartitioningHandle;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.IcebergTableProperties;
import io.trino.plugin.iceberg.IcebergUpdateHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.IcebergWritableTableHandle;
import io.trino.plugin.iceberg.ManifestsTable;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.plugin.iceberg.PartitionTable;
import io.trino.plugin.iceberg.PropertiesTable;
import io.trino.plugin.iceberg.SnapshotsTable;
import io.trino.plugin.iceberg.SortFieldUtils;
import io.trino.plugin.iceberg.TableStatisticsReader;
import io.trino.plugin.iceberg.TableStatisticsWriter;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.TrinoSortField;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.aggregation.DataSketchStateSerializer;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.procedure.IcebergDropExtendedStatsHandle;
import io.trino.plugin.iceberg.procedure.IcebergExpireSnapshotsHandle;
import io.trino.plugin.iceberg.procedure.IcebergOptimizeHandle;
import io.trino.plugin.iceberg.procedure.IcebergRemoveOrphanFilesHandle;
import io.trino.plugin.iceberg.procedure.IcebergTableExecuteHandle;
import io.trino.plugin.iceberg.procedure.IcebergTableProcedureId;
import io.trino.plugin.iceberg.util.DataFileWithDeleteFiles;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorAnalyzeMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.DiscretePredicates;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.PointerType;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.UuidType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.UpdateStatistics;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;

public class IcebergMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(IcebergMetadata.class);
    private static final Pattern PATH_PATTERN = Pattern.compile("(.*)/[^/]+");
    private static final int OPTIMIZE_MAX_SUPPORTED_TABLE_VERSION = 2;
    private static final int CLEANING_UP_PROCEDURES_MAX_SUPPORTED_TABLE_VERSION = 2;
    private static final String RETENTION_THRESHOLD = "retention_threshold";
    private static final String UNKNOWN_SNAPSHOT_TOKEN = "UNKNOWN";
    public static final Set<String> UPDATABLE_TABLE_PROPERTIES = ImmutableSet.of((Object)"format", (Object)"format_version", (Object)"partitioning", (Object)"sorted_by");
    public static final String ORC_BLOOM_FILTER_COLUMNS_KEY = "orc.bloom.filter.columns";
    public static final String ORC_BLOOM_FILTER_FPP_KEY = "orc.bloom.filter.fpp";
    public static final String NUMBER_OF_DISTINCT_VALUES_NAME = "NUMBER_OF_DISTINCT_VALUES";
    private static final FunctionName NUMBER_OF_DISTINCT_VALUES_FUNCTION = new FunctionName("$iceberg_theta_stat");
    private static final Integer DELETE_BATCH_SIZE = 1000;
    private final TypeManager typeManager;
    private final JsonCodec<CommitTaskData> commitTaskCodec;
    private final TrinoCatalog catalog;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TableStatisticsWriter tableStatisticsWriter;
    private final Map<IcebergTableHandle, TableStatistics> tableStatisticsCache = new ConcurrentHashMap<IcebergTableHandle, TableStatistics>();
    private Transaction transaction;

    public IcebergMetadata(TypeManager typeManager, JsonCodec<CommitTaskData> commitTaskCodec, TrinoCatalog catalog, TrinoFileSystemFactory fileSystemFactory, TableStatisticsWriter tableStatisticsWriter) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.tableStatisticsWriter = Objects.requireNonNull(tableStatisticsWriter, "tableStatisticsWriter is null");
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        return this.catalog.namespaceExists(session, schemaName);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.catalog.listNamespaces(session);
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, CatalogSchemaName schemaName) {
        return this.catalog.loadNamespaceMetadata(session, schemaName.getSchemaName());
    }

    public Optional<TrinoPrincipal> getSchemaOwner(ConnectorSession session, CatalogSchemaName schemaName) {
        return this.catalog.getNamespacePrincipal(session, schemaName.getSchemaName());
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        throw new UnsupportedOperationException("This method is not supported because getTableHandle with versions is implemented instead");
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        Optional<Object> partitionSpec;
        Schema tableSchema;
        Optional<Long> tableSnapshotId;
        BaseTable table;
        if (startVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Read table with start version is not supported");
        }
        if (!IcebergTableName.isDataTable(tableName.getTableName())) {
            return null;
        }
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        try {
            table = (BaseTable)this.catalog.loadTable(session, new SchemaTableName(tableName.getSchemaName(), name.getTableName()));
        }
        catch (TableNotFoundException e) {
            return null;
        }
        if (endVersion.isPresent()) {
            long snapshotId = IcebergMetadata.getSnapshotIdFromVersion((Table)table, endVersion.get());
            tableSnapshotId = Optional.of(snapshotId);
            tableSchema = SnapshotUtil.schemaFor((Table)table, (long)snapshotId);
            partitionSpec = Optional.empty();
        } else {
            tableSnapshotId = Optional.ofNullable(table.currentSnapshot()).map(Snapshot::snapshotId);
            tableSchema = table.schema();
            partitionSpec = Optional.of(table.spec());
        }
        Map tableProperties = table.properties();
        String nameMappingJson = (String)tableProperties.get("schema.name-mapping.default");
        return new IcebergTableHandle(tableName.getSchemaName(), name.getTableName(), name.getTableType(), tableSnapshotId, SchemaParser.toJson((Schema)tableSchema), (List)table.sortOrder().fields().stream().map(TrinoSortField::fromIceberg).collect(ImmutableList.toImmutableList()), partitionSpec.map(PartitionSpecParser::toJson), table.operations().current().formatVersion(), (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), (Set<IcebergColumnHandle>)ImmutableSet.of(), Optional.ofNullable(nameMappingJson), table.location(), table.properties(), RetryMode.NO_RETRIES, (List<IcebergColumnHandle>)ImmutableList.of(), false, Optional.empty());
    }

    private static long getSnapshotIdFromVersion(Table table, ConnectorTableVersion version) {
        io.trino.spi.type.Type versionType = version.getVersionType();
        return switch (version.getPointerType()) {
            default -> throw new IncompatibleClassChangeError();
            case PointerType.TEMPORAL -> IcebergMetadata.getTemporalSnapshotIdFromVersion(table, version, versionType);
            case PointerType.TARGET_ID -> IcebergMetadata.getTargetSnapshotIdFromVersion(table, version, versionType);
        };
    }

    private static long getTargetSnapshotIdFromVersion(Table table, ConnectorTableVersion version, io.trino.spi.type.Type versionType) {
        if (versionType != BigintType.BIGINT) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type for table version: " + versionType.getDisplayName());
        }
        long snapshotId = (Long)version.getVersion();
        if (table.snapshot(snapshotId) == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Iceberg snapshot ID does not exists: " + snapshotId);
        }
        return snapshotId;
    }

    private static long getTemporalSnapshotIdFromVersion(Table table, ConnectorTableVersion version, io.trino.spi.type.Type versionType) {
        if (versionType instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timeZonedVersionType = (TimestampWithTimeZoneType)versionType;
            long epochMillis = timeZonedVersionType.isShort() ? DateTimeEncoding.unpackMillisUtc((long)((Long)version.getVersion())) : ((LongTimestampWithTimeZone)version.getVersion()).getEpochMillis();
            return IcebergUtil.getSnapshotIdAsOfTime(table, epochMillis);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type for temporal table version: " + versionType.getDisplayName());
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.getRawSystemTable(session, tableName).map(systemTable -> new ClassLoaderSafeSystemTable(systemTable, this.getClass().getClassLoader()));
    }

    private Optional<SystemTable> getRawSystemTable(ConnectorSession session, SchemaTableName tableName) {
        Table table;
        if (IcebergTableName.isDataTable(tableName.getTableName())) {
            return Optional.empty();
        }
        String name = IcebergTableName.tableNameFrom(tableName.getTableName());
        try {
            table = this.catalog.loadTable(session, new SchemaTableName(tableName.getSchemaName(), name));
        }
        catch (TableNotFoundException e) {
            return Optional.empty();
        }
        catch (UnknownTableTypeException e) {
            return Optional.empty();
        }
        Optional<TableType> tableType = IcebergTableName.tableTypeFrom(tableName.getTableName());
        if (tableType.isEmpty()) {
            return Optional.empty();
        }
        IcebergTableName icebergTableName = new IcebergTableName(name, tableType.get());
        SchemaTableName systemTableName = new SchemaTableName(tableName.getSchemaName(), icebergTableName.getTableNameWithType());
        return switch (icebergTableName.getTableType()) {
            default -> throw new IncompatibleClassChangeError();
            case TableType.DATA -> Optional.empty();
            case TableType.HISTORY -> Optional.of(new HistoryTable(systemTableName, table));
            case TableType.SNAPSHOTS -> Optional.of(new SnapshotsTable(systemTableName, this.typeManager, table));
            case TableType.PARTITIONS -> Optional.of(new PartitionTable(systemTableName, this.typeManager, table, this.getCurrentSnapshotId(table)));
            case TableType.MANIFESTS -> Optional.of(new ManifestsTable(systemTableName, table, this.getCurrentSnapshotId(table)));
            case TableType.FILES -> Optional.of(new FilesTable(systemTableName, this.typeManager, table, this.getCurrentSnapshotId(table)));
            case TableType.PROPERTIES -> Optional.of(new PropertiesTable(systemTableName, table));
        };
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        if (table.getSnapshotId().isEmpty()) {
            return new ConnectorTableProperties(TupleDomain.none(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
        }
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Set<Integer> partitionSourceIds = IcebergMetadata.identityPartitionColumnsInAllSpecs(icebergTable);
        TupleDomain<IcebergColumnHandle> enforcedPredicate = table.getEnforcedPredicate();
        DiscretePredicates discretePredicates = null;
        if (!partitionSourceIds.isEmpty()) {
            Map columns = (Map)IcebergUtil.getColumns(icebergTable.schema(), this.typeManager).stream().filter(column -> partitionSourceIds.contains(column.getId())).collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getId, Function.identity()));
            com.google.common.base.Supplier lazyFiles = Suppliers.memoize(() -> {
                ImmutableList immutableList;
                block8: {
                    TableScan tableScan = (TableScan)icebergTable.newScan().useSnapshot(table.getSnapshotId().get().longValue()).filter(ExpressionConverter.toIcebergExpression(enforcedPredicate));
                    CloseableIterable iterator = tableScan.planFiles();
                    try {
                        immutableList = ImmutableList.copyOf((Iterable)iterator);
                        if (iterator == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (iterator != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    iterator.close();
                }
                return immutableList;
            });
            Iterable files = () -> IcebergMetadata.lambda$getTableProperties$3((Supplier)lazyFiles);
            Iterable discreteTupleDomain = Iterables.transform(files, fileScan -> {
                Map<Integer, Optional<String>> partitionColumnValueStrings = IcebergUtil.getPartitionKeys(fileScan);
                Map partitionValues = (Map)partitionSourceIds.stream().filter(partitionColumnValueStrings::containsKey).collect(ImmutableMap.toImmutableMap(columns::get, columnId -> {
                    IcebergColumnHandle column = (IcebergColumnHandle)columns.get(columnId);
                    Object prestoValue = IcebergUtil.deserializePartitionValue(column.getType(), ((Optional)partitionColumnValueStrings.get(columnId)).orElse(null), column.getName());
                    return NullableValue.of((io.trino.spi.type.Type)column.getType(), (Object)prestoValue);
                }));
                return TupleDomain.fromFixedValues((Map)partitionValues);
            });
            discretePredicates = new DiscretePredicates((List)columns.values().stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), discreteTupleDomain);
        }
        return new ConnectorTableProperties(enforcedPredicate.transformKeys(ColumnHandle.class::cast), Optional.empty(), Optional.empty(), Optional.ofNullable(discretePredicates), (List)ImmutableList.of());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        IcebergTableHandle tableHandle = (IcebergTableHandle)table;
        Table icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        List<ColumnMetadata> columns = this.getColumnMetadatas(SchemaParser.fromJson((String)tableHandle.getTableSchemaJson()));
        return new ConnectorTableMetadata(tableHandle.getSchemaTableName(), columns, IcebergUtil.getIcebergTableProperties(icebergTable), IcebergUtil.getTableComment(icebergTable));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listTables(session, schemaName);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (IcebergColumnHandle columnHandle : IcebergUtil.getColumns(SchemaParser.fromJson((String)table.getTableSchemaJson()), this.typeManager)) {
            columnHandles.put((Object)columnHandle.getName(), (Object)columnHandle);
        }
        columnHandles.put((Object)IcebergMetadataColumn.FILE_PATH.getColumnName(), (Object)IcebergColumnHandle.pathColumnHandle());
        columnHandles.put((Object)IcebergMetadataColumn.FILE_MODIFIED_TIME.getColumnName(), (Object)IcebergColumnHandle.fileModifiedTimeColumnHandle());
        return columnHandles.buildOrThrow();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        IcebergColumnHandle column = (IcebergColumnHandle)columnHandle;
        return ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setComment(column.getComment()).build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        throw new UnsupportedOperationException("The deprecated listTableColumns is not supported because streamTableColumns is implemented instead");
    }

    public Iterator<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Object schemaTableNames = prefix.getTable().isEmpty() ? this.catalog.listTables(session, prefix.getSchema()) : ImmutableList.of((Object)prefix.toSchemaTableName());
        return schemaTableNames.stream().flatMap(tableName -> {
            try {
                if (this.redirectTable(session, (SchemaTableName)tableName).isPresent()) {
                    return Stream.of(TableColumnsMetadata.forRedirectedTable((SchemaTableName)tableName));
                }
                Table icebergTable = this.catalog.loadTable(session, (SchemaTableName)tableName);
                List<ColumnMetadata> columns = this.getColumnMetadatas(icebergTable.schema());
                return Stream.of(TableColumnsMetadata.forTable((SchemaTableName)tableName, columns));
            }
            catch (TableNotFoundException e) {
                return Stream.empty();
            }
            catch (UnknownTableTypeException e) {
                return Stream.empty();
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to access metadata of table %s during streaming table columns for %s", new Object[]{tableName, prefix});
                return Stream.empty();
            }
        }).iterator();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        this.catalog.createNamespace(session, schemaName, properties, owner);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        this.catalog.dropNamespace(session, schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.catalog.renameNamespace(session, source, target);
    }

    public void setSchemaAuthorization(ConnectorSession session, String schemaName, TrinoPrincipal principal) {
        this.catalog.setNamespacePrincipal(session, schemaName, principal);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Optional<ConnectorTableLayout> layout = this.getNewTableLayout(session, tableMetadata);
        this.finishCreateTable(session, this.beginCreateTable(session, tableMetadata, layout, RetryMode.NO_RETRIES), (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        this.catalog.updateTableComment(session, ((IcebergTableHandle)tableHandle).getSchemaTableName(), comment);
    }

    public void setViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        this.catalog.updateViewComment(session, viewName, comment);
    }

    public void setViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        this.catalog.updateViewColumnComment(session, viewName, columnName, comment);
    }

    public Optional<ConnectorTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        Schema schema = IcebergUtil.schemaFromMetadata(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        return this.getWriteLayout(schema, partitionSpec, false);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        Verify.verify((this.transaction == null ? 1 : 0) != 0, (String)"transaction already set", (Object[])new Object[0]);
        String schemaName = tableMetadata.getTable().getSchemaName();
        if (!this.schemaExists(session, schemaName)) {
            throw new SchemaNotFoundException(schemaName);
        }
        this.transaction = IcebergUtil.newCreateTableTransaction(this.catalog, tableMetadata, session);
        String location = this.transaction.table().location();
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        try {
            if (fileSystem.listFiles(location).hasNext()) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Cannot create a table on a non-empty location: %s, set 'iceberg.unique-table-location=true' in your Iceberg catalog properties to use unique table locations for every table.", location));
            }
            return this.newWritableTableHandle(tableMetadata.getTable(), this.transaction.table(), retryMode);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed checking new table's location: " + location, (Throwable)e);
        }
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        if (fragments.isEmpty()) {
            AppendFiles appendFiles = this.transaction.newFastAppend();
            IcebergUtil.commit(appendFiles, session);
            this.transaction.commitTransaction();
            this.transaction = null;
            return Optional.empty();
        }
        return this.finishInsert(session, (IcebergWritableTableHandle)tableHandle, fragments, computedStatistics);
    }

    public Optional<ConnectorTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Schema schema = SchemaParser.fromJson((String)table.getTableSchemaJson());
        PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)table.getPartitionSpecJson().orElseThrow(() -> new VerifyException("Partition spec missing in the table handle")));
        return this.getWriteLayout(schema, partitionSpec, false);
    }

    private Optional<ConnectorTableLayout> getWriteLayout(Schema tableSchema, PartitionSpec partitionSpec, boolean forceRepartitioning) {
        if (partitionSpec.isUnpartitioned()) {
            return Optional.empty();
        }
        IcebergMetadata.validateNotPartitionedByNestedField(tableSchema, partitionSpec);
        Map columnById = (Map)IcebergUtil.getColumns(tableSchema, this.typeManager).stream().collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getId, Function.identity()));
        List partitioningColumns = (List)partitionSpec.fields().stream().sorted(Comparator.comparing(PartitionField::sourceId)).map(field -> Objects.requireNonNull((IcebergColumnHandle)columnById.get(field.sourceId()), () -> "Cannot find source column for partitioning field " + field)).distinct().collect(ImmutableList.toImmutableList());
        List partitioningColumnNames = (List)partitioningColumns.stream().map(IcebergColumnHandle::getName).collect(ImmutableList.toImmutableList());
        if (!forceRepartitioning && partitionSpec.fields().stream().allMatch(field -> field.transform().isIdentity())) {
            return Optional.of(new ConnectorTableLayout(partitioningColumnNames));
        }
        IcebergPartitioningHandle partitioningHandle = new IcebergPartitioningHandle(PartitionFields.toPartitionFields(partitionSpec), partitioningColumns);
        return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitioningColumnNames, true));
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        IcebergMetadata.validateNotModifyingOldSnapshot(table, icebergTable);
        IcebergMetadata.validateNotPartitionedByNestedField(icebergTable.schema(), icebergTable.spec());
        this.beginTransaction(icebergTable);
        return this.newWritableTableHandle(table.getSchemaTableName(), icebergTable, retryMode);
    }

    private IcebergWritableTableHandle newWritableTableHandle(SchemaTableName name, Table table, RetryMode retryMode) {
        return new IcebergWritableTableHandle(name, SchemaParser.toJson((Schema)table.schema()), Maps.transformValues((Map)table.specs(), PartitionSpecParser::toJson), table.spec().specId(), IcebergMetadata.getSupportedSortFields(table.schema(), table.sortOrder()), IcebergUtil.getColumns(table.schema(), this.typeManager), table.location(), IcebergUtil.getFileFormat(table), table.properties(), retryMode);
    }

    private static List<TrinoSortField> getSupportedSortFields(Schema schema, SortOrder sortOrder) {
        if (!sortOrder.isSorted()) {
            return ImmutableList.of();
        }
        Set baseColumnFieldIds = (Set)schema.columns().stream().map(Types.NestedField::fieldId).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder sortFields = ImmutableList.builder();
        for (SortField sortField : sortOrder.fields()) {
            if (!sortField.transform().isIdentity() || !baseColumnFieldIds.contains(sortField.sourceId())) continue;
            sortFields.add((Object)TrinoSortField.fromIceberg(sortField));
        }
        return sortFields.build();
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        if (commitTasks.isEmpty()) {
            this.transaction = null;
            return Optional.empty();
        }
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        Table icebergTable = this.transaction.table();
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = IcebergSessionProperties.isMergeManifestsOnWrite(session) ? this.transaction.newAppend() : this.transaction.newFastAppend();
        ImmutableSet.Builder writtenFiles = ImmutableSet.builder();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.getPath()).withFileSizeInBytes(task.getFileSizeInBytes()).withFormat(table.getFileFormat().toIceberg()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
            writtenFiles.add((Object)task.getPath());
        }
        if (table.getRetryMode() != RetryMode.NO_RETRIES) {
            this.cleanExtraOutputFiles(session, (Set<String>)writtenFiles.build());
        }
        IcebergUtil.commit(appendFiles, session);
        this.transaction.commitTransaction();
        this.transaction = null;
        return Optional.of(new HiveWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::getPath).collect(ImmutableList.toImmutableList())));
    }

    private void cleanExtraOutputFiles(ConnectorSession session, Set<String> writtenFiles) {
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        Set<String> locations = IcebergMetadata.getOutputFilesLocations(writtenFiles);
        Set<String> fileNames = IcebergMetadata.getOutputFilesFileNames(writtenFiles);
        for (String location : locations) {
            IcebergMetadata.cleanExtraOutputFiles(fileSystem, session.getQueryId(), location, fileNames);
        }
    }

    private static void cleanExtraOutputFiles(TrinoFileSystem fileSystem, String queryId, String location, Set<String> fileNamesToKeep) {
        Preconditions.checkArgument((!queryId.contains("-") ? 1 : 0) != 0, (String)"query ID should not contain hyphens: %s", (Object)queryId);
        ArrayDeque<String> filesToDelete = new ArrayDeque<String>();
        try {
            ImmutableList deletedFiles;
            log.debug("Deleting failed attempt files from %s for query %s", new Object[]{location, queryId});
            FileIterator iterator = fileSystem.listFiles(location);
            while (iterator.hasNext()) {
                FileEntry entry = iterator.next();
                String name = IcebergUtil.fileName(entry.location());
                if (!name.startsWith(queryId + "-") || fileNamesToKeep.contains(name)) continue;
                filesToDelete.add(name);
            }
            if (filesToDelete.isEmpty()) {
                return;
            }
            log.info("Found %s files to delete and %s to retain in location %s for query %s", new Object[]{filesToDelete.size(), fileNamesToKeep.size(), location, queryId});
            ImmutableList.Builder deletedFilesBuilder = ImmutableList.builder();
            Iterator filesToDeleteIterator = filesToDelete.iterator();
            ArrayList<CallSite> deleteBatch = new ArrayList<CallSite>();
            while (filesToDeleteIterator.hasNext()) {
                String fileName = (String)filesToDeleteIterator.next();
                deletedFilesBuilder.add((Object)fileName);
                filesToDeleteIterator.remove();
                deleteBatch.add((CallSite)((Object)(location + "/" + fileName)));
                if (deleteBatch.size() < DELETE_BATCH_SIZE) continue;
                log.debug("Deleting failed attempt files %s for query %s", new Object[]{deleteBatch, queryId});
                fileSystem.deleteFiles(deleteBatch);
                deleteBatch.clear();
            }
            if (!deleteBatch.isEmpty()) {
                log.debug("Deleting failed attempt files %s for query %s", new Object[]{deleteBatch, queryId});
                fileSystem.deleteFiles(deleteBatch);
            }
            if (!(deletedFiles = deletedFilesBuilder.build()).isEmpty()) {
                log.info("Deleted failed attempt files %s from %s for query %s", new Object[]{deletedFiles, location, queryId});
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Could not clean up extraneous output files; remaining files: %s", filesToDelete), (Throwable)e);
        }
    }

    private static Set<String> getOutputFilesLocations(Set<String> writtenFiles) {
        return (Set)writtenFiles.stream().map(IcebergMetadata::getLocation).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<String> getOutputFilesFileNames(Set<String> writtenFiles) {
        return (Set)writtenFiles.stream().map(IcebergUtil::fileName).collect(ImmutableSet.toImmutableSet());
    }

    private static String getLocation(String path) {
        Matcher matcher = PATH_PATTERN.matcher(path);
        Verify.verify((boolean)matcher.matches(), (String)"path %s does not match pattern", (Object)path);
        return matcher.group(1);
    }

    public Optional<ConnectorTableExecuteHandle> getTableHandleForExecute(ConnectorSession session, ConnectorTableHandle connectorTableHandle, String procedureName, Map<String, Object> executeProperties, RetryMode retryMode) {
        IcebergTableProcedureId procedureId;
        IcebergTableHandle tableHandle = (IcebergTableHandle)connectorTableHandle;
        Preconditions.checkArgument((tableHandle.getTableType() == TableType.DATA ? 1 : 0) != 0, (String)"Cannot execute table procedure %s on non-DATA table: %s", (Object)procedureName, (Object)((Object)tableHandle.getTableType()));
        Table icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        if (tableHandle.getSnapshotId().isPresent() && tableHandle.getSnapshotId().get().longValue() != icebergTable.currentSnapshot().snapshotId()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot execute table procedure %s on old snapshot %s".formatted(procedureName, tableHandle.getSnapshotId().get()));
        }
        try {
            procedureId = IcebergTableProcedureId.valueOf(procedureName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown procedure '" + procedureName + "'");
        }
        return switch (procedureId) {
            default -> throw new IncompatibleClassChangeError();
            case IcebergTableProcedureId.OPTIMIZE -> this.getTableHandleForOptimize(tableHandle, executeProperties, retryMode);
            case IcebergTableProcedureId.DROP_EXTENDED_STATS -> this.getTableHandleForDropExtendedStats(session, tableHandle);
            case IcebergTableProcedureId.EXPIRE_SNAPSHOTS -> this.getTableHandleForExpireSnapshots(session, tableHandle, executeProperties);
            case IcebergTableProcedureId.REMOVE_ORPHAN_FILES -> this.getTableHandleForRemoveOrphanFiles(session, tableHandle, executeProperties);
        };
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForOptimize(IcebergTableHandle tableHandle, Map<String, Object> executeProperties, RetryMode retryMode) {
        DataSize maxScannedFileSize = (DataSize)executeProperties.get("file_size_threshold");
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.OPTIMIZE, new IcebergOptimizeHandle(tableHandle.getSnapshotId(), tableHandle.getTableSchemaJson(), tableHandle.getPartitionSpecJson().orElseThrow(() -> new VerifyException("Partition spec missing in the table handle")), IcebergUtil.getColumns(SchemaParser.fromJson((String)tableHandle.getTableSchemaJson()), this.typeManager), tableHandle.getSortOrder(), IcebergUtil.getFileFormat(tableHandle.getStorageProperties()), tableHandle.getStorageProperties(), maxScannedFileSize, retryMode != RetryMode.NO_RETRIES), tableHandle.getTableLocation()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForDropExtendedStats(ConnectorSession session, IcebergTableHandle tableHandle) {
        Table icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.DROP_EXTENDED_STATS, new IcebergDropExtendedStatsHandle(), icebergTable.location()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForExpireSnapshots(ConnectorSession session, IcebergTableHandle tableHandle, Map<String, Object> executeProperties) {
        Duration retentionThreshold = (Duration)executeProperties.get(RETENTION_THRESHOLD);
        Table icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.EXPIRE_SNAPSHOTS, new IcebergExpireSnapshotsHandle(retentionThreshold), icebergTable.location()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForRemoveOrphanFiles(ConnectorSession session, IcebergTableHandle tableHandle, Map<String, Object> executeProperties) {
        Duration retentionThreshold = (Duration)executeProperties.get(RETENTION_THRESHOLD);
        Table icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.REMOVE_ORPHAN_FILES, new IcebergRemoveOrphanFilesHandle(retentionThreshold), icebergTable.location()));
    }

    public Optional<ConnectorTableLayout> getLayoutForTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                return this.getLayoutForOptimize(session, executeHandle);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private Optional<ConnectorTableLayout> getLayoutForOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        Table icebergTable = this.catalog.loadTable(session, executeHandle.getSchemaTableName());
        return this.getWriteLayout(icebergTable.schema(), icebergTable.spec(), true);
    }

    public BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorTableHandle updatedSourceTableHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        IcebergTableHandle table = (IcebergTableHandle)updatedSourceTableHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                return this.beginOptimize(session, executeHandle, table);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle, IcebergTableHandle table) {
        IcebergOptimizeHandle optimizeHandle = (IcebergOptimizeHandle)executeHandle.getProcedureHandle();
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        IcebergMetadata.validateNotModifyingOldSnapshot(table, icebergTable);
        IcebergMetadata.validateNotPartitionedByNestedField(icebergTable.schema(), icebergTable.spec());
        int tableFormatVersion = ((BaseTable)icebergTable).operations().current().formatVersion();
        if (tableFormatVersion > 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("%s is not supported for Iceberg table format version > %d. Table %s format version is %s.", IcebergTableProcedureId.OPTIMIZE.name(), 2, table.getSchemaTableName(), tableFormatVersion));
        }
        this.beginTransaction(icebergTable);
        return new BeginTableExecuteResult((Object)executeHandle, (Object)table.forOptimize(true, optimizeHandle.getMaxScannedFileSize()));
    }

    public void finishTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                this.finishOptimize(session, executeHandle, fragments, splitSourceInfo);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private void finishOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        IcebergOptimizeHandle optimizeHandle = (IcebergOptimizeHandle)executeHandle.getProcedureHandle();
        Table icebergTable = this.transaction.table();
        ImmutableSet.Builder scannedDataFilesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder scannedDeleteFilesBuilder = ImmutableSet.builder();
        splitSourceInfo.stream().map(DataFileWithDeleteFiles.class::cast).forEach(dataFileWithDeleteFiles -> {
            scannedDataFilesBuilder.add((Object)dataFileWithDeleteFiles.getDataFile());
            scannedDeleteFilesBuilder.addAll(dataFileWithDeleteFiles.getDeleteFiles());
        });
        ImmutableSet scannedDataFiles = scannedDataFilesBuilder.build();
        ImmutableSet fullyAppliedDeleteFiles = scannedDeleteFilesBuilder.build();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        HashSet<DataFile> newFiles = new HashSet<DataFile>();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.getPath()).withFileSizeInBytes(task.getFileSizeInBytes()).withFormat(optimizeHandle.getFileFormat().toIceberg()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            newFiles.add(builder.build());
        }
        if (optimizeHandle.getSnapshotId().isEmpty() || scannedDataFiles.isEmpty() && fullyAppliedDeleteFiles.isEmpty() && newFiles.isEmpty()) {
            this.transaction = null;
            return;
        }
        if (optimizeHandle.isRetriesEnabled()) {
            this.cleanExtraOutputFiles(session, (Set)newFiles.stream().map(dataFile -> dataFile.path().toString()).collect(ImmutableSet.toImmutableSet()));
        }
        RewriteFiles rewriteFiles = this.transaction.newRewrite();
        rewriteFiles.rewriteFiles((Set)scannedDataFiles, (Set)fullyAppliedDeleteFiles, newFiles, (Set)ImmutableSet.of());
        Snapshot snapshot = Objects.requireNonNull(icebergTable.snapshot(optimizeHandle.getSnapshotId().get().longValue()), "snapshot is null");
        rewriteFiles.validateFromSnapshot(snapshot.snapshotId());
        IcebergUtil.commit(rewriteFiles, session);
        this.transaction.commitTransaction();
        this.transaction = null;
    }

    public void executeTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case DROP_EXTENDED_STATS: {
                this.executeDropExtendedStats(session, executeHandle);
                return;
            }
            case EXPIRE_SNAPSHOTS: {
                this.executeExpireSnapshots(session, executeHandle);
                return;
            }
            case REMOVE_ORPHAN_FILES: {
                this.executeRemoveOrphanFiles(session, executeHandle);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private void executeDropExtendedStats(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        Preconditions.checkArgument((boolean)(executeHandle.getProcedureHandle() instanceof IcebergDropExtendedStatsHandle), (String)"Unexpected procedure handle %s", (Object)executeHandle.getProcedureHandle());
        Table icebergTable = this.catalog.loadTable(session, executeHandle.getSchemaTableName());
        this.beginTransaction(icebergTable);
        UpdateStatistics updateStatistics = this.transaction.updateStatistics();
        for (StatisticsFile statisticsFile : icebergTable.statisticsFiles()) {
            updateStatistics.removeStatistics(statisticsFile.snapshotId());
        }
        updateStatistics.commit();
        UpdateProperties updateProperties = this.transaction.updateProperties();
        for (String key : this.transaction.table().properties().keySet()) {
            if (!key.startsWith("trino.stats.ndv.")) continue;
            updateProperties.remove(key);
        }
        updateProperties.commit();
        this.transaction.commitTransaction();
        this.transaction = null;
    }

    private void executeExpireSnapshots(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        IcebergExpireSnapshotsHandle expireSnapshotsHandle = (IcebergExpireSnapshotsHandle)executeHandle.getProcedureHandle();
        Table table = this.catalog.loadTable(session, executeHandle.getSchemaTableName());
        Duration retention = Objects.requireNonNull(expireSnapshotsHandle.getRetentionThreshold(), "retention is null");
        IcebergMetadata.validateTableExecuteParameters(table, executeHandle.getSchemaTableName(), IcebergTableProcedureId.EXPIRE_SNAPSHOTS.name(), retention, IcebergSessionProperties.getExpireSnapshotMinRetention(session), "iceberg.expire_snapshots.min-retention", "expire_snapshots_min_retention");
        long expireTimestampMillis = session.getStart().toEpochMilli() - retention.toMillis();
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        ArrayList pathsToDelete = new ArrayList();
        Consumer<String> deleteFunction = path -> {
            pathsToDelete.add(path);
            if (pathsToDelete.size() == DELETE_BATCH_SIZE.intValue()) {
                try {
                    fileSystem.deleteFiles((Collection)pathsToDelete);
                    pathsToDelete.clear();
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed to delete files during snapshot expiration", (Throwable)e);
                }
            }
        };
        table.expireSnapshots().expireOlderThan(expireTimestampMillis).deleteWith(deleteFunction).commit();
        try {
            fileSystem.deleteFiles(pathsToDelete);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed to delete files during snapshot expiration", (Throwable)e);
        }
    }

    private static void validateTableExecuteParameters(Table table, SchemaTableName schemaTableName, String procedureName, Duration retentionThreshold, Duration minRetention, String minRetentionParameterName, String sessionMinRetentionParameterName) {
        int tableFormatVersion = ((BaseTable)table).operations().current().formatVersion();
        if (tableFormatVersion > 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("%s is not supported for Iceberg table format version > %d. Table %s format version is %s.", procedureName, 2, schemaTableName, tableFormatVersion));
        }
        Map properties = table.properties();
        if (properties.containsKey("write.location-provider.impl")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table " + schemaTableName + " specifies " + (String)properties.get("write.location-provider.impl") + " as a location provider. Writing to Iceberg tables with custom location provider is not supported.");
        }
        Duration retention = Objects.requireNonNull(retentionThreshold, "retention is null");
        Procedures.checkProcedureArgument((retention.compareTo(minRetention) >= 0 ? 1 : 0) != 0, (String)"Retention specified (%s) is shorter than the minimum retention configured in the system (%s). Minimum retention can be changed with %s configuration property or iceberg.%s session property", (Object[])new Object[]{retention, minRetention, minRetentionParameterName, sessionMinRetentionParameterName});
    }

    public void executeRemoveOrphanFiles(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        IcebergRemoveOrphanFilesHandle removeOrphanFilesHandle = (IcebergRemoveOrphanFilesHandle)executeHandle.getProcedureHandle();
        Table table = this.catalog.loadTable(session, executeHandle.getSchemaTableName());
        Duration retention = Objects.requireNonNull(removeOrphanFilesHandle.getRetentionThreshold(), "retention is null");
        IcebergMetadata.validateTableExecuteParameters(table, executeHandle.getSchemaTableName(), IcebergTableProcedureId.REMOVE_ORPHAN_FILES.name(), retention, IcebergSessionProperties.getRemoveOrphanFilesMinRetention(session), "iceberg.remove_orphan_files.min-retention", "remove_orphan_files_min_retention");
        if (table.currentSnapshot() == null) {
            log.debug("Skipping remove_orphan_files procedure for empty table %s", new Object[]{table});
            return;
        }
        Instant expiration = session.getStart().minusMillis(retention.toMillis());
        this.removeOrphanFiles(table, session, executeHandle.getSchemaTableName(), expiration);
    }

    private void removeOrphanFiles(Table table, ConnectorSession session, SchemaTableName schemaTableName, Instant expiration) {
        HashSet<String> processedManifestFilePaths = new HashSet<String>();
        ImmutableSet.Builder validMetadataFileNames = ImmutableSet.builder();
        ImmutableSet.Builder validDataFileNames = ImmutableSet.builder();
        for (Snapshot snapshot : table.snapshots()) {
            if (snapshot.manifestListLocation() != null) {
                validMetadataFileNames.add((Object)IcebergUtil.fileName(snapshot.manifestListLocation()));
            }
            for (ManifestFile manifest : snapshot.allManifests(table.io())) {
                if (!processedManifestFilePaths.add(manifest.path())) continue;
                validMetadataFileNames.add((Object)IcebergUtil.fileName(manifest.path()));
                try {
                    ManifestReader<? extends ContentFile<?>> manifestReader = IcebergMetadata.readerForManifest(table, manifest);
                    try {
                        for (ContentFile contentFile : manifestReader) {
                            validDataFileNames.add((Object)IcebergUtil.fileName(contentFile.path().toString()));
                        }
                    }
                    finally {
                        if (manifestReader == null) continue;
                        manifestReader.close();
                    }
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Unable to list manifest file content from " + manifest.path(), (Throwable)e);
                }
            }
        }
        ReachableFileUtil.metadataFileLocations((Table)table, (boolean)false).stream().map(IcebergUtil::fileName).forEach(arg_0 -> ((ImmutableSet.Builder)validMetadataFileNames).add(arg_0));
        validMetadataFileNames.add((Object)IcebergUtil.fileName(ReachableFileUtil.versionHintLocation((Table)table)));
        this.scanAndDeleteInvalidFiles(table, session, schemaTableName, expiration, (Set<String>)validDataFileNames.build(), "data");
        this.scanAndDeleteInvalidFiles(table, session, schemaTableName, expiration, (Set<String>)validMetadataFileNames.build(), "metadata");
    }

    private static ManifestReader<? extends ContentFile<?>> readerForManifest(Table table, ManifestFile manifest) {
        return switch (manifest.content()) {
            default -> throw new IncompatibleClassChangeError();
            case ManifestContent.DATA -> ManifestFiles.read((ManifestFile)manifest, (FileIO)table.io());
            case ManifestContent.DELETES -> ManifestFiles.readDeleteManifest((ManifestFile)manifest, (FileIO)table.io(), (Map)table.specs());
        };
    }

    private void scanAndDeleteInvalidFiles(Table table, ConnectorSession session, SchemaTableName schemaTableName, Instant expiration, Set<String> validFiles, String subfolder) {
        try {
            ArrayList<String> filesToDelete = new ArrayList<String>();
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            FileIterator allFiles = fileSystem.listFiles(table.location() + "/" + subfolder);
            while (allFiles.hasNext()) {
                FileEntry entry = allFiles.next();
                if (entry.lastModified().isBefore(expiration) && !validFiles.contains(IcebergUtil.fileName(entry.location()))) {
                    filesToDelete.add(entry.location());
                    if (filesToDelete.size() < DELETE_BATCH_SIZE) continue;
                    log.debug("Deleting files while removing orphan files for table %s [%s]", new Object[]{schemaTableName, filesToDelete});
                    fileSystem.deleteFiles(filesToDelete);
                    filesToDelete.clear();
                    continue;
                }
                log.debug("%s file retained while removing orphan files %s", new Object[]{entry.location(), schemaTableName.getTableName()});
            }
            if (!filesToDelete.isEmpty()) {
                log.debug("Deleting files while removing orphan files for table %s %s", new Object[]{schemaTableName, filesToDelete});
                fileSystem.deleteFiles(filesToDelete);
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed accessing data for table: " + schemaTableName, (Throwable)e);
        }
    }

    public Optional<Object> getInfo(ConnectorTableHandle tableHandle) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        Optional<Boolean> partitioned = icebergTableHandle.getPartitionSpecJson().map(partitionSpecJson -> PartitionSpecParser.fromJson((Schema)SchemaParser.fromJson((String)icebergTableHandle.getTableSchemaJson()), (String)partitionSpecJson).isPartitioned());
        return Optional.of(new IcebergInputInfo(icebergTableHandle.getSnapshotId(), partitioned, IcebergUtil.getFileFormat(icebergTableHandle.getStorageProperties()).name()));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.catalog.dropTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTable) {
        this.catalog.renameTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName(), newTable);
    }

    public void setTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Optional<Object>> properties) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Sets.SetView unsupportedProperties = Sets.difference(properties.keySet(), UPDATABLE_TABLE_PROPERTIES);
        if (!unsupportedProperties.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The following properties cannot be updated: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)unsupportedProperties));
        }
        this.beginTransaction(icebergTable);
        UpdateProperties updateProperties = this.transaction.updateProperties();
        if (properties.containsKey("format")) {
            IcebergFileFormat fileFormat = (IcebergFileFormat)((Object)properties.get("format").orElseThrow(() -> new IllegalArgumentException("The format property cannot be empty")));
            updateProperties.defaultFormat(fileFormat.toIceberg());
        }
        if (properties.containsKey("format_version")) {
            int formatVersion = (Integer)properties.get("format_version").orElseThrow(() -> new IllegalArgumentException("The format_version property cannot be empty"));
            updateProperties.set("format-version", Integer.toString(formatVersion));
        }
        try {
            updateProperties.commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to set new property values", (Throwable)e);
        }
        if (properties.containsKey("partitioning")) {
            List partitionColumns = (List)properties.get("partitioning").orElseThrow(() -> new IllegalArgumentException("The partitioning property cannot be empty"));
            IcebergMetadata.updatePartitioning(icebergTable, this.transaction, partitionColumns);
        }
        if (properties.containsKey("sorted_by")) {
            List sortColumns = (List)properties.get("sorted_by").orElseThrow(() -> new IllegalArgumentException("The sorted_by property cannot be empty"));
            ReplaceSortOrder replaceSortOrder = this.transaction.replaceSortOrder();
            SortFieldUtils.parseSortFields(replaceSortOrder, (List<String>)sortColumns);
            try {
                replaceSortOrder.commit();
            }
            catch (RuntimeException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to set the sorted_by property", (Throwable)e);
            }
        }
        try {
            this.transaction.commitTransaction();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to commit new table properties", (Throwable)e);
        }
    }

    private static void updatePartitioning(Table icebergTable, Transaction transaction, List<String> partitionColumns) {
        UpdatePartitionSpec updatePartitionSpec = transaction.updateSpec();
        ImmutableSet existingPartitionFields = ImmutableSet.copyOf((Collection)icebergTable.spec().fields());
        Schema schema = icebergTable.schema();
        if (partitionColumns.isEmpty()) {
            existingPartitionFields.stream().map(partitionField -> IcebergMetadata.toIcebergTerm(schema, partitionField)).forEach(arg_0 -> ((UpdatePartitionSpec)updatePartitionSpec).removeField(arg_0));
        } else {
            PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, partitionColumns);
            IcebergMetadata.validateNotPartitionedByNestedField(schema, partitionSpec);
            ImmutableSet partitionFields = ImmutableSet.copyOf((Collection)partitionSpec.fields());
            Sets.difference((Set)existingPartitionFields, (Set)partitionFields).stream().map(PartitionField::name).forEach(arg_0 -> ((UpdatePartitionSpec)updatePartitionSpec).removeField(arg_0));
            Sets.difference((Set)partitionFields, (Set)existingPartitionFields).stream().map(partitionField -> IcebergMetadata.toIcebergTerm(schema, partitionField)).forEach(arg_0 -> ((UpdatePartitionSpec)updatePartitionSpec).addField(arg_0));
        }
        try {
            updatePartitionSpec.commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to set new partitioning value", (Throwable)e);
        }
    }

    private static Term toIcebergTerm(Schema schema, PartitionField partitionField) {
        return Expressions.transform((String)schema.findColumnName(partitionField.sourceId()), (Transform)partitionField.transform());
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        if (!column.isNullable()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding not null columns");
        }
        Table icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        AtomicInteger nextFieldId = new AtomicInteger(icebergTable.schema().highestFieldId() + 2);
        try {
            icebergTable.updateSchema().addColumn(column.getName(), TypeConverter.toIcebergTypeForNewColumn(column.getType(), nextFieldId), column.getComment()).commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to add column: " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
        }
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        IcebergColumnHandle handle = (IcebergColumnHandle)column;
        this.dropField(session, tableHandle, handle.getName());
    }

    public void dropField(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, List<String> fieldPath) {
        IcebergColumnHandle handle = (IcebergColumnHandle)column;
        String name = String.join((CharSequence)".", (Iterable<? extends CharSequence>)ImmutableList.builder().add((Object)handle.getName()).addAll(fieldPath).build());
        this.dropField(session, tableHandle, name);
    }

    private void dropField(ConnectorSession session, ConnectorTableHandle tableHandle, String name) {
        Table icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        long fieldId = icebergTable.schema().findField(name).fieldId();
        boolean isPartitionColumn = icebergTable.spec().fields().stream().anyMatch(field -> (long)field.sourceId() == fieldId);
        if (isPartitionColumn) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop partition field: " + name);
        }
        int currentSpecId = icebergTable.spec().specId();
        boolean columnUsedInOlderPartitionSpecs = icebergTable.specs().entrySet().stream().filter(spec -> ((PartitionSpec)spec.getValue()).specId() != currentSpecId).flatMap(spec -> ((PartitionSpec)spec.getValue()).fields().stream()).anyMatch(field -> (long)field.sourceId() == fieldId);
        if (columnUsedInOlderPartitionSpecs) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop column which is used by an old partition spec: " + name);
        }
        try {
            icebergTable.updateSchema().deleteColumn(name).commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to drop column: " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
        }
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        IcebergColumnHandle columnHandle = (IcebergColumnHandle)source;
        Table icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        try {
            icebergTable.updateSchema().renameColumn(columnHandle.getName(), target).commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to rename column: " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
        }
    }

    public void setColumnType(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, io.trino.spi.type.Type type) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        IcebergColumnHandle column = (IcebergColumnHandle)columnHandle;
        Verify.verify((boolean)column.isBaseColumn(), (String)"Cannot change nested field types", (Object[])new Object[0]);
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Type sourceType = icebergTable.schema().findType(column.getName());
        AtomicInteger nextFieldId = new AtomicInteger(1);
        Type newType = TypeConverter.toIcebergTypeForNewColumn(type, nextFieldId);
        try {
            UpdateSchema schemaUpdate = icebergTable.updateSchema();
            IcebergMetadata.buildUpdateSchema(column.getName(), sourceType, newType, schemaUpdate);
            schemaUpdate.commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to set column type: " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
        }
    }

    private static void buildUpdateSchema(String name, Type sourceType, Type newType, UpdateSchema schemaUpdate) {
        if (sourceType.equals(newType)) {
            return;
        }
        if (sourceType.isPrimitiveType() && newType.isPrimitiveType()) {
            schemaUpdate.updateColumn(name, newType.asPrimitiveType());
            return;
        }
        if (sourceType instanceof Types.StructType) {
            Types.StructType sourceRowType = (Types.StructType)sourceType;
            if (newType instanceof Types.StructType) {
                Types.StructType newRowType = (Types.StructType)newType;
                List fields = (List)Streams.concat((Stream[])new Stream[]{sourceRowType.fields().stream(), newRowType.fields().stream()}).distinct().collect(ImmutableList.toImmutableList());
                for (Types.NestedField field : fields) {
                    if (IcebergMetadata.fieldExists(sourceRowType, field.name()) && IcebergMetadata.fieldExists(newRowType, field.name())) {
                        IcebergMetadata.buildUpdateSchema(name + "." + field.name(), sourceRowType.fieldType(field.name()), newRowType.fieldType(field.name()), schemaUpdate);
                        continue;
                    }
                    if (IcebergMetadata.fieldExists(newRowType, field.name())) {
                        schemaUpdate.addColumn(name, field.name(), field.type());
                        continue;
                    }
                    schemaUpdate.deleteColumn(name + "." + field.name());
                }
                String currentName = null;
                for (Types.NestedField field : newRowType.fields()) {
                    String path = name + "." + field.name();
                    if (currentName == null) {
                        schemaUpdate.moveFirst(path);
                    } else {
                        schemaUpdate.moveAfter(path, currentName);
                    }
                    currentName = path;
                }
                return;
            }
        }
        throw new IllegalArgumentException("Cannot change type from %s to %s".formatted(sourceType, newType));
    }

    private static boolean fieldExists(Types.StructType structType, String fieldName) {
        for (Types.NestedField field : structType.fields()) {
            if (!field.name().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private List<ColumnMetadata> getColumnMetadatas(Schema schema) {
        ImmutableList.Builder columns = ImmutableList.builder();
        List schemaColumns = (List)schema.columns().stream().map(column -> ColumnMetadata.builder().setName(column.name()).setType(TypeConverter.toTrinoType(column.type(), this.typeManager)).setNullable(column.isOptional()).setComment(Optional.ofNullable(column.doc())).build()).collect(ImmutableList.toImmutableList());
        columns.addAll((Iterable)schemaColumns);
        columns.add((Object)IcebergColumnHandle.pathColumnMetadata());
        columns.add((Object)IcebergColumnHandle.fileModifiedTimeColumnMetadata());
        return columns.build();
    }

    public ConnectorAnalyzeMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Object> analyzeProperties) {
        if (!IcebergSessionProperties.isExtendedStatisticsEnabled(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Analyze is not enabled. You can enable analyze using %s config or %s catalog session property".formatted("iceberg.extended-statistics.enabled", "extended_statistics_enabled"));
        }
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Preconditions.checkArgument((handle.getTableType() == TableType.DATA ? 1 : 0) != 0, (String)"Cannot analyze non-DATA table: %s", (Object)((Object)handle.getTableType()));
        if (handle.getSnapshotId().isEmpty()) {
            return new ConnectorAnalyzeMetadata(tableHandle, TableStatisticsMetadata.empty());
        }
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, handle);
        Set allScalarColumnNames = (Set)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).filter(column -> column.getType().getTypeParameters().isEmpty()).map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
        Set analyzeColumnNames = IcebergAnalyzeProperties.getColumnNames(analyzeProperties).map(columnNames -> {
            if (columnNames.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Cannot specify empty list of columns for analysis");
            }
            if (!allScalarColumnNames.containsAll((Collection<?>)columnNames)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, String.format("Invalid columns specified for analysis: %s", Sets.difference((Set)columnNames, (Set)allScalarColumnNames)));
            }
            return columnNames;
        }).orElse(allScalarColumnNames);
        Set columnStatistics = (Set)tableMetadata.getColumns().stream().filter(column -> analyzeColumnNames.contains(column.getName())).map(column -> new ColumnStatisticMetadata(column.getName(), NUMBER_OF_DISTINCT_VALUES_NAME, NUMBER_OF_DISTINCT_VALUES_FUNCTION)).collect(ImmutableSet.toImmutableSet());
        return new ConnectorAnalyzeMetadata(tableHandle, new TableStatisticsMetadata(columnStatistics, (Set)ImmutableSet.of(), (List)ImmutableList.of()));
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, handle.getSchemaTableName());
        this.beginTransaction(icebergTable);
        return handle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table table = this.transaction.table();
        if (handle.getSnapshotId().isEmpty()) {
            Verify.verify((boolean)computedStatistics.isEmpty(), (String)"Unexpected computed statistics that cannot be attached to a snapshot because none exists: %s", computedStatistics);
            UpdateProperties updateProperties = this.transaction.updateProperties();
            table.properties().keySet().stream().filter(key -> key.startsWith("trino.stats.ndv.")).forEach(arg_0 -> ((UpdateProperties)updateProperties).remove(arg_0));
            updateProperties.commit();
            this.transaction.commitTransaction();
            this.transaction = null;
            return;
        }
        long snapshotId = handle.getSnapshotId().orElseThrow();
        Map columnNameToId = (Map)table.schema().columns().stream().collect(ImmutableMap.toImmutableMap(nestedField -> nestedField.name().toLowerCase(Locale.ENGLISH), Types.NestedField::fieldId));
        ImmutableSet columnIds = ImmutableSet.copyOf(columnNameToId.values());
        UpdateProperties updateProperties = this.transaction.updateProperties();
        table.properties().keySet().stream().filter(arg_0 -> IcebergMetadata.lambda$finishStatisticsCollection$42((Set)columnIds, arg_0)).forEach(arg_0 -> ((UpdateProperties)updateProperties).remove(arg_0));
        updateProperties.commit();
        ImmutableMap.Builder ndvSketches = ImmutableMap.builder();
        for (ComputedStatistics computedStatistic : computedStatistics) {
            Verify.verify((computedStatistic.getGroupingColumns().isEmpty() && computedStatistic.getGroupingValues().isEmpty() ? 1 : 0) != 0, (String)"Unexpected grouping", (Object[])new Object[0]);
            Verify.verify((boolean)computedStatistic.getTableStatistics().isEmpty(), (String)"Unexpected table statistics", (Object[])new Object[0]);
            for (Map.Entry entry : computedStatistic.getColumnStatistics().entrySet()) {
                ColumnStatisticMetadata statisticMetadata = (ColumnStatisticMetadata)entry.getKey();
                if (statisticMetadata.getConnectorAggregationId().equals(NUMBER_OF_DISTINCT_VALUES_NAME)) {
                    Integer columnId = (Integer)Verify.verifyNotNull((Object)((Integer)columnNameToId.get(statisticMetadata.getColumnName())), (String)"Column not found in table: [%s]", (Object[])new Object[]{statisticMetadata.getColumnName()});
                    CompactSketch sketch = DataSketchStateSerializer.deserialize((Block)entry.getValue(), 0);
                    ndvSketches.put((Object)columnId, (Object)sketch);
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported statistic: " + statisticMetadata);
            }
        }
        StatisticsFile statisticsFile = this.tableStatisticsWriter.writeStatisticsFile(session, table, snapshotId, (Map<Integer, CompactSketch>)ndvSketches.buildOrThrow());
        this.transaction.updateStatistics().setStatistics(snapshotId, statisticsFile).commit();
        this.transaction.commitTransaction();
        this.transaction = null;
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        IcebergTableHandle table = (IcebergTableHandle)handle;
        TupleDomain medataColumnPredicate = table.getEnforcedPredicate().filter((column, domain) -> IcebergMetadataColumn.isMetadataColumnId(column.getId()));
        if (!medataColumnPredicate.isAll()) {
            return Optional.empty();
        }
        return Optional.of(handle);
    }

    public RowChangeParadigm getRowChangeParadigm(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW;
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Types.StructType type = Types.StructType.of((List)ImmutableList.builder().add((Object)MetadataColumns.FILE_PATH).add((Object)MetadataColumns.ROW_POSITION).add((Object)Types.NestedField.required((int)-2147483646, (String)"file_record_count", (Type)Types.LongType.get())).add((Object)Types.NestedField.required((int)-2147483645, (String)"partition_spec_id", (Type)Types.IntegerType.get())).add((Object)Types.NestedField.required((int)-2147483644, (String)"partition_data", (Type)Types.StringType.get())).build());
        Types.NestedField field = Types.NestedField.required((int)-2147483647, (String)"$row_id", (Type)type);
        return IcebergUtil.getColumnHandle(field, this.typeManager);
    }

    public Optional<ConnectorPartitioningHandle> getUpdateLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return Optional.of(IcebergUpdateHandle.INSTANCE);
    }

    public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        IcebergMetadata.verifyTableVersionForUpdate(table);
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        IcebergMetadata.validateNotModifyingOldSnapshot(table, icebergTable);
        IcebergMetadata.validateNotPartitionedByNestedField(icebergTable.schema(), icebergTable.spec());
        this.beginTransaction(icebergTable);
        IcebergTableHandle newTableHandle = table.withRetryMode(retryMode);
        IcebergWritableTableHandle insertHandle = this.newWritableTableHandle(table.getSchemaTableName(), icebergTable, retryMode);
        return new IcebergMergeTableHandle(newTableHandle, insertHandle);
    }

    public void finishMerge(ConnectorSession session, ConnectorMergeTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        IcebergTableHandle handle = ((IcebergMergeTableHandle)tableHandle).getTableHandle();
        this.finishWrite(session, handle, fragments, true);
    }

    private static void verifyTableVersionForUpdate(IcebergTableHandle table) {
        if (table.getFormatVersion() < 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg table updates require at least format version 2");
        }
    }

    private static void validateNotModifyingOldSnapshot(IcebergTableHandle table, Table icebergTable) {
        if (table.getSnapshotId().isPresent() && table.getSnapshotId().get().longValue() != icebergTable.currentSnapshot().snapshotId()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Modifying old snapshot is not supported in Iceberg");
        }
    }

    public static void validateNotPartitionedByNestedField(Schema schema, PartitionSpec partitionSpec) {
        Map indexParents = TypeUtil.indexParents((Types.StructType)schema.asStruct());
        for (PartitionField field : partitionSpec.fields()) {
            if (!indexParents.containsKey(field.sourceId())) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Partitioning by nested field is unsupported: " + field.name());
        }
    }

    private void finishWrite(ConnectorSession session, IcebergTableHandle table, Collection<Slice> fragments, boolean runUpdateValidations) {
        Table icebergTable = this.transaction.table();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        if (commitTasks.isEmpty()) {
            this.transaction = null;
            return;
        }
        Schema schema = SchemaParser.fromJson((String)table.getTableSchemaJson());
        Map<String, List<CommitTaskData>> deletesByFilePath = commitTasks.stream().filter(task -> task.getContent() == FileContent.POSITION_DELETES).collect(Collectors.groupingBy(task -> task.getReferencedDataFile().orElseThrow()));
        Map fullyDeletedFiles = (Map)deletesByFilePath.entrySet().stream().filter(entry -> IcebergMetadata.fileIsFullyDeleted((List)entry.getValue())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!deletesByFilePath.keySet().equals(fullyDeletedFiles.keySet()) || commitTasks.stream().anyMatch(task -> task.getContent() == FileContent.DATA)) {
            IsolationLevel isolationLevel;
            RowDelta rowDelta = this.transaction.newRowDelta();
            table.getSnapshotId().map(arg_0 -> ((Table)icebergTable).snapshot(arg_0)).ifPresent(s -> rowDelta.validateFromSnapshot(s.snapshotId()));
            TupleDomain dataColumnPredicate = table.getEnforcedPredicate().filter((column, domain) -> !IcebergMetadataColumn.isMetadataColumnId(column.getId()));
            if (!dataColumnPredicate.isAll()) {
                rowDelta.conflictDetectionFilter(ExpressionConverter.toIcebergExpression((TupleDomain<IcebergColumnHandle>)dataColumnPredicate));
            }
            if ((isolationLevel = IsolationLevel.fromName((String)icebergTable.properties().getOrDefault("write.delete.isolation-level", "serializable"))) == IsolationLevel.SERIALIZABLE) {
                rowDelta.validateNoConflictingDataFiles();
            }
            if (runUpdateValidations) {
                rowDelta.validateDeletedFiles();
                rowDelta.validateNoConflictingDeleteFiles();
            }
            ImmutableSet.Builder writtenFiles = ImmutableSet.builder();
            ImmutableSet.Builder referencedDataFiles = ImmutableSet.builder();
            block10: for (CommitTaskData task2 : commitTasks) {
                PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)task2.getPartitionSpecJson());
                Type[] partitionColumnTypes = (Type[])partitionSpec.fields().stream().map(field -> field.transform().getResultType(schema.findType(field.sourceId()))).toArray(Type[]::new);
                switch (task2.getContent()) {
                    case POSITION_DELETES: {
                        if (fullyDeletedFiles.containsKey(task2.getReferencedDataFile().orElseThrow())) continue block10;
                        FileMetadata.Builder deleteBuilder = FileMetadata.deleteFileBuilder((PartitionSpec)partitionSpec).withPath(task2.getPath()).withFormat(task2.getFileFormat().toIceberg()).ofPositionDeletes().withFileSizeInBytes(task2.getFileSizeInBytes()).withMetrics(task2.getMetrics().metrics());
                        if (!partitionSpec.fields().isEmpty()) {
                            String partitionDataJson = task2.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                            deleteBuilder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
                        }
                        rowDelta.addDeletes(deleteBuilder.build());
                        writtenFiles.add((Object)task2.getPath());
                        task2.getReferencedDataFile().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedDataFiles).add(arg_0));
                        continue block10;
                    }
                    case DATA: {
                        DataFiles.Builder builder = DataFiles.builder((PartitionSpec)partitionSpec).withPath(task2.getPath()).withFormat(task2.getFileFormat().toIceberg()).withFileSizeInBytes(task2.getFileSizeInBytes()).withMetrics(task2.getMetrics().metrics());
                        if (!icebergTable.spec().fields().isEmpty()) {
                            String partitionDataJson = task2.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                            builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
                        }
                        rowDelta.addRows(builder.build());
                        writtenFiles.add((Object)task2.getPath());
                        continue block10;
                    }
                }
                throw new UnsupportedOperationException("Unsupported task content: " + task2.getContent());
            }
            if (table.getRetryMode() != RetryMode.NO_RETRIES) {
                this.cleanExtraOutputFiles(session, (Set<String>)writtenFiles.build());
            }
            rowDelta.validateDataFilesExist((Iterable)referencedDataFiles.build());
            try {
                IcebergUtil.commit(rowDelta, session);
            }
            catch (ValidationException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to commit Iceberg update to table: " + table.getSchemaTableName(), (Throwable)e);
            }
        }
        if (!fullyDeletedFiles.isEmpty()) {
            try {
                TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
                fileSystem.deleteFiles((Collection)fullyDeletedFiles.values().stream().flatMap(Collection::stream).map(CommitTaskData::getPath).collect(ImmutableSet.toImmutableSet()));
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Failed to clean up uncommitted position delete files");
            }
        }
        try {
            if (!fullyDeletedFiles.isEmpty()) {
                DeleteFiles deleteFiles = this.transaction.newDelete();
                fullyDeletedFiles.keySet().forEach(arg_0 -> ((DeleteFiles)deleteFiles).deleteFile(arg_0));
                IcebergUtil.commit(deleteFiles, session);
            }
            this.transaction.commitTransaction();
        }
        catch (ValidationException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to commit Iceberg update to table: " + table.getSchemaTableName(), (Throwable)e);
        }
        this.transaction = null;
    }

    private static boolean fileIsFullyDeleted(List<CommitTaskData> positionDeletes) {
        Preconditions.checkArgument((!positionDeletes.isEmpty() ? 1 : 0) != 0, (Object)"Cannot call fileIsFullyDeletes with an empty list");
        String referencedDataFile = positionDeletes.get(0).getReferencedDataFile().orElseThrow();
        long fileRecordCount = positionDeletes.get(0).getFileRecordCount().orElseThrow();
        Preconditions.checkArgument((boolean)positionDeletes.stream().allMatch(positionDelete -> positionDelete.getReferencedDataFile().orElseThrow().equals(referencedDataFile) && positionDelete.getFileRecordCount().orElseThrow() == fileRecordCount), (Object)"All position deletes must be for the same file and have the same fileRecordCount");
        long deletedRowCount = positionDeletes.stream().map(CommitTaskData::getDeletedRowCount).mapToLong(Optional::orElseThrow).sum();
        Preconditions.checkState((deletedRowCount <= fileRecordCount ? 1 : 0) != 0, (Object)"Found more deleted rows than exist in the file");
        return fileRecordCount == deletedRowCount;
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        this.catalog.createView(session, viewName, definition, replace);
    }

    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.catalog.renameView(session, source, target);
    }

    public void setViewAuthorization(ConnectorSession session, SchemaTableName viewName, TrinoPrincipal principal) {
        this.catalog.setViewPrincipal(session, viewName, principal);
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        this.catalog.dropView(session, viewName);
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listViews(session, schemaName);
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.getViews(session, schemaName);
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return this.catalog.getView(session, viewName);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, handle.getSchemaTableName());
        DeleteFiles deleteFiles = icebergTable.newDelete().deleteFromRowFilter(ExpressionConverter.toIcebergExpression(handle.getEnforcedPredicate()));
        IcebergUtil.commit(deleteFiles, session);
        Map summary = icebergTable.currentSnapshot().summary();
        String deletedRowsStr = (String)summary.get("deleted-records");
        if (deletedRowsStr == null) {
            return OptionalLong.empty();
        }
        long deletedRecords = Long.parseLong(deletedRowsStr);
        long removedPositionDeletes = Long.parseLong(summary.getOrDefault("removed-position-deletes", "0"));
        long removedEqualityDeletes = Long.parseLong(summary.getOrDefault("removed-equality-deletes", "0"));
        return OptionalLong.of(deletedRecords - removedPositionDeletes - removedEqualityDeletes);
    }

    public void rollback() {
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        TupleDomain remainingConstraint;
        TupleDomain newUnenforcedConstraint;
        TupleDomain newEnforcedConstraint;
        IcebergTableHandle table = (IcebergTableHandle)handle;
        ConstraintExtractor.ExtractionResult extractionResult = ConstraintExtractor.extractTupleDomain(constraint);
        TupleDomain<IcebergColumnHandle> predicate = extractionResult.tupleDomain();
        if (predicate.isAll()) {
            return Optional.empty();
        }
        if (predicate.isNone()) {
            newEnforcedConstraint = TupleDomain.none();
            newUnenforcedConstraint = TupleDomain.all();
            remainingConstraint = TupleDomain.all();
        } else {
            Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
            Set partitionSpecIds = (Set)table.getSnapshotId().map(snapshot -> (ImmutableSet)icebergTable.snapshot(snapshot.longValue()).allManifests(icebergTable.io()).stream().map(ManifestFile::partitionSpecId).collect(ImmutableSet.toImmutableSet())).orElseGet(() -> ImmutableSet.copyOf(icebergTable.specs().keySet()));
            LinkedHashMap unsupported = new LinkedHashMap();
            LinkedHashMap newEnforced = new LinkedHashMap();
            LinkedHashMap newUnenforced = new LinkedHashMap();
            Map domains = (Map)predicate.getDomains().orElseThrow(() -> new VerifyException("No domains"));
            domains.forEach((columnHandle, domain) -> {
                if (HiveUtil.isStructuralType((io.trino.spi.type.Type)columnHandle.getType()) || columnHandle.getType() == UuidType.UUID && !domain.isOnlyNull() && !domain.getValues().isAll()) {
                    unsupported.put(columnHandle, domain);
                } else if (IcebergUtil.canEnforceColumnConstraintInSpecs(this.typeManager.getTypeOperators(), icebergTable, partitionSpecIds, columnHandle, domain)) {
                    newEnforced.put(columnHandle, domain);
                } else if (IcebergMetadataColumn.isMetadataColumnId(columnHandle.getId())) {
                    if (columnHandle.isPathColumn() || columnHandle.isFileModifiedTimeColumn()) {
                        newEnforced.put(columnHandle, domain);
                    } else {
                        unsupported.put(columnHandle, domain);
                    }
                } else {
                    newUnenforced.put(columnHandle, domain);
                }
            });
            newEnforcedConstraint = TupleDomain.withColumnDomains(newEnforced).intersect(table.getEnforcedPredicate());
            newUnenforcedConstraint = TupleDomain.withColumnDomains(newUnenforced).intersect(table.getUnenforcedPredicate());
            remainingConstraint = TupleDomain.withColumnDomains(newUnenforced).intersect(TupleDomain.withColumnDomains(unsupported));
        }
        if (newEnforcedConstraint.equals(table.getEnforcedPredicate()) && newUnenforcedConstraint.equals(table.getUnenforcedPredicate())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)new IcebergTableHandle(table.getSchemaName(), table.getTableName(), table.getTableType(), table.getSnapshotId(), table.getTableSchemaJson(), table.getSortOrder(), table.getPartitionSpecJson(), table.getFormatVersion(), (TupleDomain<IcebergColumnHandle>)newUnenforcedConstraint, (TupleDomain<IcebergColumnHandle>)newEnforcedConstraint, table.getProjectedColumns(), table.getNameMappingJson(), table.getTableLocation(), table.getStorageProperties(), table.getRetryMode(), table.getUpdatedColumns(), table.isRecordScannedFiles(), table.getMaxScannedFileSize()), remainingConstraint.transformKeys(ColumnHandle.class::cast), extractionResult.remainingExpression(), false));
    }

    private static Set<Integer> identityPartitionColumnsInAllSpecs(Table table) {
        return (Set)table.spec().fields().stream().filter(field -> field.transform().isIdentity()).filter(field -> table.specs().values().stream().allMatch(spec -> spec.fields().contains(field))).map(PartitionField::sourceId).collect(ImmutableSet.toImmutableSet());
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        if (!IcebergSessionProperties.isProjectionPushdownEnabled(session)) {
            return Optional.empty();
        }
        Set projectedExpressions = (Set)projections.stream().flatMap(expression -> HiveApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)expression).stream()).collect(ImmutableSet.toImmutableSet());
        Map columnProjections = (Map)projectedExpressions.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), HiveApplyProjectionUtil::createProjectedColumnRepresentation));
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)handle;
        if (columnProjections.values().stream().allMatch(HiveApplyProjectionUtil.ProjectedColumnRepresentation::isVariable)) {
            Set projectedColumns = (Set)assignments.values().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableSet.toImmutableSet());
            if (icebergTableHandle.getProjectedColumns().equals(projectedColumns)) {
                return Optional.empty();
            }
            List assignmentsList = (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((IcebergColumnHandle)assignment.getValue()).getType())).collect(ImmutableList.toImmutableList());
            return Optional.of(new ProjectionApplicationResult((Object)icebergTableHandle.withProjectedColumns(projectedColumns), projections, assignmentsList, false));
        }
        HashMap<String, Assignment> newAssignments = new HashMap<String, Assignment>();
        ImmutableMap.Builder newVariablesBuilder = ImmutableMap.builder();
        ImmutableSet.Builder projectedColumnsBuilder = ImmutableSet.builder();
        for (Map.Entry entry : columnProjections.entrySet()) {
            ConnectorExpression expression2 = (ConnectorExpression)entry.getKey();
            HiveApplyProjectionUtil.ProjectedColumnRepresentation projectedColumn = (HiveApplyProjectionUtil.ProjectedColumnRepresentation)entry.getValue();
            IcebergColumnHandle baseColumnHandle = (IcebergColumnHandle)assignments.get(projectedColumn.getVariable().getName());
            IcebergColumnHandle projectedColumnHandle = IcebergMetadata.createProjectedColumnHandle(baseColumnHandle, projectedColumn.getDereferenceIndices(), expression2.getType());
            String projectedColumnName = projectedColumnHandle.getQualifiedName();
            Variable projectedColumnVariable = new Variable(projectedColumnName, expression2.getType());
            Assignment newAssignment = new Assignment(projectedColumnName, (ColumnHandle)projectedColumnHandle, expression2.getType());
            newAssignments.putIfAbsent(projectedColumnName, newAssignment);
            newVariablesBuilder.put((Object)expression2, (Object)projectedColumnVariable);
            projectedColumnsBuilder.add((Object)projectedColumnHandle);
        }
        ImmutableMap newVariables = newVariablesBuilder.buildOrThrow();
        List newProjections = (List)projections.stream().map(arg_0 -> IcebergMetadata.lambda$applyProjection$65((Map)newVariables, arg_0)).collect(ImmutableList.toImmutableList());
        ImmutableList outputAssignments = ImmutableList.copyOf(newAssignments.values());
        return Optional.of(new ProjectionApplicationResult((Object)icebergTableHandle.withProjectedColumns((Set<IcebergColumnHandle>)projectedColumnsBuilder.build()), newProjections, (List)outputAssignments, false));
    }

    private static IcebergColumnHandle createProjectedColumnHandle(IcebergColumnHandle column, List<Integer> indices, io.trino.spi.type.Type projectedColumnType) {
        if (indices.isEmpty()) {
            return column;
        }
        ImmutableList.Builder fullPath = ImmutableList.builder();
        fullPath.addAll(column.getPath());
        ColumnIdentity projectedColumnIdentity = column.getColumnIdentity();
        for (int index : indices) {
            projectedColumnIdentity = projectedColumnIdentity.getChildren().get(index);
            fullPath.add((Object)projectedColumnIdentity.getId());
        }
        return new IcebergColumnHandle(column.getBaseColumnIdentity(), column.getBaseType(), (List<Integer>)fullPath.build(), projectedColumnType, Optional.empty());
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (!IcebergSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        IcebergTableHandle originalHandle = (IcebergTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)originalHandle.getUpdatedColumns().isEmpty(), (Object)"Unexpected updated columns");
        Preconditions.checkArgument((!originalHandle.isRecordScannedFiles() ? 1 : 0) != 0, (Object)"Unexpected scanned files recording set");
        Preconditions.checkArgument((boolean)originalHandle.getMaxScannedFileSize().isEmpty(), (Object)"Unexpected max scanned file size set");
        return this.tableStatisticsCache.computeIfAbsent(new IcebergTableHandle(originalHandle.getSchemaName(), originalHandle.getTableName(), originalHandle.getTableType(), originalHandle.getSnapshotId(), originalHandle.getTableSchemaJson(), originalHandle.getSortOrder(), originalHandle.getPartitionSpecJson(), originalHandle.getFormatVersion(), originalHandle.getUnenforcedPredicate(), originalHandle.getEnforcedPredicate(), (Set<IcebergColumnHandle>)ImmutableSet.of(), originalHandle.getNameMappingJson(), originalHandle.getTableLocation(), originalHandle.getStorageProperties(), RetryMode.NO_RETRIES, originalHandle.getUpdatedColumns(), originalHandle.isRecordScannedFiles(), originalHandle.getMaxScannedFileSize()), handle -> {
            Table icebergTable = this.catalog.loadTable(session, handle.getSchemaTableName());
            return TableStatisticsReader.getTableStatistics(this.typeManager, session, handle, icebergTable);
        });
    }

    public void setTableAuthorization(ConnectorSession session, SchemaTableName tableName, TrinoPrincipal principal) {
        this.catalog.setTablePrincipal(session, tableName, principal);
    }

    private Optional<Long> getCurrentSnapshotId(Table table) {
        return Optional.ofNullable(table.currentSnapshot()).map(Snapshot::snapshotId);
    }

    Table getIcebergTable(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.catalog.loadTable(session, schemaTableName);
    }

    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        this.catalog.createMaterializedView(session, viewName, definition, replace, ignoreExisting);
    }

    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        this.catalog.dropMaterializedView(session, viewName);
    }

    public boolean delegateMaterializedViewRefreshToConnector(ConnectorSession session, SchemaTableName viewName) {
        return false;
    }

    public ConnectorInsertTableHandle beginRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorTableHandle> sourceTableHandles, RetryMode retryMode) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        this.beginTransaction(icebergTable);
        return this.newWritableTableHandle(table.getSchemaTableName(), icebergTable, retryMode);
    }

    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<ConnectorTableHandle> sourceTableHandles) {
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        Table icebergTable = this.transaction.table();
        this.transaction.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = this.transaction.newFastAppend();
        ImmutableSet.Builder writtenFiles = ImmutableSet.builder();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.getPath()).withFileSizeInBytes(task.getFileSizeInBytes()).withFormat(table.getFileFormat().toIceberg()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
            writtenFiles.add((Object)task.getPath());
        }
        String dependencies = sourceTableHandles.stream().map(handle -> {
            if (!(handle instanceof IcebergTableHandle)) {
                return UNKNOWN_SNAPSHOT_TOKEN;
            }
            IcebergTableHandle icebergHandle = (IcebergTableHandle)handle;
            return icebergHandle.getSchemaTableName() + "=" + icebergHandle.getSnapshotId().map(Object.class::cast).orElse("");
        }).distinct().collect(Collectors.joining(","));
        if (table.getRetryMode() != RetryMode.NO_RETRIES) {
            this.cleanExtraOutputFiles(session, (Set<String>)writtenFiles.build());
        }
        appendFiles.set("dependsOnTables", dependencies);
        IcebergUtil.commit(appendFiles, session);
        this.transaction.commitTransaction();
        this.transaction = null;
        return Optional.of(new HiveWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::getPath).collect(ImmutableList.toImmutableList())));
    }

    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listMaterializedViews(session, schemaName);
    }

    public Map<SchemaTableName, ConnectorMaterializedViewDefinition> getMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        HashMap<SchemaTableName, ConnectorMaterializedViewDefinition> materializedViews = new HashMap<SchemaTableName, ConnectorMaterializedViewDefinition>();
        for (SchemaTableName name : this.listMaterializedViews(session, schemaName)) {
            try {
                this.getMaterializedView(session, name).ifPresent(view -> materializedViews.put(name, (ConnectorMaterializedViewDefinition)view));
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to access metadata of materialized view %s during listing", new Object[]{name});
            }
        }
        return materializedViews;
    }

    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        return this.catalog.getMaterializedView(session, viewName);
    }

    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        if (!source.getSchemaName().equals(target.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized View rename across schemas is not supported");
        }
        this.catalog.renameMaterializedView(session, source, target);
    }

    public MaterializedViewFreshness getMaterializedViewFreshness(ConnectorSession session, SchemaTableName materializedViewName) {
        Optional<ConnectorMaterializedViewDefinition> materializedViewDefinition = this.getMaterializedView(session, materializedViewName);
        if (materializedViewDefinition.isEmpty()) {
            return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.STALE);
        }
        SchemaTableName storageTableName = materializedViewDefinition.get().getStorageTable().map(CatalogSchemaTableName::getSchemaTableName).orElseThrow(() -> new IllegalStateException("Storage table missing in definition of materialized view " + materializedViewName));
        Table icebergTable = this.catalog.loadTable(session, storageTableName);
        String dependsOnTables = icebergTable.currentSnapshot().summary().getOrDefault("dependsOnTables", "");
        if (dependsOnTables.isEmpty()) {
            return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.STALE);
        }
        boolean hasUnknownTables = false;
        Iterable tableToSnapshotIds = Splitter.on((char)',').split((CharSequence)dependsOnTables);
        for (String entry : tableToSnapshotIds) {
            if (entry.equals(UNKNOWN_SNAPSHOT_TOKEN)) {
                hasUnknownTables = true;
                continue;
            }
            List keyValue = Splitter.on((String)"=").splitToList((CharSequence)entry);
            if (keyValue.size() != 2) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Invalid entry in '%s' property: %s'", "dependsOnTables", entry));
            }
            String tableName = (String)keyValue.get(0);
            String value = (String)keyValue.get(1);
            List strings = Splitter.on((String)".").splitToList((CharSequence)tableName);
            if (strings.size() == 3) {
                strings = strings.subList(1, 3);
            } else if (strings.size() != 2) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Invalid table name in '%s' property: %s'", "dependsOnTables", strings));
            }
            String schema = (String)strings.get(0);
            String name = (String)strings.get(1);
            SchemaTableName schemaTableName = new SchemaTableName(schema, name);
            ConnectorTableHandle tableHandle = this.getTableHandle(session, schemaTableName, Optional.empty(), Optional.empty());
            if (tableHandle == null) {
                return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.STALE);
            }
            Optional<Object> snapshotAtRefresh = value.isEmpty() ? Optional.empty() : Optional.of(Long.parseLong(value));
            if (this.isSnapshotCurrent(session, (IcebergTableHandle)tableHandle, snapshotAtRefresh)) continue;
            return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.STALE);
        }
        return new MaterializedViewFreshness(hasUnknownTables ? MaterializedViewFreshness.Freshness.UNKNOWN : MaterializedViewFreshness.Freshness.FRESH);
    }

    private boolean isSnapshotCurrent(ConnectorSession session, IcebergTableHandle table, Optional<Long> snapshotId) {
        Table icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Snapshot currentSnapshot = icebergTable.currentSnapshot();
        if (snapshotId.isEmpty() || currentSnapshot == null) {
            return false;
        }
        return snapshotId.get().longValue() == currentSnapshot.snapshotId();
    }

    public boolean supportsReportingWrittenBytes(ConnectorSession session, ConnectorTableHandle connectorTableHandle) {
        return true;
    }

    public boolean supportsReportingWrittenBytes(ConnectorSession session, SchemaTableName fullTableName, Map<String, Object> tableProperties) {
        return true;
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        this.catalog.updateColumnComment(session, ((IcebergTableHandle)tableHandle).getSchemaTableName(), ((IcebergColumnHandle)column).getColumnIdentity(), comment);
    }

    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        return this.catalog.redirectTable(session, tableName);
    }

    private void beginTransaction(Table icebergTable) {
        Verify.verify((this.transaction == null ? 1 : 0) != 0, (String)"transaction already set", (Object[])new Object[0]);
        this.transaction = icebergTable.newTransaction();
    }

    private static /* synthetic */ ConnectorExpression lambda$applyProjection$65(Map newVariables, ConnectorExpression expression) {
        return HiveApplyProjectionUtil.replaceWithNewVariables((ConnectorExpression)expression, (Map)newVariables);
    }

    private static /* synthetic */ boolean lambda$finishStatisticsCollection$42(Set columnIds, String key) {
        if (!key.startsWith("trino.stats.ndv.")) {
            return false;
        }
        Matcher matcher = TableStatisticsReader.TRINO_STATS_COLUMN_ID_PATTERN.matcher(key);
        if (!matcher.matches()) {
            return false;
        }
        return !columnIds.contains(Integer.parseInt(matcher.group("columnId")));
    }

    private static /* synthetic */ Iterator lambda$getTableProperties$3(Supplier lazyFiles) {
        return ((List)lazyFiles.get()).iterator();
    }
}

