/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.Maps;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.SortingFileWriterConfig;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileWriterFactory;
import io.trino.plugin.iceberg.IcebergMergeSink;
import io.trino.plugin.iceberg.IcebergMergeTableHandle;
import io.trino.plugin.iceberg.IcebergPageSink;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.IcebergWritableTableHandle;
import io.trino.plugin.iceberg.procedure.IcebergOptimizeHandle;
import io.trino.plugin.iceberg.procedure.IcebergTableExecuteHandle;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.io.LocationProvider;

public class IcebergPageSinkProvider
implements ConnectorPageSinkProvider {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final JsonCodec<CommitTaskData> jsonCodec;
    private final IcebergFileWriterFactory fileWriterFactory;
    private final PageIndexerFactory pageIndexerFactory;
    private final int maxOpenPartitions;
    private final DataSize sortingFileWriterBufferSize;
    private final int sortingFileWriterMaxOpenFiles;
    private final TypeManager typeManager;
    private final PageSorter pageSorter;

    @Inject
    public IcebergPageSinkProvider(TrinoFileSystemFactory fileSystemFactory, JsonCodec<CommitTaskData> jsonCodec, IcebergFileWriterFactory fileWriterFactory, PageIndexerFactory pageIndexerFactory, IcebergConfig config, SortingFileWriterConfig sortingFileWriterConfig, TypeManager typeManager, PageSorter pageSorter) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
        this.fileWriterFactory = Objects.requireNonNull(fileWriterFactory, "fileWriterFactory is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.maxOpenPartitions = config.getMaxPartitionsPerWriter();
        this.sortingFileWriterBufferSize = sortingFileWriterConfig.getWriterSortBufferSize();
        this.sortingFileWriterMaxOpenFiles = sortingFileWriterConfig.getMaxOpenSortFiles();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, ConnectorPageSinkId pageSinkId) {
        return this.createPageSink(session, (IcebergWritableTableHandle)outputTableHandle);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, ConnectorPageSinkId pageSinkId) {
        return this.createPageSink(session, (IcebergWritableTableHandle)insertTableHandle);
    }

    private ConnectorPageSink createPageSink(ConnectorSession session, IcebergWritableTableHandle tableHandle) {
        Schema schema = SchemaParser.fromJson((String)tableHandle.getSchemaAsJson());
        String partitionSpecJson = tableHandle.getPartitionsSpecsAsJson().get(tableHandle.getPartitionSpecId());
        PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)partitionSpecJson);
        LocationProvider locationProvider = IcebergUtil.getLocationProvider(tableHandle.getName(), tableHandle.getOutputPath(), tableHandle.getStorageProperties());
        return new IcebergPageSink(schema, partitionSpec, locationProvider, this.fileWriterFactory, this.pageIndexerFactory, this.fileSystemFactory.create(session), tableHandle.getInputColumns(), this.jsonCodec, session, tableHandle.getFileFormat(), tableHandle.getStorageProperties(), this.maxOpenPartitions, tableHandle.getSortOrder(), this.sortingFileWriterBufferSize, this.sortingFileWriterMaxOpenFiles, this.typeManager, this.pageSorter);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorPageSinkId pageSinkId) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                IcebergOptimizeHandle optimizeHandle = (IcebergOptimizeHandle)executeHandle.getProcedureHandle();
                Schema schema = SchemaParser.fromJson((String)optimizeHandle.getSchemaAsJson());
                PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)optimizeHandle.getPartitionSpecAsJson());
                LocationProvider locationProvider = IcebergUtil.getLocationProvider(executeHandle.getSchemaTableName(), executeHandle.getTableLocation(), optimizeHandle.getTableStorageProperties());
                return new IcebergPageSink(schema, partitionSpec, locationProvider, this.fileWriterFactory, this.pageIndexerFactory, this.fileSystemFactory.create(session), optimizeHandle.getTableColumns(), this.jsonCodec, session, optimizeHandle.getFileFormat(), optimizeHandle.getTableStorageProperties(), this.maxOpenPartitions, optimizeHandle.getSortOrder(), this.sortingFileWriterBufferSize, this.sortingFileWriterMaxOpenFiles, this.typeManager, this.pageSorter);
            }
        }
        throw new IllegalArgumentException("Unknown procedure: " + executeHandle.getProcedureId());
    }

    public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        IcebergMergeTableHandle merge = (IcebergMergeTableHandle)mergeHandle;
        IcebergWritableTableHandle tableHandle = merge.getInsertTableHandle();
        LocationProvider locationProvider = IcebergUtil.getLocationProvider(tableHandle.getName(), tableHandle.getOutputPath(), tableHandle.getStorageProperties());
        Schema schema = SchemaParser.fromJson((String)tableHandle.getSchemaAsJson());
        Map partitionsSpecs = Maps.transformValues(tableHandle.getPartitionsSpecsAsJson(), json -> PartitionSpecParser.fromJson((Schema)schema, (String)json));
        ConnectorPageSink pageSink = this.createPageSink(session, tableHandle);
        return new IcebergMergeSink(locationProvider, this.fileWriterFactory, this.fileSystemFactory.create(session), this.jsonCodec, session, tableHandle.getFileFormat(), tableHandle.getStorageProperties(), schema, partitionsSpecs, pageSink, tableHandle.getInputColumns().size());
    }
}

