/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.TrinoSortField;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class IcebergTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final TableType tableType;
    private final Optional<Long> snapshotId;
    private final String tableSchemaJson;
    private final List<TrinoSortField> sortOrder;
    private final Optional<String> partitionSpecJson;
    private final int formatVersion;
    private final String tableLocation;
    private final Map<String, String> storageProperties;
    private final RetryMode retryMode;
    private final List<IcebergColumnHandle> updatedColumns;
    private final TupleDomain<IcebergColumnHandle> unenforcedPredicate;
    private final TupleDomain<IcebergColumnHandle> enforcedPredicate;
    private final Set<IcebergColumnHandle> projectedColumns;
    private final Optional<String> nameMappingJson;
    private final boolean recordScannedFiles;
    private final Optional<DataSize> maxScannedFileSize;

    @JsonCreator
    public static IcebergTableHandle fromJsonForDeserializationOnly(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="tableType") TableType tableType, @JsonProperty(value="snapshotId") Optional<Long> snapshotId, @JsonProperty(value="tableSchemaJson") String tableSchemaJson, @JsonProperty(value="sortOrder") List<TrinoSortField> sortOrder, @JsonProperty(value="partitionSpecJson") Optional<String> partitionSpecJson, @JsonProperty(value="formatVersion") int formatVersion, @JsonProperty(value="unenforcedPredicate") TupleDomain<IcebergColumnHandle> unenforcedPredicate, @JsonProperty(value="enforcedPredicate") TupleDomain<IcebergColumnHandle> enforcedPredicate, @JsonProperty(value="projectedColumns") Set<IcebergColumnHandle> projectedColumns, @JsonProperty(value="nameMappingJson") Optional<String> nameMappingJson, @JsonProperty(value="tableLocation") String tableLocation, @JsonProperty(value="storageProperties") Map<String, String> storageProperties, @JsonProperty(value="retryMode") RetryMode retryMode, @JsonProperty(value="updatedColumns") List<IcebergColumnHandle> updatedColumns) {
        return new IcebergTableHandle(schemaName, tableName, tableType, snapshotId, tableSchemaJson, sortOrder, partitionSpecJson, formatVersion, unenforcedPredicate, enforcedPredicate, projectedColumns, nameMappingJson, tableLocation, storageProperties, retryMode, updatedColumns, false, Optional.empty());
    }

    public IcebergTableHandle(String schemaName, String tableName, TableType tableType, Optional<Long> snapshotId, String tableSchemaJson, List<TrinoSortField> sortOrder, Optional<String> partitionSpecJson, int formatVersion, TupleDomain<IcebergColumnHandle> unenforcedPredicate, TupleDomain<IcebergColumnHandle> enforcedPredicate, Set<IcebergColumnHandle> projectedColumns, Optional<String> nameMappingJson, String tableLocation, Map<String, String> storageProperties, RetryMode retryMode, List<IcebergColumnHandle> updatedColumns, boolean recordScannedFiles, Optional<DataSize> maxScannedFileSize) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.tableSchemaJson = Objects.requireNonNull(tableSchemaJson, "schemaJson is null");
        this.sortOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrder, "sortOrder is null"));
        this.partitionSpecJson = Objects.requireNonNull(partitionSpecJson, "partitionSpecJson is null");
        this.formatVersion = formatVersion;
        this.unenforcedPredicate = Objects.requireNonNull(unenforcedPredicate, "unenforcedPredicate is null");
        this.enforcedPredicate = Objects.requireNonNull(enforcedPredicate, "enforcedPredicate is null");
        this.projectedColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(projectedColumns, "projectedColumns is null"));
        this.nameMappingJson = Objects.requireNonNull(nameMappingJson, "nameMappingJson is null");
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
        this.storageProperties = ImmutableMap.copyOf(Objects.requireNonNull(storageProperties, "storageProperties is null"));
        this.retryMode = Objects.requireNonNull(retryMode, "retryMode is null");
        this.updatedColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(updatedColumns, "updatedColumns is null"));
        this.recordScannedFiles = recordScannedFiles;
        this.maxScannedFileSize = Objects.requireNonNull(maxScannedFileSize, "maxScannedFileSize is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TableType getTableType() {
        return this.tableType;
    }

    @JsonProperty
    public Optional<Long> getSnapshotId() {
        return this.snapshotId;
    }

    @JsonProperty
    public String getTableSchemaJson() {
        return this.tableSchemaJson;
    }

    @JsonProperty
    public List<TrinoSortField> getSortOrder() {
        return this.sortOrder;
    }

    @JsonProperty
    public Optional<String> getPartitionSpecJson() {
        return this.partitionSpecJson;
    }

    @JsonProperty
    public int getFormatVersion() {
        return this.formatVersion;
    }

    @JsonProperty
    public TupleDomain<IcebergColumnHandle> getUnenforcedPredicate() {
        return this.unenforcedPredicate;
    }

    @JsonProperty
    public TupleDomain<IcebergColumnHandle> getEnforcedPredicate() {
        return this.enforcedPredicate;
    }

    @JsonProperty
    public Set<IcebergColumnHandle> getProjectedColumns() {
        return this.projectedColumns;
    }

    @JsonProperty
    public Optional<String> getNameMappingJson() {
        return this.nameMappingJson;
    }

    @JsonProperty
    public String getTableLocation() {
        return this.tableLocation;
    }

    @JsonProperty
    public Map<String, String> getStorageProperties() {
        return this.storageProperties;
    }

    @JsonProperty
    public RetryMode getRetryMode() {
        return this.retryMode;
    }

    @JsonProperty
    public List<IcebergColumnHandle> getUpdatedColumns() {
        return this.updatedColumns;
    }

    @JsonIgnore
    public boolean isRecordScannedFiles() {
        return this.recordScannedFiles;
    }

    @JsonIgnore
    public Optional<DataSize> getMaxScannedFileSize() {
        return this.maxScannedFileSize;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public SchemaTableName getSchemaTableNameWithType() {
        return new SchemaTableName(this.schemaName, this.tableName + "$" + this.tableType.name().toLowerCase(Locale.ROOT));
    }

    public IcebergTableHandle withProjectedColumns(Set<IcebergColumnHandle> projectedColumns) {
        return new IcebergTableHandle(this.schemaName, this.tableName, this.tableType, this.snapshotId, this.tableSchemaJson, this.sortOrder, this.partitionSpecJson, this.formatVersion, this.unenforcedPredicate, this.enforcedPredicate, projectedColumns, this.nameMappingJson, this.tableLocation, this.storageProperties, this.retryMode, this.updatedColumns, this.recordScannedFiles, this.maxScannedFileSize);
    }

    public IcebergTableHandle withRetryMode(RetryMode retryMode) {
        return new IcebergTableHandle(this.schemaName, this.tableName, this.tableType, this.snapshotId, this.tableSchemaJson, this.sortOrder, this.partitionSpecJson, this.formatVersion, this.unenforcedPredicate, this.enforcedPredicate, this.projectedColumns, this.nameMappingJson, this.tableLocation, this.storageProperties, retryMode, this.updatedColumns, this.recordScannedFiles, this.maxScannedFileSize);
    }

    public IcebergTableHandle withUpdatedColumns(List<IcebergColumnHandle> updatedColumns) {
        return new IcebergTableHandle(this.schemaName, this.tableName, this.tableType, this.snapshotId, this.tableSchemaJson, this.sortOrder, this.partitionSpecJson, this.formatVersion, this.unenforcedPredicate, this.enforcedPredicate, this.projectedColumns, this.nameMappingJson, this.tableLocation, this.storageProperties, this.retryMode, updatedColumns, this.recordScannedFiles, this.maxScannedFileSize);
    }

    public IcebergTableHandle forOptimize(boolean recordScannedFiles, DataSize maxScannedFileSize) {
        return new IcebergTableHandle(this.schemaName, this.tableName, this.tableType, this.snapshotId, this.tableSchemaJson, this.sortOrder, this.partitionSpecJson, this.formatVersion, this.unenforcedPredicate, this.enforcedPredicate, this.projectedColumns, this.nameMappingJson, this.tableLocation, this.storageProperties, this.retryMode, this.updatedColumns, recordScannedFiles, Optional.of(maxScannedFileSize));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergTableHandle that = (IcebergTableHandle)o;
        return this.recordScannedFiles == that.recordScannedFiles && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && this.tableType == that.tableType && Objects.equals(this.snapshotId, that.snapshotId) && Objects.equals(this.tableSchemaJson, that.tableSchemaJson) && Objects.equals(this.sortOrder, that.sortOrder) && Objects.equals(this.partitionSpecJson, that.partitionSpecJson) && this.formatVersion == that.formatVersion && Objects.equals(this.unenforcedPredicate, that.unenforcedPredicate) && Objects.equals(this.enforcedPredicate, that.enforcedPredicate) && Objects.equals(this.projectedColumns, that.projectedColumns) && Objects.equals(this.nameMappingJson, that.nameMappingJson) && Objects.equals(this.tableLocation, that.tableLocation) && Objects.equals(this.retryMode, that.retryMode) && Objects.equals(this.updatedColumns, that.updatedColumns) && Objects.equals(this.storageProperties, that.storageProperties) && Objects.equals(this.maxScannedFileSize, that.maxScannedFileSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaName, this.tableName, this.tableType, this.snapshotId, this.tableSchemaJson, this.sortOrder, this.partitionSpecJson, this.formatVersion, this.unenforcedPredicate, this.enforcedPredicate, this.projectedColumns, this.nameMappingJson, this.tableLocation, this.storageProperties, this.retryMode, this.updatedColumns, this.recordScannedFiles, this.maxScannedFileSize});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getSchemaTableNameWithType().toString());
        this.snapshotId.ifPresent(snapshotId -> builder.append("@").append(snapshotId));
        if (this.enforcedPredicate.isNone()) {
            builder.append(" constraint=FALSE");
        } else if (!this.enforcedPredicate.isAll()) {
            builder.append(" constraint on ");
            builder.append(((Map)this.enforcedPredicate.getDomains().orElseThrow()).keySet().stream().map(IcebergColumnHandle::getQualifiedName).collect(Collectors.joining(", ", "[", "]")));
        }
        return builder.toString();
    }
}

