/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.OrcType;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class TypeConverter {
    public static final String ORC_ICEBERG_ID_KEY = "iceberg.id";
    public static final String ORC_ICEBERG_REQUIRED_KEY = "iceberg.required";
    public static final String ICEBERG_LONG_TYPE = "iceberg.long-type";
    public static final String ICEBERG_BINARY_TYPE = "iceberg.binary-type";

    private TypeConverter() {
    }

    public static io.trino.spi.type.Type toTrinoType(Type type, TypeManager typeManager) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BINARY: 
            case FIXED: {
                return VarbinaryType.VARBINARY;
            }
            case DATE: {
                return DateType.DATE;
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return DecimalType.createDecimalType((int)decimalType.precision(), (int)decimalType.scale());
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case INTEGER: {
                return IntegerType.INTEGER;
            }
            case TIME: {
                return TimeType.TIME_MICROS;
            }
            case TIMESTAMP: {
                return ((Types.TimestampType)type).shouldAdjustToUTC() ? TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS : TimestampType.TIMESTAMP_MICROS;
            }
            case STRING: {
                return VarcharType.createUnboundedVarcharType();
            }
            case UUID: {
                return UuidType.UUID;
            }
            case LIST: {
                Types.ListType listType = (Types.ListType)type;
                return new ArrayType(TypeConverter.toTrinoType(listType.elementType(), typeManager));
            }
            case MAP: {
                Types.MapType mapType = (Types.MapType)type;
                TypeSignature keyType = TypeConverter.toTrinoType(mapType.keyType(), typeManager).getTypeSignature();
                TypeSignature valueType = TypeConverter.toTrinoType(mapType.valueType(), typeManager).getTypeSignature();
                return typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)keyType), (Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType)));
            }
            case STRUCT: {
                List fields = ((Types.StructType)type).fields();
                return RowType.from((List)((List)fields.stream().map(field -> new RowType.Field(Optional.of(field.name()), TypeConverter.toTrinoType(field.type(), typeManager))).collect(ImmutableList.toImmutableList())));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot convert from Iceberg type '%s' (%s) to Trino type", type, type.typeId()));
    }

    public static Type toIcebergTypeForNewColumn(io.trino.spi.type.Type type, AtomicInteger nextFieldId) {
        return TypeConverter.toIcebergTypeInternal(type, Optional.empty(), Optional.of(nextFieldId));
    }

    public static Type toIcebergType(io.trino.spi.type.Type type, ColumnIdentity columnIdentity) {
        return TypeConverter.toIcebergTypeInternal(type, Optional.of(columnIdentity), Optional.empty());
    }

    private static Type toIcebergTypeInternal(io.trino.spi.type.Type type, Optional<ColumnIdentity> columnIdentity, Optional<AtomicInteger> nextFieldId) {
        if (type instanceof BooleanType) {
            return Types.BooleanType.get();
        }
        if (type instanceof IntegerType) {
            return Types.IntegerType.get();
        }
        if (type instanceof BigintType) {
            return Types.LongType.get();
        }
        if (type instanceof RealType) {
            return Types.FloatType.get();
        }
        if (type instanceof DoubleType) {
            return Types.DoubleType.get();
        }
        if (type instanceof DecimalType) {
            return TypeConverter.fromDecimal((DecimalType)type);
        }
        if (type instanceof VarcharType) {
            return Types.StringType.get();
        }
        if (type instanceof VarbinaryType) {
            return Types.BinaryType.get();
        }
        if (type instanceof DateType) {
            return Types.DateType.get();
        }
        if (type.equals(TimeType.TIME_MICROS)) {
            return Types.TimeType.get();
        }
        if (type.equals(TimestampType.TIMESTAMP_MICROS)) {
            return Types.TimestampType.withoutZone();
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS)) {
            return Types.TimestampType.withZone();
        }
        if (type.equals(UuidType.UUID)) {
            return Types.UUIDType.get();
        }
        if (type instanceof RowType) {
            return TypeConverter.fromRow((RowType)type, columnIdentity, nextFieldId);
        }
        if (type instanceof ArrayType) {
            return TypeConverter.fromArray((ArrayType)type, columnIdentity, nextFieldId);
        }
        if (type instanceof MapType) {
            return TypeConverter.fromMap((MapType)type, columnIdentity, nextFieldId);
        }
        if (type instanceof TimeType) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Time precision (%s) not supported for Iceberg. Use \"time(6)\" instead.", ((TimeType)type).getPrecision()));
        }
        if (type instanceof TimestampType) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Timestamp precision (%s) not supported for Iceberg. Use \"timestamp(6)\" instead.", ((TimestampType)type).getPrecision()));
        }
        if (type instanceof TimestampWithTimeZoneType) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Timestamp precision (%s) not supported for Iceberg. Use \"timestamp(6) with time zone\" instead.", ((TimestampWithTimeZoneType)type).getPrecision()));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Type not supported for Iceberg: " + type.getDisplayName());
    }

    private static Type fromDecimal(DecimalType type) {
        return Types.DecimalType.of((int)type.getPrecision(), (int)type.getScale());
    }

    private static Type fromRow(RowType type, Optional<ColumnIdentity> columnIdentity, Optional<AtomicInteger> nextFieldId) {
        TypeConverter.checkExactlyOne(columnIdentity, nextFieldId);
        ArrayList<Types.NestedField> fields = new ArrayList<Types.NestedField>();
        int i = 0;
        while (i < type.getFields().size()) {
            int fieldIndex = i++;
            Optional<ColumnIdentity> childColumnIdentity = columnIdentity.map(column -> column.getChildren().get(fieldIndex));
            int id = childColumnIdentity.map(ColumnIdentity::getId).orElseGet(() -> ((AtomicInteger)nextFieldId.get()).getAndIncrement());
            RowType.Field field = (RowType.Field)type.getFields().get(fieldIndex);
            String name = (String)field.getName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Row type field does not have a name: " + type.getDisplayName()));
            fields.add(Types.NestedField.optional((int)id, (String)name, (Type)TypeConverter.toIcebergTypeInternal(field.getType(), childColumnIdentity, nextFieldId)));
        }
        return Types.StructType.of(fields);
    }

    private static Type fromArray(ArrayType type, Optional<ColumnIdentity> columnIdentity, Optional<AtomicInteger> nextFieldId) {
        TypeConverter.checkExactlyOne(columnIdentity, nextFieldId);
        Optional<ColumnIdentity> childColumnIdentity = columnIdentity.map(identity -> (ColumnIdentity)Iterables.getOnlyElement(identity.getChildren()));
        int id = childColumnIdentity.map(ColumnIdentity::getId).orElseGet(() -> ((AtomicInteger)nextFieldId.get()).getAndIncrement());
        return Types.ListType.ofOptional((int)id, (Type)TypeConverter.toIcebergTypeInternal(type.getElementType(), childColumnIdentity, nextFieldId));
    }

    private static Type fromMap(MapType type, Optional<ColumnIdentity> columnIdentity, Optional<AtomicInteger> nextFieldId) {
        TypeConverter.checkExactlyOne(columnIdentity, nextFieldId);
        Optional<ColumnIdentity> keyColumnIdentity = columnIdentity.map(column -> column.getChildren().get(0));
        Optional<ColumnIdentity> valueColumnIdentity = columnIdentity.map(column -> column.getChildren().get(1));
        int keyId = keyColumnIdentity.map(ColumnIdentity::getId).orElseGet(() -> ((AtomicInteger)nextFieldId.get()).getAndIncrement());
        int valueId = valueColumnIdentity.map(ColumnIdentity::getId).orElseGet(() -> ((AtomicInteger)nextFieldId.get()).getAndIncrement());
        return Types.MapType.ofOptional((int)keyId, (int)valueId, (Type)TypeConverter.toIcebergTypeInternal(type.getKeyType(), keyColumnIdentity, nextFieldId), (Type)TypeConverter.toIcebergTypeInternal(type.getValueType(), valueColumnIdentity, nextFieldId));
    }

    private static void checkExactlyOne(Optional<ColumnIdentity> columnIdentity, Optional<AtomicInteger> nextFieldId) {
        if (columnIdentity.isPresent() && nextFieldId.isEmpty() || columnIdentity.isEmpty() && nextFieldId.isPresent()) {
            return;
        }
        throw new IllegalArgumentException("Either a column identity or nextFieldId is expected");
    }

    public static ColumnMetadata<OrcType> toOrcType(Schema schema) {
        return new ColumnMetadata(TypeConverter.toOrcStructType(0, schema.asStruct(), (Map<String, String>)ImmutableMap.of()));
    }

    private static List<OrcType> toOrcType(int nextFieldTypeIndex, Type type, Map<String, String> attributes) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.BOOLEAN, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case INTEGER: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case LONG: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.LONG, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case FLOAT: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.FLOAT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case DOUBLE: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.DOUBLE, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case DATE: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.DATE, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case TIME: {
                attributes = ImmutableMap.builder().putAll(attributes).put((Object)ICEBERG_LONG_TYPE, (Object)"TIME").buildOrThrow();
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.LONG, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case TIMESTAMP: {
                OrcType.OrcTypeKind timestampKind = ((Types.TimestampType)type).shouldAdjustToUTC() ? OrcType.OrcTypeKind.TIMESTAMP_INSTANT : OrcType.OrcTypeKind.TIMESTAMP;
                return ImmutableList.of((Object)new OrcType(timestampKind, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case STRING: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.STRING, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case FIXED: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.BINARY, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case BINARY: {
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.BINARY, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.DECIMAL, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.of(decimalType.precision()), Optional.of(decimalType.scale()), (Map)attributes));
            }
            case UUID: {
                attributes = ImmutableMap.builder().putAll(attributes).put((Object)ICEBERG_BINARY_TYPE, (Object)"UUID").buildOrThrow();
                return ImmutableList.of((Object)new OrcType(OrcType.OrcTypeKind.BINARY, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)attributes));
            }
            case STRUCT: {
                return TypeConverter.toOrcStructType(nextFieldTypeIndex, (Types.StructType)type, attributes);
            }
            case LIST: {
                return TypeConverter.toOrcListType(nextFieldTypeIndex, (Types.ListType)type, attributes);
            }
            case MAP: {
                return TypeConverter.toOrcMapType(nextFieldTypeIndex, (Types.MapType)type, attributes);
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported Iceberg type: " + type);
    }

    private static List<OrcType> toOrcStructType(int nextFieldTypeIndex, Types.StructType structType, Map<String, String> attributes) {
        ++nextFieldTypeIndex;
        ArrayList<OrcColumnId> fieldTypeIndexes = new ArrayList<OrcColumnId>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<List<OrcType>> fieldTypesList = new ArrayList<List<OrcType>>();
        for (Types.NestedField field : structType.fields()) {
            fieldTypeIndexes.add(new OrcColumnId(nextFieldTypeIndex));
            fieldNames.add(field.name());
            ImmutableMap fieldAttributes = ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(field.fieldId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(field.isRequired())).buildOrThrow();
            List<OrcType> fieldOrcTypes = TypeConverter.toOrcType(nextFieldTypeIndex, field.type(), (Map<String, String>)fieldAttributes);
            fieldTypesList.add(fieldOrcTypes);
            nextFieldTypeIndex += fieldOrcTypes.size();
        }
        ImmutableList.Builder orcTypes = ImmutableList.builder();
        orcTypes.add((Object)new OrcType(OrcType.OrcTypeKind.STRUCT, fieldTypeIndexes, fieldNames, Optional.empty(), Optional.empty(), Optional.empty(), attributes));
        fieldTypesList.forEach(arg_0 -> ((ImmutableList.Builder)orcTypes).addAll(arg_0));
        return orcTypes.build();
    }

    private static List<OrcType> toOrcListType(int nextFieldTypeIndex, Types.ListType listType, Map<String, String> attributes) {
        ImmutableMap elementAttributes = ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(listType.elementId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(listType.isElementRequired())).buildOrThrow();
        List<OrcType> itemTypes = TypeConverter.toOrcType(++nextFieldTypeIndex, listType.elementType(), (Map<String, String>)elementAttributes);
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcType.OrcTypeKind.LIST, (List)ImmutableList.of((Object)new OrcColumnId(nextFieldTypeIndex)), (List)ImmutableList.of((Object)"item"), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
        orcTypes.addAll(itemTypes);
        return orcTypes;
    }

    private static List<OrcType> toOrcMapType(int nextFieldTypeIndex, Types.MapType mapType, Map<String, String> attributes) {
        ImmutableMap keyAttributes = ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(mapType.keyId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(true)).buildOrThrow();
        List<OrcType> keyTypes = TypeConverter.toOrcType(++nextFieldTypeIndex, mapType.keyType(), (Map<String, String>)keyAttributes);
        ImmutableMap valueAttributes = ImmutableMap.builder().put((Object)ORC_ICEBERG_ID_KEY, (Object)Integer.toString(mapType.valueId())).put((Object)ORC_ICEBERG_REQUIRED_KEY, (Object)Boolean.toString(mapType.isValueRequired())).buildOrThrow();
        List<OrcType> valueTypes = TypeConverter.toOrcType(nextFieldTypeIndex + keyTypes.size(), mapType.valueType(), (Map<String, String>)valueAttributes);
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcType.OrcTypeKind.MAP, (List)ImmutableList.of((Object)new OrcColumnId(nextFieldTypeIndex), (Object)new OrcColumnId(nextFieldTypeIndex + keyTypes.size())), (List)ImmutableList.of((Object)"key", (Object)"value"), Optional.empty(), Optional.empty(), Optional.empty(), attributes));
        orcTypes.addAll(keyTypes);
        orcTypes.addAll(valueTypes);
        return orcTypes;
    }
}

