/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergMaterializedViewAdditionalProperties;
import io.trino.plugin.iceberg.IcebergMaterializedViewDefinition;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;

public abstract class AbstractTrinoCatalog
implements TrinoCatalog {
    public static final String TRINO_CREATED_BY_VALUE = "Trino Iceberg connector";
    protected static final String TRINO_CREATED_BY = "trino_created_by";
    protected static final String PRESTO_QUERY_ID_NAME = "presto_query_id";
    private final CatalogName catalogName;
    private final TypeManager typeManager;
    protected final IcebergTableOperationsProvider tableOperationsProvider;
    private final boolean useUniqueTableLocation;

    protected AbstractTrinoCatalog(CatalogName catalogName, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, boolean useUniqueTableLocation) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationsProvider is null");
        this.useUniqueTableLocation = useUniqueTableLocation;
    }

    @Override
    public void updateTableComment(ConnectorSession session, SchemaTableName schemaTableName, Optional<String> comment) {
        Table icebergTable = this.loadTable(session, schemaTableName);
        if (comment.isEmpty()) {
            icebergTable.updateProperties().remove("comment").commit();
        } else {
            icebergTable.updateProperties().set("comment", comment.get()).commit();
        }
    }

    @Override
    public void updateColumnComment(ConnectorSession session, SchemaTableName schemaTableName, ColumnIdentity columnIdentity, Optional<String> comment) {
        Table icebergTable = this.loadTable(session, schemaTableName);
        icebergTable.updateSchema().updateColumnDoc(columnIdentity.getName(), (String)comment.orElse(null)).commit();
    }

    @Override
    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> namespace) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        for (SchemaTableName name : this.listViews(session, namespace)) {
            try {
                this.getView(session, name).ifPresent(view -> views.put((Object)name, view));
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.TABLE_NOT_FOUND.toErrorCode())) continue;
                throw e;
            }
        }
        return views.buildOrThrow();
    }

    @Override
    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        try {
            return (Optional)Failsafe.with((Policy)RetryPolicy.builder().withMaxAttempts(10).withBackoff(1L, 5000L, ChronoUnit.MILLIS, 4.0).withMaxDuration(Duration.ofSeconds(30L)).abortOn(failure -> !(failure instanceof MaterializedViewMayBeBeingRemovedException)).build(), (Policy[])new RetryPolicy[0]).get(() -> this.doGetMaterializedView(session, schemaViewName));
        }
        catch (MaterializedViewMayBeBeingRemovedException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    protected abstract Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession var1, SchemaTableName var2);

    protected Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties, Optional<String> owner) {
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)partitionSpec, (SortOrder)sortOrder, (String)location, properties);
        IcebergTableOperations ops = this.tableOperationsProvider.createTableOperations(this, session, schemaTableName.getSchemaName(), schemaTableName.getTableName(), owner, Optional.of(location));
        return Transactions.createTableTransaction((String)schemaTableName.toString(), (TableOperations)ops, (TableMetadata)metadata);
    }

    protected String createNewTableName(String baseTableName) {
        Object tableName = baseTableName;
        if (this.useUniqueTableLocation) {
            tableName = (String)tableName + "-" + UUID.randomUUID().toString().replace("-", "");
        }
        return tableName;
    }

    protected void deleteTableDirectory(TrinoFileSystem fileSystem, SchemaTableName schemaTableName, String tableLocation) {
        try {
            fileSystem.deleteDirectory(tableLocation);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Failed to delete directory %s of the table %s", tableLocation, schemaTableName), (Throwable)e);
        }
    }

    protected SchemaTableName createMaterializedViewStorageTable(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition) {
        String storageTableName = "st_" + UUID.randomUUID().toString().replace("-", "");
        HashMap<String, String> storageTableProperties = new HashMap<String, String>(definition.getProperties());
        storageTableProperties.putIfAbsent("format", "parquet");
        String storageSchema = IcebergMaterializedViewAdditionalProperties.getStorageSchema(definition.getProperties()).orElse(viewName.getSchemaName());
        SchemaTableName storageTable = new SchemaTableName(storageSchema, storageTableName);
        List columns = (List)definition.getColumns().stream().map(column -> new ColumnMetadata(column.getName(), this.typeManager.getType(column.getType()))).collect(ImmutableList.toImmutableList());
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(storageTable, columns, storageTableProperties, Optional.empty());
        Transaction transaction = IcebergUtil.newCreateTableTransaction(this, tableMetadata, session);
        AppendFiles appendFiles = transaction.newAppend();
        IcebergUtil.commit(appendFiles, session);
        transaction.commitTransaction();
        return storageTable;
    }

    protected ConnectorMaterializedViewDefinition getMaterializedViewDefinition(Table icebergTable, Optional<String> owner, String viewOriginalText, SchemaTableName storageTableName) {
        IcebergMaterializedViewDefinition definition = IcebergMaterializedViewDefinition.decodeMaterializedViewData(viewOriginalText);
        return new ConnectorMaterializedViewDefinition(definition.getOriginalSql(), Optional.of(new CatalogSchemaTableName(this.catalogName.toString(), storageTableName)), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(column -> new ConnectorMaterializedViewDefinition.Column(column.getName(), column.getType())).collect(ImmutableList.toImmutableList()), definition.getComment(), owner, (Map)ImmutableMap.builder().putAll(IcebergUtil.getIcebergTableProperties(icebergTable)).put((Object)"storage_schema", (Object)storageTableName.getSchemaName()).buildOrThrow());
    }

    protected Map<String, String> createMaterializedViewProperties(ConnectorSession session, SchemaTableName storageTableName) {
        return ImmutableMap.builder().put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).put((Object)"storage_schema", (Object)storageTableName.getSchemaName()).put((Object)"storage_table", (Object)storageTableName.getTableName()).put((Object)"presto_view", (Object)"true").put((Object)TRINO_CREATED_BY, (Object)TRINO_CREATED_BY_VALUE).put((Object)"comment", (Object)"Presto Materialized View").buildOrThrow();
    }

    protected static class MaterializedViewMayBeBeingRemovedException
    extends RuntimeException {
        public MaterializedViewMayBeBeingRemovedException(Throwable cause) {
            super(Objects.requireNonNull(cause, "cause is null"));
        }
    }
}

