/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.glue.AWSGlueAsync;
import io.trino.plugin.hive.metastore.glue.GlueClientUtil;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.iceberg.catalog.glue.IcebergGlueCatalogConfig;
import io.trino.plugin.iceberg.catalog.glue.SkipArchiveRequestHandler;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;

public class GlueClientProvider
implements Provider<AWSGlueAsync> {
    private final GlueMetastoreStats stats;
    private final AWSCredentialsProvider credentialsProvider;
    private final GlueHiveMetastoreConfig glueConfig;
    private final boolean skipArchive;

    @Inject
    public GlueClientProvider(GlueMetastoreStats stats, AWSCredentialsProvider credentialsProvider, GlueHiveMetastoreConfig glueConfig, IcebergGlueCatalogConfig icebergGlueConfig) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider, "credentialsProvider is null");
        this.glueConfig = glueConfig;
        this.skipArchive = icebergGlueConfig.isSkipArchive();
    }

    public AWSGlueAsync get() {
        return GlueClientUtil.createAsyncGlueClient((GlueHiveMetastoreConfig)this.glueConfig, (AWSCredentialsProvider)this.credentialsProvider, Optional.of(new SkipArchiveRequestHandler(this.skipArchive)), (RequestMetricCollector)this.stats.newRequestMetricsCollector());
    }
}

