/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.services.glue.AWSGlueAsync;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergTableOperations;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.iceberg.io.FileIO;

public class GlueIcebergTableOperationsProvider
implements IcebergTableOperationsProvider {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final AWSGlueAsync glueClient;
    private final GlueMetastoreStats stats;

    @Inject
    public GlueIcebergTableOperationsProvider(TrinoFileSystemFactory fileSystemFactory, GlueMetastoreStats stats, AWSGlueAsync glueClient) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
    }

    @Override
    public IcebergTableOperations createTableOperations(TrinoCatalog catalog, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        return new GlueIcebergTableOperations(this.glueClient, this.stats, (FileIO)new ForwardingFileIo(this.fileSystemFactory.create(session)), session, database, table, owner, location);
    }
}

