/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.services.glue.model.TableInput;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.TableType;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public final class GlueIcebergUtil {
    private GlueIcebergUtil() {
    }

    public static TableInput getTableInput(String tableName, Optional<String> owner, Map<String, String> parameters) {
        return new TableInput().withName(tableName).withOwner((String)owner.orElse(null)).withParameters((Map)ImmutableMap.builder().putAll(parameters).put((Object)"table_type", (Object)"iceberg".toUpperCase(Locale.ENGLISH)).buildKeepingLast()).withTableType(TableType.EXTERNAL_TABLE.name());
    }

    public static TableInput getViewTableInput(String viewName, String viewOriginalText, @Nullable String owner, Map<String, String> parameters) {
        return new TableInput().withName(viewName).withTableType(TableType.VIRTUAL_VIEW.name()).withViewOriginalText(viewOriginalText).withViewExpandedText("/* Presto View */").withOwner(owner).withParameters(parameters);
    }

    public static TableInput getMaterializedViewTableInput(String viewName, String viewOriginalText, String owner, Map<String, String> parameters) {
        return new TableInput().withName(viewName).withTableType(TableType.VIRTUAL_VIEW.name()).withViewOriginalText(viewOriginalText).withViewExpandedText("Presto Materialized View").withOwner(owner).withParameters(parameters);
    }
}

