/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.model.AccessDeniedException;
import com.amazonaws.services.glue.model.AlreadyExistsException;
import com.amazonaws.services.glue.model.CreateDatabaseRequest;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import io.airlift.log.Logger;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.SchemaAlreadyExistsException;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.TrinoViewUtil;
import io.trino.plugin.hive.ViewAlreadyExistsException;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.aws.AwsApiCallStats;
import io.trino.plugin.hive.metastore.glue.AwsSdkUtil;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.converter.GlueToTrinoConverter;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergMaterializedViewDefinition;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TrinoMetricsReporter;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.catalog.AbstractTrinoCatalog;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TypeManager;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.metrics.MetricsReporter;

public class TrinoGlueCatalog
extends AbstractTrinoCatalog {
    private static final Logger LOG = Logger.get(TrinoGlueCatalog.class);
    private final String trinoVersion;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final Optional<String> defaultSchemaLocation;
    private final AWSGlueAsync glueClient;
    private final GlueMetastoreStats stats;
    private final Map<SchemaTableName, TableMetadata> tableMetadataCache = new ConcurrentHashMap<SchemaTableName, TableMetadata>();
    private final Map<SchemaTableName, ConnectorViewDefinition> viewCache = new ConcurrentHashMap<SchemaTableName, ConnectorViewDefinition>();
    private final Map<SchemaTableName, ConnectorMaterializedViewDefinition> materializedViewCache = new ConcurrentHashMap<SchemaTableName, ConnectorMaterializedViewDefinition>();

    public TrinoGlueCatalog(CatalogName catalogName, TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, String trinoVersion, AWSGlueAsync glueClient, GlueMetastoreStats stats, Optional<String> defaultSchemaLocation, boolean useUniqueTableLocation) {
        super(catalogName, typeManager, tableOperationsProvider, useUniqueTableLocation);
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.defaultSchemaLocation = Objects.requireNonNull(defaultSchemaLocation, "defaultSchemaLocation is null");
    }

    @Override
    public boolean namespaceExists(ConnectorSession session, String namespace) {
        if (!namespace.equals(namespace.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        return (Boolean)this.stats.getGetDatabase().call(() -> {
            try {
                this.glueClient.getDatabase(new GetDatabaseRequest().withName(namespace));
                return true;
            }
            catch (EntityNotFoundException e) {
                return false;
            }
            catch (AmazonServiceException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
            }
        });
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        try {
            return (List)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getDatabases(arg_0), (Object)new GetDatabasesRequest(), GetDatabasesRequest::setNextToken, GetDatabasesResult::getNextToken, (AwsApiCallStats)this.stats.getGetDatabases()).map(GetDatabasesResult::getDatabaseList).flatMap(Collection::stream).map(Database::getName).collect(ImmutableList.toImmutableList());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    private List<String> listNamespaces(ConnectorSession session, Optional<String> namespace) {
        if (namespace.isPresent()) {
            return ImmutableList.of((Object)namespace.get());
        }
        return this.listNamespaces(session);
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        try {
            this.stats.getDeleteDatabase().call(() -> this.glueClient.deleteDatabase(new DeleteDatabaseRequest().withName(namespace)));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(namespace);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        try {
            GetDatabaseRequest getDatabaseRequest = new GetDatabaseRequest().withName(namespace);
            Database database = (Database)this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(getDatabaseRequest).getDatabase());
            ImmutableMap.Builder metadata = ImmutableMap.builder();
            if (database.getLocationUri() != null) {
                metadata.put((Object)"location", (Object)database.getLocationUri());
            }
            if (database.getParameters() != null) {
                metadata.putAll(database.getParameters());
            }
            return metadata.buildOrThrow();
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(namespace);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        return Optional.empty();
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        Preconditions.checkArgument((owner.getType() == PrincipalType.USER ? 1 : 0) != 0, (Object)"Owner type must be USER");
        Preconditions.checkArgument((boolean)owner.getName().equals(session.getUser()), (Object)"Explicit schema owner is not supported");
        try {
            this.stats.getCreateDatabase().call(() -> this.glueClient.createDatabase(new CreateDatabaseRequest().withDatabaseInput(this.createDatabaseInput(namespace, properties))));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(namespace);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    private DatabaseInput createDatabaseInput(String namespace, Map<String, Object> properties) {
        DatabaseInput databaseInput = new DatabaseInput().withName(namespace);
        properties.forEach((property, value) -> {
            switch (property) {
                case "location": {
                    databaseInput.setLocationUri((String)value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized property: " + property);
                }
            }
        });
        return databaseInput;
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setNamespacePrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameNamespace is not supported for Iceberg Glue catalogs");
    }

    @Override
    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> namespace) {
        ImmutableList.Builder tables = ImmutableList.builder();
        try {
            List<String> namespaces = this.listNamespaces(session, namespace);
            for (String glueNamespace : namespaces) {
                try {
                    tables.addAll((Iterable)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getTables(arg_0), (Object)new GetTablesRequest().withDatabaseName(glueNamespace), GetTablesRequest::setNextToken, GetTablesResult::getNextToken, (AwsApiCallStats)this.stats.getGetTables()).map(GetTablesResult::getTableList).flatMap(Collection::stream).map(table -> new SchemaTableName(glueNamespace, table.getName())).collect(ImmutableList.toImmutableList()));
                }
                catch (AccessDeniedException | EntityNotFoundException throwable) {}
            }
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
        return tables.build();
    }

    @Override
    public org.apache.iceberg.Table loadTable(ConnectorSession session, SchemaTableName table) {
        if (this.viewCache.containsKey(table) || this.materializedViewCache.containsKey(table)) {
            throw new TableNotFoundException(table);
        }
        TableMetadata metadata = this.tableMetadataCache.computeIfAbsent(table, ignore -> {
            IcebergTableOperations operations = this.tableOperationsProvider.createTableOperations(this, session, table.getSchemaName(), table.getTableName(), Optional.empty(), Optional.empty());
            return new BaseTable((TableOperations)operations, IcebergUtil.quotedTableName(table), (MetricsReporter)TrinoMetricsReporter.TRINO_METRICS_REPORTER).operations().current();
        });
        return IcebergUtil.getIcebergTableWithMetadata(this, this.tableOperationsProvider, session, table, metadata);
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        BaseTable table = (BaseTable)this.loadTable(session, schemaTableName);
        IcebergUtil.validateTableCanBeDropped((org.apache.iceberg.Table)table);
        try {
            this.deleteTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        CatalogUtil.dropTableData((FileIO)table.io(), (TableMetadata)table.operations().current());
        this.deleteTableDirectory(this.fileSystemFactory.create(session), schemaTableName, table.location());
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        return this.newCreateTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, location, properties, Optional.of(session.getUser()));
    }

    @Override
    public void registerTable(ConnectorSession session, SchemaTableName schemaTableName, String tableLocation, String metadataLocation) throws TrinoException {
        TableInput tableInput = GlueIcebergUtil.getTableInput(schemaTableName.getTableName(), Optional.of(session.getUser()), (Map<String, String>)ImmutableMap.of((Object)"metadata_location", (Object)metadataLocation));
        this.createTable(schemaTableName.getSchemaName(), tableInput);
    }

    @Override
    public void unregisterTable(ConnectorSession session, SchemaTableName schemaTableName) {
        Table table = this.getTable(session, schemaTableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        if (!HiveUtil.isIcebergTable((Map)((Map)MoreObjects.firstNonNull((Object)table.getParameters(), (Object)ImmutableMap.of())))) {
            throw new UnknownTableTypeException(schemaTableName);
        }
        try {
            this.deleteTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        boolean newTableCreated = false;
        try {
            Table table = this.getTable(session, from).orElseThrow(() -> new TableNotFoundException(from));
            TableInput tableInput = GlueIcebergUtil.getTableInput(to.getTableName(), Optional.ofNullable(table.getOwner()), table.getParameters());
            CreateTableRequest createTableRequest = new CreateTableRequest().withDatabaseName(to.getSchemaName()).withTableInput(tableInput);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
            newTableCreated = true;
            this.deleteTable(from.getSchemaName(), from.getTableName());
        }
        catch (RuntimeException e) {
            block5: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(to.getSchemaName(), to.getTableName());
                    }
                    catch (RuntimeException cleanupException) {
                        if (cleanupException.equals(e)) break block5;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    private Optional<Table> getTable(ConnectorSession session, SchemaTableName schemaTableName) {
        try {
            Table table = (Table)this.stats.getGetTable().call(() -> this.glueClient.getTable(new GetTableRequest().withDatabaseName(schemaTableName.getSchemaName()).withName(schemaTableName.getTableName())).getTable());
            Map parameters = (Map)MoreObjects.firstNonNull((Object)table.getParameters(), (Object)ImmutableMap.of());
            if (HiveUtil.isIcebergTable((Map)parameters) && !this.tableMetadataCache.containsKey(schemaTableName)) {
                if (this.viewCache.containsKey(schemaTableName) || this.materializedViewCache.containsKey(schemaTableName)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Glue table cache inconsistency. Table cannot also be a view/materialized view");
                }
                String metadataLocation = (String)parameters.get("metadata_location");
                try {
                    IcebergTableOperations operations = this.tableOperationsProvider.createTableOperations(this, session, schemaTableName.getSchemaName(), schemaTableName.getTableName(), Optional.empty(), Optional.empty());
                    FileIO io = operations.io();
                    this.tableMetadataCache.put(schemaTableName, TableMetadataParser.read((FileIO)io, (InputFile)io.newInputFile(metadataLocation)));
                }
                catch (RuntimeException e) {
                    LOG.warn((Throwable)e, "Failed to cache table metadata from table at %s", new Object[]{metadataLocation});
                }
            } else if (ViewReaderUtil.isTrinoMaterializedView((String)GlueToTrinoConverter.getTableType((Table)table), (Map)parameters)) {
                if (this.viewCache.containsKey(schemaTableName) || this.tableMetadataCache.containsKey(schemaTableName)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Glue table cache inconsistency. Materialized View cannot also be a table or view");
                }
                try {
                    this.createMaterializedViewDefinition(session, schemaTableName, table).ifPresent(materializedView -> this.materializedViewCache.put(schemaTableName, (ConnectorMaterializedViewDefinition)materializedView));
                }
                catch (RuntimeException e) {
                    LOG.warn((Throwable)e, "Failed to cache materialized view from %s", new Object[]{schemaTableName});
                }
            } else if (ViewReaderUtil.isPrestoView((Map)parameters) && !this.viewCache.containsKey(schemaTableName)) {
                if (this.materializedViewCache.containsKey(schemaTableName) || this.tableMetadataCache.containsKey(schemaTableName)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Glue table cache inconsistency. View cannot also be a materialized view or table");
                }
                try {
                    TrinoViewUtil.getView((SchemaTableName)schemaTableName, Optional.ofNullable(table.getViewOriginalText()), (String)GlueToTrinoConverter.getTableType((Table)table), (Map)parameters, Optional.ofNullable(table.getOwner())).ifPresent(viewDefinition -> this.viewCache.put(schemaTableName, (ConnectorViewDefinition)viewDefinition));
                }
                catch (RuntimeException e) {
                    LOG.warn((Throwable)e, "Failed to cache view from %s", new Object[]{schemaTableName});
                }
            }
            return Optional.of(table);
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
    }

    private void createTable(String schemaName, TableInput tableInput) {
        this.stats.getCreateTable().call(() -> this.glueClient.createTable(new CreateTableRequest().withDatabaseName(schemaName).withTableInput(tableInput)));
    }

    private void deleteTable(String schema, String table) {
        this.stats.getDeleteTable().call(() -> this.glueClient.deleteTable(new DeleteTableRequest().withDatabaseName(schema).withName(table)));
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        Path location;
        GetDatabaseRequest getDatabaseRequest = new GetDatabaseRequest().withName(schemaTableName.getSchemaName());
        String databaseLocation = (String)this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(getDatabaseRequest).getDatabase().getLocationUri());
        String tableName = this.createNewTableName(schemaTableName.getTableName());
        if (databaseLocation == null) {
            if (this.defaultSchemaLocation.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Schema '%s' location cannot be determined. Either set the 'location' property when creating the schema, or set the 'hive.metastore.glue.default-warehouse-dir' catalog property.", schemaTableName.getSchemaName()));
            }
            String schemaDirectoryName = schemaTableName.getSchemaName() + ".db";
            location = new Path(new Path(this.defaultSchemaLocation.get(), schemaDirectoryName), tableName);
        } else {
            location = new Path(databaseLocation, tableName);
        }
        return location.toString();
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setTablePrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(schemaViewName.getTableName(), ViewReaderUtil.encodeViewData((ConnectorViewDefinition)definition), session.getUser(), TrinoViewUtil.createViewProperties((ConnectorSession)session, (String)this.trinoVersion, (String)"Trino Iceberg connector"));
        Failsafe.with((Policy)RetryPolicy.builder().withMaxRetries(3).withDelay(Duration.ofMillis(100L)).abortIf(throwable -> !replace || throwable instanceof ViewAlreadyExistsException).build(), (Policy[])new RetryPolicy[0]).run(() -> this.doCreateView(session, schemaViewName, viewTableInput, replace));
    }

    private void doCreateView(ConnectorSession session, SchemaTableName schemaViewName, TableInput viewTableInput, boolean replace) {
        Optional<Table> existing = this.getTable(session, schemaViewName);
        if (existing.isPresent()) {
            if (!replace || !ViewReaderUtil.isPrestoView((Map)((Map)MoreObjects.firstNonNull((Object)existing.get().getParameters(), (Object)ImmutableMap.of())))) {
                throw new ViewAlreadyExistsException(schemaViewName);
            }
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(schemaViewName.getSchemaName()).withTableInput(viewTableInput)));
            return;
        }
        try {
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(new CreateTableRequest().withDatabaseName(schemaViewName.getSchemaName()).withTableInput(viewTableInput)));
        }
        catch (AlreadyExistsException e) {
            throw new ViewAlreadyExistsException(schemaViewName);
        }
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        boolean newTableCreated = false;
        try {
            Table existingView = this.getTable(session, source).orElseThrow(() -> new TableNotFoundException(source));
            this.viewCache.remove(source);
            TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(target.getTableName(), existingView.getViewOriginalText(), existingView.getOwner(), TrinoViewUtil.createViewProperties((ConnectorSession)session, (String)this.trinoVersion, (String)"Trino Iceberg connector"));
            CreateTableRequest createTableRequest = new CreateTableRequest().withDatabaseName(target.getSchemaName()).withTableInput(viewTableInput);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
            newTableCreated = true;
            this.deleteTable(source.getSchemaName(), source.getTableName());
        }
        catch (Exception e) {
            block5: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(target.getSchemaName(), target.getTableName());
                    }
                    catch (Exception cleanupException) {
                        if (cleanupException.equals(e)) break block5;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setViewPrincipal is not supported for Iceberg Glue catalogs");
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        if (this.getView(session, schemaViewName).isEmpty()) {
            throw new ViewNotFoundException(schemaViewName);
        }
        try {
            this.viewCache.remove(schemaViewName);
            this.deleteTable(schemaViewName.getSchemaName(), schemaViewName.getTableName());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> namespace) {
        ImmutableList.Builder views = ImmutableList.builder();
        try {
            List<String> namespaces = this.listNamespaces(session, namespace);
            for (String glueNamespace : namespaces) {
                try {
                    views.addAll((Iterable)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getTables(arg_0), (Object)new GetTablesRequest().withDatabaseName(glueNamespace), GetTablesRequest::setNextToken, GetTablesResult::getNextToken, (AwsApiCallStats)this.stats.getGetTables()).map(GetTablesResult::getTableList).flatMap(Collection::stream).filter(table -> ViewReaderUtil.isPrestoView((Map)((Map)MoreObjects.firstNonNull((Object)table.getParameters(), (Object)ImmutableMap.of())))).map(table -> new SchemaTableName(glueNamespace, table.getName())).collect(ImmutableList.toImmutableList()));
                }
                catch (AccessDeniedException | EntityNotFoundException throwable) {}
            }
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
        return views.build();
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        ConnectorViewDefinition cachedView = this.viewCache.get(viewName);
        if (cachedView != null) {
            return Optional.of(cachedView);
        }
        if (this.tableMetadataCache.containsKey(viewName) || this.materializedViewCache.containsKey(viewName)) {
            return Optional.empty();
        }
        Optional<Table> table = this.getTable(session, viewName);
        if (table.isEmpty()) {
            return Optional.empty();
        }
        Table viewDefinition = table.get();
        return TrinoViewUtil.getView((SchemaTableName)viewName, Optional.ofNullable(viewDefinition.getViewOriginalText()), (String)GlueToTrinoConverter.getTableType((Table)viewDefinition), (Map)((Map)MoreObjects.firstNonNull((Object)viewDefinition.getParameters(), (Object)ImmutableMap.of())), Optional.ofNullable(viewDefinition.getOwner()));
    }

    @Override
    public void updateViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        ConnectorViewDefinition definition = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), comment, definition.getOwner(), definition.isRunAsInvoker());
        this.updateView(session, viewName, newDefinition);
    }

    @Override
    public void updateViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        ConnectorViewDefinition definition = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(currentViewColumn -> Objects.equals(columnName, currentViewColumn.getName()) ? new ConnectorViewDefinition.ViewColumn(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), definition.getComment(), definition.getOwner(), definition.isRunAsInvoker());
        this.updateView(session, viewName, newDefinition);
    }

    private void updateView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition newDefinition) {
        TableInput viewTableInput = GlueIcebergUtil.getViewTableInput(viewName.getTableName(), ViewReaderUtil.encodeViewData((ConnectorViewDefinition)newDefinition), session.getUser(), TrinoViewUtil.createViewProperties((ConnectorSession)session, (String)this.trinoVersion, (String)"Trino Iceberg connector"));
        try {
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(viewName.getSchemaName()).withTableInput(viewTableInput)));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> namespace) {
        ImmutableList.Builder materializedViews = ImmutableList.builder();
        try {
            List<String> namespaces = this.listNamespaces(session, namespace);
            for (String glueNamespace : namespaces) {
                try {
                    materializedViews.addAll((Iterable)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getTables(arg_0), (Object)new GetTablesRequest().withDatabaseName(glueNamespace), GetTablesRequest::setNextToken, GetTablesResult::getNextToken, (AwsApiCallStats)this.stats.getGetTables()).map(GetTablesResult::getTableList).flatMap(Collection::stream).filter(table -> ViewReaderUtil.isTrinoMaterializedView((String)GlueToTrinoConverter.getTableType((Table)table), (Map)((Map)MoreObjects.firstNonNull((Object)table.getParameters(), (Object)ImmutableMap.of())))).map(table -> new SchemaTableName(glueNamespace, table.getName())).collect(ImmutableList.toImmutableList()));
                }
                catch (AccessDeniedException | EntityNotFoundException throwable) {}
            }
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, (Throwable)e);
        }
        return materializedViews.build();
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        Optional<Table> existing = this.getTable(session, viewName);
        if (existing.isPresent()) {
            if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueToTrinoConverter.getTableType((Table)existing.get()), (Map)((Map)MoreObjects.firstNonNull((Object)existing.get().getParameters(), (Object)ImmutableMap.of())))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Existing table is not a Materialized View: " + viewName);
            }
            if (!replace) {
                if (ignoreExisting) {
                    return;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists: " + viewName);
            }
        }
        SchemaTableName storageTable = this.createMaterializedViewStorageTable(session, viewName, definition);
        TableInput materializedViewTableInput = GlueIcebergUtil.getMaterializedViewTableInput(viewName.getTableName(), IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(definition)), session.getUser(), this.createMaterializedViewProperties(session, storageTable));
        if (existing.isPresent()) {
            block10: {
                try {
                    this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(viewName.getSchemaName()).withTableInput(materializedViewTableInput)));
                }
                catch (RuntimeException e) {
                    try {
                        this.dropTable(session, storageTable);
                    }
                    catch (RuntimeException suppressed) {
                        LOG.warn((Throwable)suppressed, "Failed to drop new storage table '%s' for materialized view '%s'", new Object[]{storageTable, viewName});
                        if (e == suppressed) break block10;
                        e.addSuppressed(suppressed);
                    }
                }
            }
            this.dropStorageTable(session, existing.get());
        } else {
            this.createTable(viewName.getSchemaName(), materializedViewTableInput);
        }
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        Table view = this.getTable(session, viewName).orElseThrow(() -> new MaterializedViewNotFoundException(viewName));
        if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueToTrinoConverter.getTableType((Table)view), (Map)((Map)MoreObjects.firstNonNull((Object)view.getParameters(), (Object)ImmutableMap.of())))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Not a Materialized View: " + view.getDatabaseName() + "." + view.getName());
        }
        this.materializedViewCache.remove(viewName);
        this.dropStorageTable(session, view);
        this.deleteTable(view.getDatabaseName(), view.getName());
    }

    private void dropStorageTable(ConnectorSession session, Table view) {
        Map parameters = (Map)MoreObjects.firstNonNull((Object)view.getParameters(), (Object)ImmutableMap.of());
        String storageTableName = (String)parameters.get("storage_table");
        if (storageTableName != null) {
            String storageSchema = Optional.ofNullable((String)parameters.get("storage_schema")).orElse(view.getDatabaseName());
            try {
                this.dropTable(session, new SchemaTableName(storageSchema, storageTableName));
            }
            catch (TrinoException e) {
                LOG.warn((Throwable)e, "Failed to drop storage table '%s.%s' for materialized view '%s'", new Object[]{storageSchema, storageTableName, view.getName()});
            }
        }
    }

    @Override
    protected Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        ConnectorMaterializedViewDefinition materializedViewDefinition = this.materializedViewCache.get(viewName);
        if (materializedViewDefinition != null) {
            return Optional.of(materializedViewDefinition);
        }
        if (this.tableMetadataCache.containsKey(viewName) || this.viewCache.containsKey(viewName)) {
            return Optional.empty();
        }
        Optional<Table> maybeTable = this.getTable(session, viewName);
        if (maybeTable.isEmpty()) {
            return Optional.empty();
        }
        Table table = maybeTable.get();
        if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueToTrinoConverter.getTableType((Table)table), (Map)((Map)MoreObjects.firstNonNull((Object)table.getParameters(), (Object)ImmutableMap.of())))) {
            return Optional.empty();
        }
        return this.createMaterializedViewDefinition(session, viewName, table);
    }

    private Optional<ConnectorMaterializedViewDefinition> createMaterializedViewDefinition(ConnectorSession session, SchemaTableName viewName, Table table) {
        org.apache.iceberg.Table icebergTable;
        Map materializedViewParameters = (Map)MoreObjects.firstNonNull((Object)table.getParameters(), (Object)ImmutableMap.of());
        String storageTable = (String)materializedViewParameters.get("storage_table");
        Preconditions.checkState((storageTable != null ? 1 : 0) != 0, (Object)("Storage table missing in definition of materialized view " + viewName));
        String storageSchema = Optional.ofNullable((String)materializedViewParameters.get("storage_schema")).orElse(viewName.getSchemaName());
        SchemaTableName storageTableName = new SchemaTableName(storageSchema, storageTable);
        try {
            icebergTable = this.loadTable(session, storageTableName);
        }
        catch (RuntimeException e) {
            throw new AbstractTrinoCatalog.MaterializedViewMayBeBeingRemovedException(e);
        }
        String viewOriginalText = table.getViewOriginalText();
        if (viewOriginalText == null) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "Materialized view did not have original text " + viewName);
        }
        return Optional.of(this.getMaterializedViewDefinition(icebergTable, Optional.ofNullable(table.getOwner()), viewOriginalText, storageTableName));
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        boolean newTableCreated = false;
        try {
            Table glueTable = this.getTable(session, source).orElseThrow(() -> new TableNotFoundException(source));
            this.materializedViewCache.remove(source);
            if (!ViewReaderUtil.isTrinoMaterializedView((String)GlueToTrinoConverter.getTableType((Table)glueTable), (Map)((Map)MoreObjects.firstNonNull((Object)glueTable.getParameters(), (Object)ImmutableMap.of())))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Not a Materialized View: " + source);
            }
            TableInput tableInput = GlueIcebergUtil.getMaterializedViewTableInput(target.getTableName(), glueTable.getViewOriginalText(), glueTable.getOwner(), glueTable.getParameters());
            CreateTableRequest createTableRequest = new CreateTableRequest().withDatabaseName(target.getSchemaName()).withTableInput(tableInput);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
            newTableCreated = true;
            this.deleteTable(source.getSchemaName(), source.getTableName());
        }
        catch (RuntimeException e) {
            block6: {
                if (newTableCreated) {
                    try {
                        this.deleteTable(target.getSchemaName(), target.getTableName());
                    }
                    catch (RuntimeException cleanupException) {
                        if (cleanupException.equals(e)) break block6;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<String> targetCatalogName = IcebergSessionProperties.getHiveCatalogName(session);
        if (targetCatalogName.isEmpty()) {
            return Optional.empty();
        }
        if (HiveUtil.isHiveSystemSchema((String)tableName.getSchemaName())) {
            return Optional.empty();
        }
        int metadataMarkerIndex = tableName.getTableName().lastIndexOf(36);
        SchemaTableName tableNameBase = metadataMarkerIndex == -1 ? tableName : SchemaTableName.schemaTableName((String)tableName.getSchemaName(), (String)tableName.getTableName().substring(0, metadataMarkerIndex));
        Optional<Table> table = this.getTable(session, new SchemaTableName(tableNameBase.getSchemaName(), tableNameBase.getTableName()));
        if (table.isEmpty() || TableType.VIRTUAL_VIEW.name().equals(GlueToTrinoConverter.getTableTypeNullable((Table)table.get()))) {
            return Optional.empty();
        }
        if (!HiveUtil.isIcebergTable((Map)((Map)MoreObjects.firstNonNull((Object)table.get().getParameters(), (Object)ImmutableMap.of())))) {
            return targetCatalogName.map(catalog -> new CatalogSchemaTableName(catalog, tableName));
        }
        return Optional.empty();
    }
}

