/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.jdbi.v3.core.ConnectionFactory;

public class IcebergJdbcConnectionFactory
implements ConnectionFactory {
    private final Driver driver;
    private final String connectionUrl;
    private final Optional<String> connectionUser;
    private final Optional<String> connectionPassword;

    public IcebergJdbcConnectionFactory(Driver driver, String connectionUrl, Optional<String> connectionUser, Optional<String> connectionPassword) {
        this.driver = Objects.requireNonNull(driver, "driver is null");
        this.connectionUrl = Objects.requireNonNull(connectionUrl, "connectionUrl is null");
        this.connectionUser = Objects.requireNonNull(connectionUser, "connectionUser is null");
        this.connectionPassword = Objects.requireNonNull(connectionPassword, "connectionPassword is null");
    }

    public Connection openConnection() throws SQLException {
        Properties properties = new Properties();
        this.connectionUser.ifPresent(user -> properties.setProperty("user", (String)user));
        this.connectionPassword.ifPresent(password -> properties.setProperty("password", (String)password));
        Connection connection = this.driver.connect(this.connectionUrl, properties);
        Preconditions.checkState((connection != null ? 1 : 0) != 0, (Object)"Driver returned null connection, make sure the connection URL is valid");
        return connection;
    }
}

