/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcClient;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcTableOperations;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.iceberg.io.FileIO;

public class IcebergJdbcTableOperationsProvider
implements IcebergTableOperationsProvider {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final IcebergJdbcClient jdbcClient;

    @Inject
    public IcebergJdbcTableOperationsProvider(IcebergJdbcClient jdbcClient, TrinoFileSystemFactory fileSystemFactory) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    @Override
    public IcebergTableOperations createTableOperations(TrinoCatalog catalog, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        return new IcebergJdbcTableOperations((FileIO)new ForwardingFileIo(this.fileSystemFactory.create(session)), this.jdbcClient, session, database, table, owner, location);
    }
}

