/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.AbstractTrinoCatalog;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcClient;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.jdbc.JdbcCatalog;

public class TrinoJdbcCatalog
extends AbstractTrinoCatalog {
    private final JdbcCatalog jdbcCatalog;
    private final IcebergJdbcClient jdbcClient;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final String defaultWarehouseDir;
    private final Map<SchemaTableName, TableMetadata> tableMetadataCache = new ConcurrentHashMap<SchemaTableName, TableMetadata>();

    public TrinoJdbcCatalog(CatalogName catalogName, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, JdbcCatalog jdbcCatalog, IcebergJdbcClient jdbcClient, TrinoFileSystemFactory fileSystemFactory, boolean useUniqueTableLocation, String defaultWarehouseDir) {
        super(catalogName, typeManager, tableOperationsProvider, useUniqueTableLocation);
        this.jdbcCatalog = Objects.requireNonNull(jdbcCatalog, "jdbcCatalog is null");
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.defaultWarehouseDir = Objects.requireNonNull(defaultWarehouseDir, "defaultWarehouseDir is null");
    }

    @Override
    public boolean namespaceExists(ConnectorSession session, String namespace) {
        return this.jdbcCatalog.namespaceExists(Namespace.of((String[])new String[]{namespace}));
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        return (List)this.jdbcCatalog.listNamespaces().stream().map(namespace -> namespace.level(0).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        return (Map)this.jdbcCatalog.loadNamespaceMetadata(Namespace.of((String[])new String[]{namespace})).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        return Optional.empty();
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        try {
            this.jdbcCatalog.createNamespace(Namespace.of((String[])new String[]{namespace}), Maps.transformValues(properties, String.class::cast));
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to create a namespace " + namespace, (Throwable)e);
        }
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        this.jdbcCatalog.dropNamespace(Namespace.of((String[])new String[]{namespace}));
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setNamespacePrincipal is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameNamespace is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> namespace) {
        List<String> namespaces = this.listNamespaces(session, namespace);
        ImmutableSet.Builder tablesListBuilder = ImmutableSet.builder();
        for (String schemaName : namespaces) {
            try {
                this.jdbcCatalog.listTables(Namespace.of((String[])new String[]{schemaName})).forEach(table -> tablesListBuilder.add((Object)new SchemaTableName(schemaName, table.name())));
            }
            catch (NoSuchNamespaceException noSuchNamespaceException) {}
        }
        return tablesListBuilder.build().asList();
    }

    private List<String> listNamespaces(ConnectorSession session, Optional<String> namespace) {
        if (namespace.isPresent() && this.namespaceExists(session, namespace.get())) {
            return ImmutableList.of((Object)namespace.get());
        }
        return this.listNamespaces(session);
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        if (!this.listNamespaces(session, Optional.of(schemaTableName.getSchemaName())).contains(schemaTableName.getSchemaName())) {
            throw new SchemaNotFoundException(schemaTableName.getSchemaName());
        }
        return this.newCreateTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, location, properties, Optional.of(session.getUser()));
    }

    @Override
    public void registerTable(ConnectorSession session, SchemaTableName tableName, String tableLocation, String metadataLocation) {
        this.jdbcClient.createTable(tableName.getSchemaName(), tableName.getTableName(), metadataLocation);
    }

    @Override
    public void unregisterTable(ConnectorSession session, SchemaTableName tableName) {
        if (!this.jdbcCatalog.dropTable(TrinoJdbcCatalog.toIdentifier(tableName), false)) {
            throw new TableNotFoundException(tableName);
        }
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        BaseTable table = (BaseTable)this.loadTable(session, schemaTableName);
        IcebergUtil.validateTableCanBeDropped((Table)table);
        this.jdbcCatalog.dropTable(TrinoJdbcCatalog.toIdentifier(schemaTableName), false);
        CatalogUtil.dropTableData((FileIO)table.io(), (TableMetadata)table.operations().current());
        this.deleteTableDirectory(this.fileSystemFactory.create(session), schemaTableName, table.location());
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        try {
            this.jdbcCatalog.renameTable(TrinoJdbcCatalog.toIdentifier(from), TrinoJdbcCatalog.toIdentifier(to));
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, "Failed to rename table from %s to %s".formatted(from, to), (Throwable)e);
        }
    }

    @Override
    public Table loadTable(ConnectorSession session, SchemaTableName schemaTableName) {
        TableMetadata metadata = this.tableMetadataCache.computeIfAbsent(schemaTableName, ignore -> ((BaseTable)IcebergUtil.loadIcebergTable(this, this.tableOperationsProvider, session, schemaTableName)).operations().current());
        return IcebergUtil.getIcebergTableWithMetadata(this, this.tableOperationsProvider, session, schemaTableName, metadata);
    }

    @Override
    public void updateViewComment(ConnectorSession session, SchemaTableName schemaViewName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "updateViewComment is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void updateViewColumnComment(ConnectorSession session, SchemaTableName schemaViewName, String columnName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "updateViewColumnComment is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        Namespace namespace = Namespace.of((String[])new String[]{schemaTableName.getSchemaName()});
        String tableName = this.createNewTableName(schemaTableName.getTableName());
        Optional<Object> databaseLocation = !this.jdbcCatalog.namespaceExists(namespace) ? Optional.empty() : Optional.ofNullable((String)this.jdbcCatalog.loadNamespaceMetadata(namespace).get("location"));
        Path location = databaseLocation.isEmpty() ? new Path(new Path(this.defaultWarehouseDir, schemaTableName.getSchemaName()), tableName) : new Path((String)databaseLocation.get(), tableName);
        return location.toString();
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setTablePrincipal is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createView is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameView is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setViewPrincipal is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropView is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> namespace) {
        return ImmutableList.of();
    }

    @Override
    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> namespace) {
        return ImmutableMap.of();
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewIdentifier) {
        return Optional.empty();
    }

    @Override
    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> namespace) {
        return ImmutableList.of();
    }

    @Override
    protected Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        return Optional.empty();
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createMaterializedView is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropMaterializedView is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        return Optional.empty();
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "renameMaterializedView is not supported for Iceberg JDBC catalogs");
    }

    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        return Optional.empty();
    }

    private static TableIdentifier toIdentifier(SchemaTableName table) {
        return TableIdentifier.of((String[])new String[]{table.getSchemaName(), table.getTableName()});
    }
}

