/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcCatalogConfig;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcClient;
import io.trino.plugin.iceberg.catalog.jdbc.TrinoJdbcCatalog;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.apache.iceberg.jdbc.JdbcCatalog;

public class TrinoJdbcCatalogFactory
implements TrinoCatalogFactory {
    private final CatalogName catalogName;
    private final TypeManager typeManager;
    private final IcebergTableOperationsProvider tableOperationsProvider;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final IcebergJdbcClient jdbcClient;
    private final String jdbcCatalogName;
    private final String connectionUrl;
    private final Optional<String> connectionUser;
    private final Optional<String> connectionPassword;
    private final String defaultWarehouseDir;
    private final boolean isUniqueTableLocation;
    @GuardedBy(value="this")
    private JdbcCatalog icebergCatalog;

    @Inject
    public TrinoJdbcCatalogFactory(CatalogName catalogName, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, TrinoFileSystemFactory fileSystemFactory, IcebergJdbcClient jdbcClient, IcebergJdbcCatalogConfig jdbcConfig, IcebergConfig icebergConfig) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationsProvider is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.isUniqueTableLocation = Objects.requireNonNull(icebergConfig, "icebergConfig is null").isUniqueTableLocation();
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.jdbcCatalogName = jdbcConfig.getCatalogName();
        this.connectionUrl = jdbcConfig.getConnectionUrl();
        this.connectionUser = jdbcConfig.getConnectionUser();
        this.connectionPassword = jdbcConfig.getConnectionPassword();
        this.defaultWarehouseDir = jdbcConfig.getDefaultWarehouseDir();
    }

    @Override
    public synchronized TrinoCatalog create(ConnectorIdentity identity) {
        if (this.icebergCatalog == null) {
            this.icebergCatalog = this.createJdbcCatalog();
        }
        return new TrinoJdbcCatalog(this.catalogName, this.typeManager, this.tableOperationsProvider, this.icebergCatalog, this.jdbcClient, this.fileSystemFactory, this.isUniqueTableLocation, this.defaultWarehouseDir);
    }

    private JdbcCatalog createJdbcCatalog() {
        JdbcCatalog jdbcCatalog = new JdbcCatalog();
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"uri", (Object)this.connectionUrl);
        properties.put((Object)"warehouse", (Object)this.defaultWarehouseDir);
        this.connectionUser.ifPresent(user -> properties.put((Object)"jdbc.user", user));
        this.connectionPassword.ifPresent(password -> properties.put((Object)"jdbc.password", password));
        jdbcCatalog.initialize(this.jdbcCatalogName, (Map)properties.buildOrThrow());
        return jdbcCatalog;
    }
}

