/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.net.URI;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class IcebergRestCatalogConfig {
    private URI restUri;
    private Optional<String> warehouse = Optional.empty();
    private Security security = Security.NONE;
    private SessionType sessionType = SessionType.NONE;

    @NotNull
    public URI getBaseUri() {
        return this.restUri;
    }

    @Config(value="iceberg.rest-catalog.uri")
    @ConfigDescription(value="The URI to the REST server")
    public IcebergRestCatalogConfig setBaseUri(String uri) {
        if (uri != null) {
            this.restUri = URI.create(uri);
        }
        return this;
    }

    @NotNull
    public Security getSecurity() {
        return this.security;
    }

    @Config(value="iceberg.rest-catalog.security")
    @ConfigDescription(value="Authorization protocol to use when communicating with the REST catalog server")
    public IcebergRestCatalogConfig setSecurity(Security security) {
        this.security = security;
        return this;
    }

    @NotNull
    public SessionType getSessionType() {
        return this.sessionType;
    }

    @Config(value="iceberg.rest-catalog.session")
    @ConfigDescription(value="Type of REST catalog sessionType to use when communicating with REST catalog Server")
    public IcebergRestCatalogConfig setSessionType(SessionType sessionType) {
        this.sessionType = sessionType;
        return this;
    }

    public Optional<String> getWarehouse() {
        return this.warehouse;
    }

    @Config(value="iceberg.rest-catalog.warehouse")
    @ConfigDescription(value="The warehouse location/identifier to use with the REST catalog server")
    public IcebergRestCatalogConfig setWarehouse(String warehouse) {
        this.warehouse = Optional.ofNullable(warehouse);
        return this;
    }

    public static enum Security {
        NONE,
        OAUTH2;

    }

    public static enum SessionType {
        NONE,
        USER;

    }
}

