/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.iceberg.catalog.rest.OAuth2SecurityConfig;
import io.trino.plugin.iceberg.catalog.rest.SecurityProperties;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class OAuth2SecurityProperties
implements SecurityProperties {
    private final Map<String, String> securityProperties;

    @Inject
    public OAuth2SecurityProperties(OAuth2SecurityConfig securityConfig) {
        Objects.requireNonNull(securityConfig, "securityConfig is null");
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        securityConfig.getCredential().ifPresent(value -> propertiesBuilder.put((Object)"credential", value));
        securityConfig.getToken().ifPresent(value -> propertiesBuilder.put((Object)"token", value));
        this.securityProperties = propertiesBuilder.buildOrThrow();
    }

    @Override
    public Map<String, String> get() {
        return this.securityProperties;
    }
}

