/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.fileio;

import io.trino.filesystem.TrinoInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.iceberg.io.SeekableInputStream;

public class ForwardingSeekableInputStream
extends SeekableInputStream {
    private final TrinoInputStream stream;

    public ForwardingSeekableInputStream(TrinoInputStream stream) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
    }

    public long getPos() throws IOException {
        return this.stream.getPosition();
    }

    public void seek(long pos) throws IOException {
        this.stream.seek(pos);
    }

    public int read() throws IOException {
        return this.stream.read();
    }

    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    public byte[] readAllBytes() throws IOException {
        return this.stream.readAllBytes();
    }

    public byte[] readNBytes(int len) throws IOException {
        return this.stream.readNBytes(len);
    }

    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.stream.readNBytes(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    public void skipNBytes(long n) throws IOException {
        this.stream.skipNBytes(n);
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    public void reset() throws IOException {
        this.stream.reset();
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }

    public long transferTo(OutputStream out) throws IOException {
        return this.stream.transferTo(out);
    }
}

