/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.procedure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.util.LocationUtil;

public class RegisterTableProcedure
implements Provider<Procedure> {
    private static final MethodHandle REGISTER_TABLE;
    private static final String PROCEDURE_NAME = "register_table";
    private static final String SYSTEM_SCHEMA = "system";
    private static final String SCHEMA_NAME = "SCHEMA_NAME";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_LOCATION = "TABLE_LOCATION";
    private static final String METADATA_FILE_NAME = "METADATA_FILE_NAME";
    private final TrinoCatalogFactory catalogFactory;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final boolean registerTableProcedureEnabled;

    @Inject
    public RegisterTableProcedure(TrinoCatalogFactory catalogFactory, TrinoFileSystemFactory fileSystemFactory, IcebergConfig icebergConfig) {
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.registerTableProcedureEnabled = Objects.requireNonNull(icebergConfig, "icebergConfig is null").isRegisterTableProcedureEnabled();
    }

    public Procedure get() {
        return new Procedure(SYSTEM_SCHEMA, PROCEDURE_NAME, (List)ImmutableList.of((Object)new Procedure.Argument(SCHEMA_NAME, (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument(TABLE_NAME, (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument(TABLE_LOCATION, (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument(METADATA_FILE_NAME, (Type)VarcharType.VARCHAR, false, null)), REGISTER_TABLE.bindTo(this));
    }

    public void registerTable(ConnectorSession clientSession, String schemaName, String tableName, String tableLocation, String metadataFileName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doRegisterTable(clientSession, schemaName, tableName, tableLocation, Optional.ofNullable(metadataFileName));
        }
    }

    private void doRegisterTable(ConnectorSession clientSession, String schemaName, String tableName, String tableLocation, Optional<String> metadataFileName) {
        if (!this.registerTableProcedureEnabled) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "register_table procedure is disabled");
        }
        Procedures.checkProcedureArgument((schemaName != null && !schemaName.isEmpty() ? 1 : 0) != 0, (String)"schema_name cannot be null or empty", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((tableName != null && !tableName.isEmpty() ? 1 : 0) != 0, (String)"table_name cannot be null or empty", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((tableLocation != null && !tableLocation.isEmpty() ? 1 : 0) != 0, (String)"table_location cannot be null or empty", (Object[])new Object[0]);
        metadataFileName.ifPresent(RegisterTableProcedure::validateMetadataFileName);
        SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
        TrinoCatalog catalog = this.catalogFactory.create(clientSession.getIdentity());
        if (!catalog.namespaceExists(clientSession, schemaTableName.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", schemaTableName.getSchemaName()));
        }
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(clientSession);
        String metadataLocation = RegisterTableProcedure.getMetadataLocation(fileSystem, tableLocation, metadataFileName);
        RegisterTableProcedure.validateLocation(fileSystem, metadataLocation);
        try {
            TableMetadataParser.read((FileIO)new ForwardingFileIo(fileSystem), (String)metadataLocation);
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, metadataLocation + " is not a valid metadata file", (Throwable)e);
        }
        catalog.registerTable(clientSession, schemaTableName, tableLocation, metadataLocation);
    }

    private static void validateMetadataFileName(String fileName) {
        String metadataFileName = fileName.trim();
        Procedures.checkProcedureArgument((!metadataFileName.isEmpty() ? 1 : 0) != 0, (String)"metadata_file_name cannot be empty when provided as an argument", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((!metadataFileName.contains("/") ? 1 : 0) != 0, (String)"%s is not a valid metadata file", (Object[])new Object[]{metadataFileName});
    }

    private static String getMetadataLocation(TrinoFileSystem fileSystem, String location, Optional<String> metadataFileName) {
        return metadataFileName.map(fileName -> String.format("%s/%s/%s", LocationUtil.stripTrailingSlash((String)location), "metadata", fileName)).orElseGet(() -> RegisterTableProcedure.getLatestMetadataLocation(fileSystem, location));
    }

    public static String getLatestMetadataLocation(TrinoFileSystem fileSystem, String location) {
        ArrayList<String> latestMetadataLocations = new ArrayList<String>();
        String metadataDirectoryLocation = String.format("%s/%s", LocationUtil.stripTrailingSlash((String)location), "metadata");
        try {
            int latestMetadataVersion = -1;
            FileIterator fileIterator = fileSystem.listFiles(metadataDirectoryLocation);
            while (fileIterator.hasNext()) {
                OptionalInt version;
                FileEntry fileEntry = fileIterator.next();
                if (!fileEntry.location().contains(".metadata.json") || !(version = IcebergUtil.parseVersion(fileEntry.location())).isPresent()) continue;
                int versionNumber = version.getAsInt();
                if (versionNumber > latestMetadataVersion) {
                    latestMetadataVersion = versionNumber;
                    latestMetadataLocations.clear();
                    latestMetadataLocations.add(fileEntry.location());
                    continue;
                }
                if (versionNumber != latestMetadataVersion) continue;
                latestMetadataLocations.add(fileEntry.location());
            }
            if (latestMetadataLocations.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, "No versioned metadata file exists at location: " + metadataDirectoryLocation);
            }
            if (latestMetadataLocations.size() > 1) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("More than one latest metadata file found at location: %s, latest metadata files are %s", metadataDirectoryLocation, latestMetadataLocations));
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed checking table's location: " + location, (Throwable)e);
        }
        return (String)Iterables.getOnlyElement(latestMetadataLocations);
    }

    private static void validateLocation(TrinoFileSystem fileSystem, String location) {
        try {
            if (!fileSystem.newInputFile(location).exists()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Location %s does not exist", location));
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Invalid location: %s", location), (Throwable)e);
        }
    }

    static {
        try {
            REGISTER_TABLE = MethodHandles.lookup().unreflect(RegisterTableProcedure.class.getMethod("registerTable", ConnectorSession.class, String.class, String.class, String.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

