/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.procedure;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;

public class UnregisterTableProcedure
implements Provider<Procedure> {
    private static final MethodHandle UNREGISTER_TABLE;
    private static final String PROCEDURE_NAME = "unregister_table";
    private static final String SYSTEM_SCHEMA = "system";
    private static final String SCHEMA_NAME = "SCHEMA_NAME";
    private static final String TABLE_NAME = "TABLE_NAME";
    private final TrinoCatalogFactory catalogFactory;

    @Inject
    public UnregisterTableProcedure(TrinoCatalogFactory catalogFactory) {
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
    }

    public Procedure get() {
        return new Procedure(SYSTEM_SCHEMA, PROCEDURE_NAME, (List)ImmutableList.of((Object)new Procedure.Argument(SCHEMA_NAME, (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument(TABLE_NAME, (Type)VarcharType.VARCHAR)), UNREGISTER_TABLE.bindTo(this));
    }

    public void unregisterTable(ConnectorAccessControl accessControl, ConnectorSession session, String schemaName, String tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doUnregisterTable(accessControl, session, schemaName, tableName);
        }
    }

    private void doUnregisterTable(ConnectorAccessControl accessControl, ConnectorSession session, String schemaName, String tableName) {
        Procedures.checkProcedureArgument((!Strings.isNullOrEmpty((String)schemaName) ? 1 : 0) != 0, (String)"schema_name cannot be null or empty", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0, (String)"table_name cannot be null or empty", (Object[])new Object[0]);
        SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
        accessControl.checkCanDropTable(null, schemaTableName);
        TrinoCatalog catalog = this.catalogFactory.create(session.getIdentity());
        if (!catalog.namespaceExists(session, schemaTableName.getSchemaName())) {
            throw new SchemaNotFoundException(schemaName);
        }
        catalog.unregisterTable(session, schemaTableName);
    }

    static {
        try {
            UNREGISTER_TABLE = MethodHandles.lookup().unreflect(UnregisterTableProcedure.class.getMethod("unregisterTable", ConnectorAccessControl.class, ConnectorSession.class, String.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

