/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageCredentials;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageUri;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.UriQueryBuilder;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public final class PathUtility {
    public static URI addToSingleUriQuery(URI resourceURI, HashMap<String, String[]> fieldCollection) throws URISyntaxException, StorageException {
        if (resourceURI == null) {
            return null;
        }
        UriQueryBuilder outUri = new UriQueryBuilder();
        for (Map.Entry<String, String[]> entry : fieldCollection.entrySet()) {
            for (String val : entry.getValue()) {
                outUri.add(entry.getKey(), val);
            }
        }
        return outUri.addToURI(resourceURI);
    }

    public static StorageUri addToQuery(StorageUri resourceURI, String queryString) throws URISyntaxException, StorageException {
        return new StorageUri(PathUtility.addToSingleUriQuery(resourceURI.getPrimaryUri(), PathUtility.parseQueryString(queryString)), PathUtility.addToSingleUriQuery(resourceURI.getSecondaryUri(), PathUtility.parseQueryString(queryString)));
    }

    public static URI addToQuery(URI resourceURI, String queryString) throws URISyntaxException, StorageException {
        return PathUtility.addToSingleUriQuery(resourceURI, PathUtility.parseQueryString(queryString));
    }

    public static StorageUri appendPathToUri(StorageUri uriList, String relativeOrAbsoluteUri) throws URISyntaxException {
        return PathUtility.appendPathToUri(uriList, relativeOrAbsoluteUri, "/");
    }

    public static StorageUri appendPathToUri(StorageUri uriList, String relativeOrAbsoluteUri, String separator) throws URISyntaxException {
        return new StorageUri(PathUtility.appendPathToSingleUri(uriList.getPrimaryUri(), relativeOrAbsoluteUri, separator), PathUtility.appendPathToSingleUri(uriList.getSecondaryUri(), relativeOrAbsoluteUri, separator));
    }

    public static URI appendPathToSingleUri(URI uri, String relativeOrAbsoluteUri) throws URISyntaxException {
        return PathUtility.appendPathToSingleUri(uri, relativeOrAbsoluteUri, "/");
    }

    public static URI appendPathToSingleUri(URI uri, String relativeUri, String separator) throws URISyntaxException {
        if (uri == null) {
            return null;
        }
        if (relativeUri == null || relativeUri.isEmpty()) {
            return uri;
        }
        if (uri.getPath().length() == 0 && relativeUri.startsWith(separator)) {
            return new URI(uri.getScheme(), uri.getAuthority(), relativeUri, uri.getRawQuery(), uri.getRawFragment());
        }
        StringBuilder pathString = new StringBuilder(uri.getPath());
        if (uri.getPath().endsWith(separator)) {
            pathString.append(relativeUri);
        } else {
            pathString.append(separator);
            pathString.append(relativeUri);
        }
        return new URI(uri.getScheme(), uri.getAuthority(), pathString.toString(), uri.getQuery(), uri.getFragment());
    }

    public static String getBlobNameFromURI(URI inURI, boolean usePathStyleUris) throws URISyntaxException {
        return Utility.safeRelativize(new URI(PathUtility.getContainerURI(new StorageUri(inURI), usePathStyleUris).getPrimaryUri().toString().concat("/")), inURI);
    }

    public static String getCanonicalPathFromCredentials(StorageCredentials credentials, String absolutePath) {
        String account = credentials.getAccountName();
        if (account == null) {
            String errorMessage = "Cannot create Shared Access Signature as the credentials does not have account name information. Please check that the credentials provided support creating Shared Access Signature.";
            throw new IllegalArgumentException("Cannot create Shared Access Signature as the credentials does not have account name information. Please check that the credentials provided support creating Shared Access Signature.");
        }
        StringBuilder builder = new StringBuilder("/");
        builder.append(account);
        builder.append(absolutePath);
        return builder.toString();
    }

    public static String getContainerNameFromUri(URI resourceAddress, boolean usePathStyleUris) {
        return PathUtility.getResourceNameFromUri(resourceAddress, usePathStyleUris, String.format("Invalid blob address '%s', missing container information", resourceAddress));
    }

    public static String getFileNameFromURI(URI inURI, boolean usePathStyleUris) {
        int shareIndex;
        String[] pathSegments = inURI.getRawPath().split("/");
        int n = shareIndex = usePathStyleUris ? 2 : 1;
        if (pathSegments.length - 1 < shareIndex) {
            throw new IllegalArgumentException(String.format("Invalid file address '%s'.", inURI));
        }
        if (pathSegments.length - 1 == shareIndex) {
            return "";
        }
        return pathSegments[pathSegments.length - 1];
    }

    public static String getShareNameFromUri(URI resourceAddress, boolean usePathStyleUris) {
        return PathUtility.getResourceNameFromUri(resourceAddress, usePathStyleUris, String.format("Invalid file address '%s', missing share information", resourceAddress));
    }

    public static String getTableNameFromUri(URI resourceAddress, boolean usePathStyleUris) {
        return PathUtility.getResourceNameFromUri(resourceAddress, usePathStyleUris, String.format("Invalid table address '%s', missing table information", resourceAddress));
    }

    private static String getResourceNameFromUri(URI resourceAddress, boolean usePathStyleUris, String error) {
        int expectedPartsLength;
        Utility.assertNotNull("resourceAddress", resourceAddress);
        String[] pathSegments = resourceAddress.getRawPath().split("/");
        int n = expectedPartsLength = usePathStyleUris ? 3 : 2;
        if (pathSegments.length < expectedPartsLength) {
            throw new IllegalArgumentException(error);
        }
        String resourceName = usePathStyleUris ? pathSegments[2] : pathSegments[1];
        return Utility.trimEnd(resourceName, '/');
    }

    public static StorageUri getContainerURI(StorageUri blobAddress, boolean usePathStyleUris) throws URISyntaxException {
        String containerName = PathUtility.getContainerNameFromUri(blobAddress.getPrimaryUri(), usePathStyleUris);
        StorageUri containerUri = PathUtility.appendPathToUri(PathUtility.getServiceClientBaseAddress(blobAddress, usePathStyleUris), containerName);
        return containerUri;
    }

    public static StorageUri getShareURI(StorageUri fileAddress, boolean usePathStyleUris) throws URISyntaxException {
        String shareName = PathUtility.getShareNameFromUri(fileAddress.getPrimaryUri(), usePathStyleUris);
        StorageUri shareUri = PathUtility.appendPathToUri(PathUtility.getServiceClientBaseAddress(fileAddress, usePathStyleUris), shareName);
        return shareUri;
    }

    public static String getQueueNameFromUri(URI resourceAddress, boolean usePathStyleUris) {
        return PathUtility.getResourceNameFromUri(resourceAddress, usePathStyleUris, String.format("Invalid queue URI '%s'.", resourceAddress));
    }

    public static String getServiceClientBaseAddress(URI address, boolean usePathStyleUris) throws URISyntaxException {
        if (address == null) {
            return null;
        }
        if (usePathStyleUris) {
            String[] pathSegments = address.getRawPath().split("/");
            if (pathSegments.length < 2) {
                String error = String.format("Missing account name information inside path style URI. Path style URIs should be of the form http://<IPAddress:Port>/<accountName>", new Object[0]);
                throw new IllegalArgumentException(error);
            }
            StringBuilder completeAddress = new StringBuilder(new URI(address.getScheme(), address.getAuthority(), null, null, null).toString());
            completeAddress.append("/");
            completeAddress.append(Utility.trimEnd(pathSegments[1], '/'));
            return completeAddress.toString();
        }
        return new URI(address.getScheme(), address.getAuthority(), null, null, null).toString();
    }

    public static StorageUri getServiceClientBaseAddress(StorageUri addressUri, boolean usePathStyleUris) throws URISyntaxException {
        return new StorageUri(new URI(PathUtility.getServiceClientBaseAddress(addressUri.getPrimaryUri(), usePathStyleUris)), addressUri.getSecondaryUri() != null ? new URI(PathUtility.getServiceClientBaseAddress(addressUri.getSecondaryUri(), usePathStyleUris)) : null);
    }

    public static HashMap<String, String[]> parseQueryString(String parseString) throws StorageException {
        HashMap<String, String[]> retVals = new HashMap<String, String[]>();
        if (Utility.isNullOrEmpty(parseString)) {
            return retVals;
        }
        int queryDex = parseString.indexOf("?");
        if (queryDex >= 0 && parseString.length() > 0) {
            parseString = parseString.substring(queryDex + 1);
        }
        String[] valuePairs = parseString.contains("&") ? parseString.split("&") : parseString.split(";");
        for (int m = 0; m < valuePairs.length; ++m) {
            int equalDex = valuePairs[m].indexOf("=");
            if (equalDex < 0 || equalDex == valuePairs[m].length() - 1) continue;
            String key = valuePairs[m].substring(0, equalDex);
            String value = valuePairs[m].substring(equalDex + 1);
            key = Utility.safeDecode(key);
            value = Utility.safeDecode(value);
            String[] values = retVals.get(key);
            if (values == null) {
                values = new String[]{value};
                if (value.equals("")) continue;
                retVals.put(key, values);
                continue;
            }
            if (value.equals("")) continue;
            String[] newValues = new String[values.length + 1];
            for (int j = 0; j < values.length; ++j) {
                newValues[j] = values[j];
            }
            newValues[newValues.length] = value;
        }
        return retVals;
    }

    public static URI stripSingleURIQueryAndFragment(URI inUri) throws StorageException {
        if (inUri == null) {
            return null;
        }
        try {
            return new URI(inUri.getScheme(), inUri.getAuthority(), inUri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    public static StorageUri stripURIQueryAndFragment(StorageUri inUri) throws StorageException {
        return new StorageUri(PathUtility.stripSingleURIQueryAndFragment(inUri.getPrimaryUri()), PathUtility.stripSingleURIQueryAndFragment(inUri.getSecondaryUri()));
    }

    private PathUtility() {
    }
}

