/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import io.prestosql.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class WasbFsck
extends Configured
implements Tool {
    private FileSystem mockFileSystemForTesting = null;
    private static final String LOST_AND_FOUND_PATH = "/lost+found";
    private boolean pathNameWarning = false;

    public WasbFsck(Configuration conf) {
        super(conf);
    }

    @VisibleForTesting
    public void setMockFileSystemForTesting(FileSystem fileSystem) {
        this.mockFileSystemForTesting = fileSystem;
    }

    @Override
    public int run(String[] args) throws Exception {
        FileSystem fs;
        if (this.doPrintUsage(Arrays.asList(args))) {
            WasbFsck.printUsage();
            return -1;
        }
        Path pathToCheck = null;
        boolean doRecover = false;
        boolean doDelete = false;
        for (String arg : args) {
            if (!arg.startsWith("-")) {
                if (pathToCheck != null) {
                    System.err.println("Can't specify multiple paths to check on the command-line");
                    return 1;
                }
                pathToCheck = new Path(arg);
                continue;
            }
            if (arg.equals("-move")) {
                doRecover = true;
                continue;
            }
            if (!arg.equals("-delete")) continue;
            doDelete = true;
        }
        if (doRecover && doDelete) {
            System.err.println("Conflicting options: can't specify both -move and -delete.");
            return 1;
        }
        if (pathToCheck == null) {
            pathToCheck = new Path("/");
        }
        if (!this.recursiveCheckChildPathName(fs = this.mockFileSystemForTesting == null ? FileSystem.get(pathToCheck.toUri(), this.getConf()) : this.mockFileSystemForTesting, fs.makeQualified(pathToCheck))) {
            this.pathNameWarning = true;
        }
        if (!(fs instanceof NativeAzureFileSystem)) {
            System.err.println("Can only check WASB file system. Instead I'm asked to check: " + fs.getUri());
            return 2;
        }
        NativeAzureFileSystem wasbFs = (NativeAzureFileSystem)fs;
        if (doRecover) {
            System.out.println("Recovering files with dangling data under: " + pathToCheck);
            wasbFs.recoverFilesWithDanglingTempData(pathToCheck, new Path(LOST_AND_FOUND_PATH));
        } else if (doDelete) {
            System.out.println("Deleting temp files with dangling data under: " + pathToCheck);
            wasbFs.deleteFilesWithDanglingTempData(pathToCheck);
        } else {
            System.out.println("Please specify -move or -delete");
        }
        return 0;
    }

    public boolean getPathNameWarning() {
        return this.pathNameWarning;
    }

    private boolean recursiveCheckChildPathName(FileSystem fs, Path p) throws IOException {
        FileStatus[] listed;
        boolean flag;
        if (p == null) {
            return true;
        }
        if (!fs.exists(p)) {
            System.out.println("Path " + p + " does not exist!");
            return true;
        }
        if (fs.isFile(p)) {
            if (this.containsColon(p)) {
                System.out.println("Warning: file " + p + " has a colon in its name.");
                return false;
            }
            return true;
        }
        if (this.containsColon(p)) {
            System.out.println("Warning: directory " + p + " has a colon in its name.");
            flag = false;
        } else {
            flag = true;
        }
        for (FileStatus l : listed = fs.listStatus(p)) {
            if (this.recursiveCheckChildPathName(fs, l.getPath())) continue;
            flag = false;
        }
        return flag;
    }

    private boolean containsColon(Path p) {
        return p.toUri().getPath().toString().contains(":");
    }

    private static void printUsage() {
        System.out.println("Usage: WasbFSck [<path>] [-move | -delete]");
        System.out.println("\t<path>\tstart checking from this path");
        System.out.println("\t-move\tmove any files whose upload was interrupted mid-stream to /lost+found");
        System.out.println("\t-delete\tdelete any files whose upload was interrupted mid-stream");
        ToolRunner.printGenericCommandUsage(System.out);
    }

    private boolean doPrintUsage(List<String> args) {
        return args.contains("-H");
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run(new WasbFsck(new Configuration()), args);
        System.exit(res);
    }
}

