/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.util.DiskChecker;

public class RoundRobinVolumeChoosingPolicy<V extends FsVolumeSpi>
implements VolumeChoosingPolicy<V> {
    public static final Log LOG = LogFactory.getLog(RoundRobinVolumeChoosingPolicy.class);
    private int curVolume = 0;

    @Override
    public synchronized V chooseVolume(List<V> volumes, long blockSize) throws IOException {
        if (volumes.size() < 1) {
            throw new DiskChecker.DiskOutOfSpaceException("No more available volumes");
        }
        if (this.curVolume >= volumes.size()) {
            this.curVolume = 0;
        }
        int startVolume = this.curVolume;
        long maxAvailable = 0L;
        do {
            FsVolumeSpi volume = (FsVolumeSpi)volumes.get(this.curVolume);
            this.curVolume = (this.curVolume + 1) % volumes.size();
            long availableVolumeSize = volume.getAvailable();
            if (availableVolumeSize > blockSize) {
                return (V)volume;
            }
            if (availableVolumeSize <= maxAvailable) continue;
            maxAvailable = availableVolumeSize;
        } while (this.curVolume != startVolume);
        throw new DiskChecker.DiskOutOfSpaceException("Out of space: The volume with the most available space (=" + maxAvailable + " B) is less than the block size (=" + blockSize + " B).");
    }
}

