/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import io.prestosql.hadoop.$internal.com.google.common.base.Charsets;
import io.prestosql.hadoop.$internal.io.netty.buffer.ByteBuf;
import io.prestosql.hadoop.$internal.io.netty.buffer.Unpooled;
import io.prestosql.hadoop.$internal.io.netty.channel.ChannelFutureListener;
import io.prestosql.hadoop.$internal.io.netty.channel.ChannelHandlerContext;
import io.prestosql.hadoop.$internal.io.netty.channel.SimpleChannelInboundHandler;
import io.prestosql.hadoop.$internal.io.netty.channel.group.ChannelGroup;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.DefaultHttpResponse;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.HttpMethod;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.HttpRequest;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.HttpResponseStatus;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.HttpVersion;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.QueryStringDecoder;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.util.StringUtils;

class FSImageHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    public static final Log LOG = LogFactory.getLog(FSImageHandler.class);
    private final FSImageLoader image;
    private final ChannelGroup activeChannels;

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.activeChannels.add(ctx.channel());
    }

    FSImageHandler(FSImageLoader image, ChannelGroup activeChannels) throws IOException {
        this.image = image;
        this.activeChannels = activeChannels;
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        String content;
        if (request.getMethod() != HttpMethod.GET) {
            DefaultHttpResponse resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
            resp.headers().set("Connection", (Object)"close");
            ctx.write(resp).addListener(ChannelFutureListener.CLOSE);
            return;
        }
        QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
        String op = FSImageHandler.getOp(decoder);
        String path = FSImageHandler.getPath(decoder);
        switch (op) {
            case "GETFILESTATUS": {
                content = this.image.getFileStatus(path);
                break;
            }
            case "LISTSTATUS": {
                content = this.image.listStatus(path);
                break;
            }
            case "GETACLSTATUS": {
                content = this.image.getAclStatus(path);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for webhdfs parameter \"op\"");
            }
        }
        LOG.info("op=" + op + " target=" + path);
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer(content.getBytes(Charsets.UTF_8)));
        resp.headers().set("Content-Type", (Object)"application/json; charset=utf-8");
        resp.headers().set("Content-Length", (Object)resp.content().readableBytes());
        resp.headers().set("Connection", (Object)"close");
        ctx.write(resp).addListener(ChannelFutureListener.CLOSE);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Exception e = cause instanceof Exception ? (Exception)cause : new Exception(cause);
        String output = JsonUtil.toJsonString(e);
        ByteBuf content = Unpooled.wrappedBuffer(output.getBytes(Charsets.UTF_8));
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, content);
        resp.headers().set("Content-Type", (Object)"application/json; charset=utf-8");
        if (e instanceof IllegalArgumentException) {
            resp.setStatus(HttpResponseStatus.BAD_REQUEST);
        } else if (e instanceof FileNotFoundException) {
            resp.setStatus(HttpResponseStatus.NOT_FOUND);
        }
        resp.headers().set("Content-Length", (Object)resp.content().readableBytes());
        resp.headers().set("Connection", (Object)"close");
        ctx.write(resp).addListener(ChannelFutureListener.CLOSE);
    }

    private static String getOp(QueryStringDecoder decoder) {
        Map<String, List<String>> parameters = decoder.parameters();
        return parameters.containsKey("op") ? StringUtils.toUpperCase(parameters.get("op").get(0)) : null;
    }

    private static String getPath(QueryStringDecoder decoder) throws FileNotFoundException {
        String path = decoder.path();
        if (path.startsWith("/webhdfs/v1")) {
            return path.substring(WebHdfsHandler.WEBHDFS_PREFIX_LENGTH);
        }
        throw new FileNotFoundException("Path: " + path + " should " + "start with " + "/webhdfs/v1");
    }
}

