/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.impl;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonParser;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JsonDeserializer;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JsonNode;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.ObjectMapper;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.htrace.Span;
import org.apache.htrace.TimelineAnnotation;
import org.apache.htrace.Tracer;

@.JsonDeserialize(using=MilliSpanDeserializer.class)
public class MilliSpan
implements Span {
    private static Random rand = new Random();
    private static ObjectWriter JSON_WRITER = new ObjectMapper().writer();
    private long begin;
    private long end;
    private final String description;
    private final long traceId;
    private final long[] parents;
    private final long spanId;
    private Map<byte[], byte[]> traceInfo = null;
    private final String processId;
    private List<TimelineAnnotation> timeline = null;

    @Override
    public Span child(String description) {
        return new MilliSpan(description, this.traceId, this.spanId, rand.nextLong(), this.processId);
    }

    private MilliSpan(Builder builder) {
        this.begin = builder.begin;
        this.end = builder.end;
        this.description = builder.description;
        this.traceId = builder.traceId;
        this.parents = builder.parents;
        this.spanId = builder.spanId;
        this.traceInfo = builder.traceInfo;
        this.processId = builder.processId;
        this.timeline = builder.timeline;
    }

    public MilliSpan(String description, long traceId, long parentSpanId, long spanId, String processId) {
        this.description = description;
        this.traceId = traceId;
        this.parents = parentSpanId == 477902L ? new long[0] : new long[]{parentSpanId};
        this.spanId = spanId;
        this.begin = System.currentTimeMillis();
        this.end = 0L;
        this.processId = processId;
    }

    @Override
    public synchronized void stop() {
        if (this.end == 0L) {
            if (this.begin == 0L) {
                throw new IllegalStateException("Span for " + this.description + " has not been started");
            }
            this.end = System.currentTimeMillis();
            Tracer.getInstance().deliver(this);
        }
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public synchronized boolean isRunning() {
        return this.begin != 0L && this.end == 0L;
    }

    @Override
    public synchronized long getAccumulatedMillis() {
        if (this.begin == 0L) {
            return 0L;
        }
        if (this.end > 0L) {
            return this.end - this.begin;
        }
        return this.currentTimeMillis() - this.begin;
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public long getSpanId() {
        return this.spanId;
    }

    @Override
    public long getParentId() {
        if (this.parents.length == 0) {
            return 477902L;
        }
        return this.parents[0];
    }

    @Override
    public long getTraceId() {
        return this.traceId;
    }

    @Override
    public long getStartTimeMillis() {
        return this.begin;
    }

    @Override
    public long getStopTimeMillis() {
        return this.end;
    }

    @Override
    public void addKVAnnotation(byte[] key, byte[] value) {
        if (this.traceInfo == null) {
            this.traceInfo = new HashMap<byte[], byte[]>();
        }
        this.traceInfo.put(key, value);
    }

    @Override
    public void addTimelineAnnotation(String msg) {
        if (this.timeline == null) {
            this.timeline = new ArrayList<TimelineAnnotation>();
        }
        this.timeline.add(new TimelineAnnotation(System.currentTimeMillis(), msg));
    }

    @Override
    public Map<byte[], byte[]> getKVAnnotations() {
        if (this.traceInfo == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.traceInfo);
    }

    @Override
    public List<TimelineAnnotation> getTimelineAnnotations() {
        if (this.timeline == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.timeline);
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    @Override
    public String toJson() {
        StringWriter writer = new StringWriter();
        try {
            JSON_WRITER.writeValue(writer, (Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private static long parseUnsignedHexLong(String s) {
        return new BigInteger(s, 16).longValue();
    }

    public static class MilliSpanDeserializer
    extends JsonDeserializer<MilliSpan> {
        @Override
        public MilliSpan deserialize(JsonParser jp, .DeserializationContext ctxt) throws IOException, .JsonProcessingException {
            JsonNode timelineNode;
            JsonNode root = (JsonNode)jp.getCodec().readTree(jp);
            Builder builder = new Builder();
            builder.begin(root.get("b").asLong()).end(root.get("e").asLong()).description(root.get("d").asText()).traceId(MilliSpan.parseUnsignedHexLong(root.get("i").asText())).spanId(MilliSpan.parseUnsignedHexLong(root.get("s").asText())).processId(root.get("r").asText());
            JsonNode parentsNode = root.get("p");
            LinkedList<Long> parents = new LinkedList<Long>();
            Iterator<JsonNode> iter = parentsNode.elements();
            while (iter.hasNext()) {
                JsonNode parentIdNode = iter.next();
                parents.add(MilliSpan.parseUnsignedHexLong(parentIdNode.asText()));
            }
            builder.parents(parents);
            JsonNode traceInfoNode = root.get("n");
            if (traceInfoNode != null) {
                HashMap<byte[], byte[]> traceInfo = new HashMap<byte[], byte[]>();
                Iterator<String> iter2 = traceInfoNode.fieldNames();
                while (iter2.hasNext()) {
                    String field = iter2.next();
                    traceInfo.put(field.getBytes("UTF-8"), traceInfoNode.get(field).asText().getBytes("UTF-8"));
                }
                builder.traceInfo(traceInfo);
            }
            if ((timelineNode = root.get("t")) != null) {
                LinkedList<TimelineAnnotation> timeline = new LinkedList<TimelineAnnotation>();
                Iterator<JsonNode> iter3 = timelineNode.elements();
                while (iter3.hasNext()) {
                    JsonNode ann = iter3.next();
                    timeline.add(new TimelineAnnotation(ann.get("t").asLong(), ann.get("m").asText()));
                }
                builder.timeline(timeline);
            }
            return builder.build();
        }
    }

    public static class Builder {
        private long begin;
        private long end;
        private String description;
        private long traceId;
        private long[] parents;
        private long spanId;
        private Map<byte[], byte[]> traceInfo = null;
        private String processId;
        private List<TimelineAnnotation> timeline = null;

        public Builder begin(long begin) {
            this.begin = begin;
            return this;
        }

        public Builder end(long end) {
            this.end = end;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder traceId(long traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder parents(long[] parents) {
            this.parents = parents;
            return this;
        }

        public Builder parents(List<Long> parentList) {
            long[] parents = new long[parentList.size()];
            for (int i = 0; i < parentList.size(); ++i) {
                parents[i] = parentList.get(i);
            }
            this.parents = parents;
            return this;
        }

        public Builder spanId(long spanId) {
            this.spanId = spanId;
            return this;
        }

        public Builder traceInfo(Map<byte[], byte[]> traceInfo) {
            this.traceInfo = traceInfo.isEmpty() ? null : traceInfo;
            return this;
        }

        public Builder processId(String processId) {
            this.processId = processId;
            return this;
        }

        public Builder timeline(List<TimelineAnnotation> timeline) {
            this.timeline = timeline.isEmpty() ? null : timeline;
            return this;
        }

        public MilliSpan build() {
            return new MilliSpan(this);
        }
    }
}

