/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.buffer;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;

public class TestingPooledByteBufAllocator
extends PooledByteBufAllocator
implements Closeable {
    @GuardedBy(value="this")
    private final List<WeakReference<ByteBuf>> trackedBuffers = new ArrayList<WeakReference<ByteBuf>>();

    public TestingPooledByteBufAllocator() {
        super(false);
    }

    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        return this.track(super.newHeapBuffer(initialCapacity, maxCapacity));
    }

    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        return this.track(super.newDirectBuffer(initialCapacity, maxCapacity));
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return this.track(super.compositeHeapBuffer(maxNumComponents));
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return this.track(super.compositeDirectBuffer(maxNumComponents));
    }

    public synchronized List<ByteBuf> getReferencedBuffers() {
        return (List)this.trackedBuffers.stream().map(Reference::get).filter(Objects::nonNull).filter(byteBuf -> byteBuf.refCnt() > 0).collect(ImmutableList.toImmutableList());
    }

    private synchronized CompositeByteBuf track(CompositeByteBuf byteBuf) {
        this.trackedBuffers.add(new WeakReference<CompositeByteBuf>(byteBuf));
        this.trackedBuffers.removeIf(byteBufWeakReference -> byteBufWeakReference.get() == null);
        return byteBuf;
    }

    private synchronized ByteBuf track(ByteBuf byteBuf) {
        this.trackedBuffers.add(new WeakReference<ByteBuf>(byteBuf));
        this.trackedBuffers.removeIf(byteBufWeakReference -> byteBufWeakReference.get() == null);
        return byteBuf;
    }

    @Override
    public void close() {
        List<ByteBuf> referencedBuffers = this.getReferencedBuffers();
        if (!referencedBuffers.isEmpty()) {
            throw new AssertionError((Object)"LEAK");
        }
    }
}

