/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import io.airlift.drift.protocol.TTransportException;
import io.airlift.drift.transport.netty.client.ConnectionManager;
import io.airlift.drift.transport.netty.client.ThriftClientInitializer;
import io.airlift.drift.transport.netty.ssl.SslContextFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;

class ConnectionFactory
implements ConnectionManager {
    private final EventLoopGroup group;
    private final SslContextFactory sslContextFactory;
    private final ByteBufAllocator allocator;

    ConnectionFactory(EventLoopGroup group, SslContextFactory sslContextFactory, ByteBufAllocator allocator) {
        this.group = Objects.requireNonNull(group, "group is null");
        this.sslContextFactory = Objects.requireNonNull(sslContextFactory, "sslContextFactory is null");
        this.allocator = Objects.requireNonNull(allocator, "allocator is null");
    }

    @Override
    public Future<Channel> getConnection(ConnectionManager.ConnectionParameters connectionParameters, HostAndPort address) {
        try {
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.ALLOCATOR, (Object)this.allocator)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Ints.saturatedCast((long)connectionParameters.getConnectTimeout().toMillis()))).handler((ChannelHandler)new ThriftClientInitializer(connectionParameters.getTransport(), connectionParameters.getProtocol(), connectionParameters.getMaxFrameSize(), connectionParameters.getRequestTimeout(), connectionParameters.getSocksProxy(), connectionParameters.getSslContextParameters().map(this.sslContextFactory::get)));
            Promise promise = this.group.next().newPromise();
            bootstrap.connect((SocketAddress)new InetSocketAddress(address.getHost(), address.getPort())).addListener((GenericFutureListener)((ChannelFutureListener)future -> ConnectionFactory.notifyConnect(future, (Promise<Channel>)promise)));
            return promise;
        }
        catch (Throwable e) {
            return this.group.next().newFailedFuture((Throwable)new TTransportException(e));
        }
    }

    private static void notifyConnect(ChannelFuture future, Promise<Channel> promise) {
        if (future.isSuccess()) {
            Channel channel = future.channel();
            if (!promise.trySuccess((Object)channel)) {
                channel.close();
            }
        } else {
            promise.tryFailure(future.cause());
        }
    }

    @Override
    public void returnConnection(Channel connection) {
        connection.close();
    }

    @Override
    public void close() {
    }
}

