/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.codec;

import io.airlift.drift.protocol.TProtocol;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolUtil;
import io.airlift.drift.transport.netty.codec.Protocol;
import io.airlift.drift.transport.netty.ssl.TChannelBufferInputTransport;
import io.airlift.units.DataSize;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import java.util.List;
import java.util.Objects;

class ThriftUnframedDecoder
extends ByteToMessageDecoder {
    private final Protocol protocol;
    private final int maxFrameSize;

    public ThriftUnframedDecoder(Protocol protocol, DataSize maxFrameSize) {
        this.protocol = Objects.requireNonNull(protocol, "protocol is null");
        this.maxFrameSize = Math.toIntExact(Objects.requireNonNull(maxFrameSize, "maxFrameSize is null").toBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) {
        int frameOffset = buffer.readerIndex();
        TChannelBufferInputTransport transport = new TChannelBufferInputTransport(buffer.retain());
        try {
            TProtocol protocolReader = this.protocol.createProtocol(transport);
            protocolReader.readMessageBegin();
            TProtocolUtil.skip((TProtocolReader)protocolReader, (byte)12);
            protocolReader.readMessageEnd();
            int frameLength = buffer.readerIndex() - frameOffset;
            if (frameLength > this.maxFrameSize) {
                ctx.fireExceptionCaught((Throwable)new TooLongFrameException("Response message exceeds max size " + this.maxFrameSize + ": " + frameLength + " - discarded"));
            }
            out.add(buffer.slice(frameOffset, frameLength).retain());
        }
        catch (Throwable th) {
            buffer.readerIndex(frameOffset);
        }
        finally {
            transport.release();
        }
    }
}

