/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Common;
import org.apache.kudu.Type;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Schema {
    private final List<ColumnSchema> columnsByIndex;
    private final List<ColumnSchema> primaryKeyColumns = new ArrayList<ColumnSchema>();
    private final Map<String, Integer> columnsByName;
    private final Map<Integer, Integer> columnsById;
    private final Map<String, Integer> columnIdByName;
    private final int[] columnOffsets;
    private final int varLengthColumnCount;
    private final int rowSize;
    private final boolean hasNullableColumns;
    private final int isDeletedIndex;
    private static final int NO_IS_DELETED_INDEX = -1;

    public Schema(List<ColumnSchema> columns) {
        this(columns, null);
    }

    public Schema(List<ColumnSchema> columns, List<Integer> columnIds) {
        boolean hasColumnIds;
        boolean bl = hasColumnIds = columnIds != null;
        if (hasColumnIds && columns.size() != columnIds.size()) {
            throw new IllegalArgumentException("Schema must be constructed with all column IDs, or none.");
        }
        this.columnsByIndex = ImmutableList.copyOf(columns);
        int varLenCnt = 0;
        this.columnOffsets = new int[columns.size()];
        this.columnsByName = new HashMap<String, Integer>(columns.size());
        this.columnsById = hasColumnIds ? new HashMap(columnIds.size()) : null;
        this.columnIdByName = hasColumnIds ? new HashMap(columnIds.size()) : null;
        int offset = 0;
        boolean hasNulls = false;
        int isDeletedIndex = -1;
        for (int index = 0; index < columns.size(); ++index) {
            ColumnSchema column = columns.get(index);
            if (column.isKey()) {
                this.primaryKeyColumns.add(column);
            }
            hasNulls |= column.isNullable();
            this.columnOffsets[index] = offset;
            offset += column.getTypeSize();
            if (this.columnsByName.put(column.getName(), index) != null) {
                throw new IllegalArgumentException(String.format("Column names must be unique: %s", columns));
            }
            if (column.getType() == Type.STRING || column.getType() == Type.BINARY) {
                ++varLenCnt;
            }
            if (hasColumnIds) {
                if (this.columnsById.put(columnIds.get(index), index) != null) {
                    throw new IllegalArgumentException(String.format("Column IDs must be unique: %s", columnIds));
                }
                if (this.columnIdByName.put(column.getName(), columnIds.get(index)) != null) {
                    throw new IllegalArgumentException(String.format("Column names must be unique: %s", columnIds));
                }
            }
            if (column.getWireType() != Common.DataType.IS_DELETED) continue;
            isDeletedIndex = index;
        }
        this.varLengthColumnCount = varLenCnt;
        this.rowSize = Schema.getRowSize(this.columnsByIndex);
        this.hasNullableColumns = hasNulls;
        this.isDeletedIndex = isDeletedIndex;
    }

    public List<ColumnSchema> getColumns() {
        return this.columnsByIndex;
    }

    public int getVarLengthColumnCount() {
        return this.varLengthColumnCount;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    private static int getRowSize(List<ColumnSchema> columns) {
        int totalSize = 0;
        boolean hasNullables = false;
        for (ColumnSchema column : columns) {
            totalSize += column.getTypeSize();
            hasNullables |= column.isNullable();
        }
        if (hasNullables) {
            totalSize += Bytes.getBitSetSize(columns.size());
        }
        return totalSize;
    }

    public int getColumnOffset(int idx) {
        return this.columnOffsets[idx];
    }

    public boolean hasColumn(String columnName) {
        return this.columnsByName.containsKey(columnName);
    }

    public int getColumnIndex(String columnName) {
        Integer index = this.columnsByName.get(columnName);
        if (index == null) {
            throw new IllegalArgumentException(String.format("Unknown column: %s", columnName));
        }
        return index;
    }

    public int getColumnIndex(int columnId) {
        if (!this.hasColumnIds()) {
            throw new IllegalStateException("Schema does not have Column IDs");
        }
        Integer index = this.columnsById.get(columnId);
        if (index == null) {
            throw new IllegalArgumentException(String.format("Unknown column id: %s", columnId));
        }
        return index;
    }

    public ColumnSchema getColumnByIndex(int idx) {
        return this.columnsByIndex.get(idx);
    }

    public ColumnSchema getColumn(String columnName) {
        return this.columnsByIndex.get(this.getColumnIndex(columnName));
    }

    public int getColumnCount() {
        return this.columnsByIndex.size();
    }

    public int getPrimaryKeyColumnCount() {
        return this.primaryKeyColumns.size();
    }

    public List<ColumnSchema> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public Schema getRowKeyProjection() {
        return new Schema(this.primaryKeyColumns);
    }

    public boolean hasNullableColumns() {
        return this.hasNullableColumns;
    }

    public boolean hasColumnIds() {
        return this.columnsById != null;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public int getColumnId(String columnName) {
        return this.columnIdByName.get(columnName);
    }

    public PartialRow newPartialRow() {
        return new PartialRow(this);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public boolean hasIsDeleted() {
        return this.isDeletedIndex != -1;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public int getIsDeletedIndex() {
        Preconditions.checkState(this.hasIsDeleted(), "Schema doesn't have an IS_DELETED columns");
        return this.isDeletedIndex;
    }
}

