/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi.fop;

import com.google.shaded.shaded.common.base.Preconditions;
import com.qubole.rubix.spi.fop.ObjectFactory;
import com.qubole.rubix.spi.fop.ObjectPool;
import com.qubole.rubix.spi.fop.PoolConfig;
import com.qubole.rubix.spi.fop.Poolable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectPoolPartition<T> {
    private final CustomLogger log;
    private final ObjectPool<T> pool;
    private final PoolConfig config;
    private final BlockingQueue<Poolable<T>> objectQueue;
    private final ObjectFactory<T> objectFactory;
    private int totalCount;
    private final String host;
    private final int socketTimeout;
    private final int connectTimeout;

    public ObjectPoolPartition(ObjectPool<T> pool, PoolConfig config, ObjectFactory<T> objectFactory, BlockingQueue<Poolable<T>> queue, String host, String name) {
        this.pool = pool;
        this.config = config;
        this.objectFactory = objectFactory;
        this.objectQueue = queue;
        this.host = host;
        this.socketTimeout = config.getSocketTimeoutMilliseconds();
        this.connectTimeout = config.getConnectTimeoutMilliseconds();
        this.totalCount = 0;
        this.log = new CustomLogger(name, host);
        for (int i = 0; i < config.getMinSize(); ++i) {
            T object = objectFactory.create(host, this.socketTimeout, this.connectTimeout);
            if (object == null) continue;
            this.objectQueue.add(new Poolable<T>(object, pool, host));
            ++this.totalCount;
        }
    }

    public void returnObject(Poolable<T> object) {
        if (!this.objectFactory.validate(object.getObject())) {
            this.log.debug(String.format("Invalid object...removing: %s ", object));
            this.decreaseObject(object);
            this.increaseObjects(1, false);
            return;
        }
        this.log.debug(String.format("Returning object: %s to queue. Queue size: %d", object, this.objectQueue.size()));
        if (!this.objectQueue.offer(object)) {
            this.log.warn("Created more objects than configured. Created=" + this.totalCount + " QueueSize=" + this.objectQueue.size());
            this.decreaseObject(object);
        }
    }

    public Poolable<T> getObject(boolean blocking) {
        Poolable<T> freeObject;
        if (this.objectQueue.size() == 0) {
            Poolable<T> object = this.increaseObjects(this.config.getDelta(), true);
            if (object != null) {
                return object;
            }
            if (this.totalCount == 0) {
                throw new RuntimeException("Could not add connections to pool");
            }
        }
        try {
            if (blocking) {
                freeObject = this.objectQueue.take();
            } else {
                freeObject = this.objectQueue.poll(this.config.getMaxWaitMilliseconds(), TimeUnit.MILLISECONDS);
                if (freeObject == null) {
                    throw new RuntimeException("Cannot get a free object from the pool");
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        freeObject.setLastAccessTs(System.currentTimeMillis());
        return freeObject;
    }

    private synchronized Poolable<T> increaseObjects(int delta, boolean returnObject) {
        int oldCount = this.totalCount;
        if (delta + this.totalCount > this.config.getMaxSize()) {
            delta = this.config.getMaxSize() - this.totalCount;
        }
        Poolable<T> objectToReturn = null;
        try {
            for (int i = 0; i < delta; ++i) {
                T object = this.objectFactory.create(this.host, this.socketTimeout, this.connectTimeout);
                if (object == null) continue;
                Poolable<T> poolable = new Poolable<T>(object, this.pool, this.host);
                if (objectToReturn == null && returnObject) {
                    objectToReturn = poolable;
                } else {
                    this.objectQueue.put(poolable);
                }
                ++this.totalCount;
            }
            if (delta > 0 && this.totalCount - oldCount == 0) {
                this.log.warn(String.format("Could not increase pool size. Pool state: totalCount=%d queueSize=%d delta=%d", this.totalCount, this.objectQueue.size(), delta));
            } else {
                this.log.debug(String.format("Increased pool size by %d, to new size: %d, current queue size: %d, delta: %d", this.totalCount - oldCount, this.totalCount, this.objectQueue.size(), delta));
            }
        }
        catch (Exception e) {
            this.log.warn(String.format("Unable to increase pool size. Pool state: totalCount=%d queueSize=%d delta=%d", this.totalCount, this.objectQueue.size(), delta), e);
            if (objectToReturn != null) {
                this.objectFactory.destroy(objectToReturn.getObject());
                objectToReturn.destroy();
            }
            throw new RuntimeException(e);
        }
        return objectToReturn;
    }

    public boolean decreaseObject(Poolable<T> obj) {
        Preconditions.checkState(obj.getHost() != null, "Invalid object");
        Preconditions.checkState(obj.getHost().equals(this.host), "Call to free object of wrong partition, current partition=%s requested partition = %s", (Object)this.host, (Object)obj.getHost());
        this.objectRemoved();
        this.log.debug("Decreasing pool size object: " + obj);
        this.objectFactory.destroy(obj.getObject());
        obj.destroy();
        return true;
    }

    private synchronized void objectRemoved() {
        --this.totalCount;
    }

    public synchronized int getTotalCount() {
        return this.totalCount;
    }

    public void scavenge() throws InterruptedException {
        Poolable obj;
        int delta = this.totalCount - this.config.getMinSize();
        if (delta <= 0) {
            this.log.debug("Scavenge for delta <= 0, Skipping !!!");
            return;
        }
        int removed = 0;
        long now = System.currentTimeMillis();
        while (delta-- > 0 && (obj = (Poolable)this.objectQueue.poll()) != null) {
            this.log.debug(String.format("obj=%s, now-last=%s, max idle=%s", obj, now - obj.getLastAccessTs(), this.config.getMaxIdleMilliseconds()));
            if (now - obj.getLastAccessTs() > (long)this.config.getMaxIdleMilliseconds() && ThreadLocalRandom.current().nextDouble(1.0) < this.config.getScavengeRatio()) {
                this.log.debug("Scavenger removing object: " + obj);
                this.decreaseObject(obj);
                ++removed;
                continue;
            }
            this.objectQueue.put(obj);
            break;
        }
        if (removed > 0) {
            this.log.debug(removed + " objects were scavenged");
        }
    }

    public synchronized int shutdown() {
        int removed = 0;
        while (this.totalCount > 0) {
            Poolable obj = (Poolable)this.objectQueue.poll();
            if (obj == null) continue;
            this.decreaseObject(obj);
            ++removed;
        }
        return removed;
    }

    public String getHost() {
        return this.host;
    }

    private class CustomLogger {
        private static final String logFormatStr = "Pool: %s : Host: %s : %s";
        private final Log log = LogFactory.getLog(ObjectPoolPartition.class);
        private final String poolName;
        private final String hostName;

        public CustomLogger(String poolName, String host) {
            this.poolName = poolName;
            this.hostName = host;
        }

        public void info(String message) {
            this.log.info((Object)this.getLogMessage(message));
        }

        public void debug(String message) {
            this.log.debug((Object)this.getLogMessage(message));
        }

        public void warn(String message) {
            this.log.warn((Object)this.getLogMessage(message));
        }

        public void warn(String message, Throwable t) {
            this.log.warn((Object)this.getLogMessage(message), t);
        }

        private String getLogMessage(String message) {
            return String.format(logFormatStr, this.poolName, this.hostName, message);
        }
    }
}

