/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.hashing;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import net.openhft.hashing.Access;
import net.openhft.hashing.Primitives;
import sun.misc.Unsafe;

class UnsafeAccess
extends Access<Object> {
    public static final UnsafeAccess INSTANCE;
    static final UnsafeAccess OLD_INSTANCE;
    static final Unsafe UNSAFE;
    static final long BOOLEAN_BASE;
    static final long BYTE_BASE;
    static final long CHAR_BASE;
    static final long SHORT_BASE;
    static final long INT_BASE;
    static final long LONG_BASE;

    private UnsafeAccess() {
    }

    @Override
    public long getLong(Object input, long offset) {
        return UNSAFE.getLong(input, offset);
    }

    @Override
    public long getUnsignedInt(Object input, long offset) {
        return Primitives.unsignedInt(this.getInt(input, offset));
    }

    @Override
    public int getInt(Object input, long offset) {
        return UNSAFE.getInt(input, offset);
    }

    @Override
    public int getUnsignedShort(Object input, long offset) {
        return Primitives.unsignedShort(this.getShort(input, offset));
    }

    @Override
    public int getShort(Object input, long offset) {
        return UNSAFE.getShort(input, offset);
    }

    @Override
    public int getUnsignedByte(Object input, long offset) {
        return Primitives.unsignedByte(this.getByte(input, offset));
    }

    @Override
    public int getByte(Object input, long offset) {
        return UNSAFE.getByte(input, offset);
    }

    @Override
    public ByteOrder byteOrder(Object input) {
        return ByteOrder.nativeOrder();
    }

    static {
        OLD_INSTANCE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? new OldUnsafeAccessLittleEndian() : new OldUnsafeAccessBigEndian();
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
            BOOLEAN_BASE = UNSAFE.arrayBaseOffset(boolean[].class);
            BYTE_BASE = UNSAFE.arrayBaseOffset(byte[].class);
            CHAR_BASE = UNSAFE.arrayBaseOffset(char[].class);
            SHORT_BASE = UNSAFE.arrayBaseOffset(short[].class);
            INT_BASE = UNSAFE.arrayBaseOffset(int[].class);
            LONG_BASE = UNSAFE.arrayBaseOffset(long[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        UnsafeAccess inst = new UnsafeAccess();
        try {
            inst.getByte(new byte[1], BYTE_BASE);
        }
        catch (Throwable e) {
            inst = OLD_INSTANCE;
        }
        finally {
            INSTANCE = inst;
        }
    }

    private static class OldUnsafeAccessBigEndian
    extends UnsafeAccess {
        private OldUnsafeAccessBigEndian() {
        }

        @Override
        public int getShort(Object input, long offset) {
            return (short)UNSAFE.getInt(input, offset - 2L);
        }

        @Override
        public int getByte(Object input, long offset) {
            return (byte)UNSAFE.getInt(input, offset - 3L);
        }
    }

    private static class OldUnsafeAccessLittleEndian
    extends UnsafeAccess {
        private OldUnsafeAccessLittleEndian() {
        }

        @Override
        public int getShort(Object input, long offset) {
            return UNSAFE.getInt(input, offset - 2L) >> 16;
        }

        @Override
        public int getByte(Object input, long offset) {
            return UNSAFE.getInt(input, offset - 3L) >> 24;
        }
    }
}

