/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.LegacyConfig;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class SheetsConfig {
    private Optional<String> credentialsFilePath = Optional.empty();
    private Optional<String> credentialsKey = Optional.empty();
    private Optional<String> metadataSheetId = Optional.empty();
    private int sheetsDataMaxCacheSize = 1000;
    private Duration sheetsDataExpireAfterWrite = new Duration(5.0, TimeUnit.MINUTES);
    private Duration readTimeout = new Duration(20.0, TimeUnit.SECONDS);

    @AssertTrue(message="Exactly one of 'gsheets.credentials-key' or 'gsheets.credentials-path' must be specified")
    public @AssertTrue(message="Exactly one of 'gsheets.credentials-key' or 'gsheets.credentials-path' must be specified") boolean isCredentialsConfigurationValid() {
        return this.credentialsKey.isPresent() ^ this.credentialsFilePath.isPresent();
    }

    public @NotNull Optional<@FileExists String> getCredentialsFilePath() {
        return this.credentialsFilePath;
    }

    @Config(value="gsheets.credentials-path")
    @LegacyConfig(value={"credentials-path"})
    @ConfigDescription(value="Credential file path to google service account")
    public SheetsConfig setCredentialsFilePath(String credentialsFilePath) {
        this.credentialsFilePath = Optional.ofNullable(credentialsFilePath);
        return this;
    }

    @NotNull
    public Optional<String> getCredentialsKey() {
        return this.credentialsKey;
    }

    @Config(value="gsheets.credentials-key")
    @ConfigDescription(value="The base64 encoded credentials key")
    @ConfigSecuritySensitive
    public SheetsConfig setCredentialsKey(String credentialsKey) {
        this.credentialsKey = Optional.ofNullable(credentialsKey);
        return this;
    }

    @NotNull
    public Optional<String> getMetadataSheetId() {
        return this.metadataSheetId;
    }

    @Config(value="gsheets.metadata-sheet-id")
    @LegacyConfig(value={"metadata-sheet-id"})
    @ConfigDescription(value="Metadata sheet id containing table sheet mapping")
    public SheetsConfig setMetadataSheetId(String metadataSheetId) {
        this.metadataSheetId = Optional.ofNullable(metadataSheetId);
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSheetsDataMaxCacheSize() {
        return this.sheetsDataMaxCacheSize;
    }

    @Config(value="gsheets.max-data-cache-size")
    @LegacyConfig(value={"sheets-data-max-cache-size"})
    @ConfigDescription(value="Sheet data max cache size")
    public SheetsConfig setSheetsDataMaxCacheSize(int sheetsDataMaxCacheSize) {
        this.sheetsDataMaxCacheSize = sheetsDataMaxCacheSize;
        return this;
    }

    @MinDuration(value="1m")
    public @MinDuration(value="1m") Duration getSheetsDataExpireAfterWrite() {
        return this.sheetsDataExpireAfterWrite;
    }

    @Config(value="gsheets.data-cache-ttl")
    @LegacyConfig(value={"sheets-data-expire-after-write"})
    @ConfigDescription(value="Sheets data expire after write duration")
    public SheetsConfig setSheetsDataExpireAfterWrite(Duration sheetsDataExpireAfterWriteMinutes) {
        this.sheetsDataExpireAfterWrite = sheetsDataExpireAfterWriteMinutes;
        return this;
    }

    @MinDuration(value="0ms")
    public @MinDuration(value="0ms") Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Config(value="gsheets.read-timeout")
    public SheetsConfig setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }
}

