/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.google.sheets.SheetsClient;
import io.trino.plugin.google.sheets.SheetsColumnHandle;
import io.trino.plugin.google.sheets.SheetsConnectorTableHandle;
import io.trino.plugin.google.sheets.SheetsMetadata;
import io.trino.plugin.google.sheets.SheetsSheetTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.ptf.AbstractConnectorTableFunction;
import io.trino.spi.ptf.Argument;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.ptf.ConnectorTableFunctionHandle;
import io.trino.spi.ptf.Descriptor;
import io.trino.spi.ptf.ReturnTypeSpecification;
import io.trino.spi.ptf.ScalarArgument;
import io.trino.spi.ptf.ScalarArgumentSpecification;
import io.trino.spi.ptf.TableFunctionAnalysis;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Provider;

public class Sheet
implements Provider<ConnectorTableFunction> {
    public static final String SCHEMA_NAME = "system";
    public static final String NAME = "sheet";
    public static final String ID_ARGUMENT = "ID";
    public static final String RANGE_ARGUMENT = "RANGE";
    private final SheetsMetadata metadata;

    @Inject
    public Sheet(SheetsClient client) {
        this.metadata = new SheetsMetadata(Objects.requireNonNull(client, "client is null"));
    }

    public ConnectorTableFunction get() {
        return new SheetFunction(this.metadata);
    }

    private static void validateSheetId(String sheetId) {
        if (sheetId.contains("#")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Google sheet ID %s cannot contain '#'. Provide a range through the 'range' argument.".formatted(sheetId));
        }
    }

    public static class SheetFunction
    extends AbstractConnectorTableFunction {
        private final SheetsMetadata metadata;

        public SheetFunction(SheetsMetadata metadata) {
            super(Sheet.SCHEMA_NAME, Sheet.NAME, (List)ImmutableList.of((Object)ScalarArgumentSpecification.builder().name(Sheet.ID_ARGUMENT).type((Type)VarcharType.VARCHAR).build(), (Object)ScalarArgumentSpecification.builder().name(Sheet.RANGE_ARGUMENT).type((Type)VarcharType.VARCHAR).defaultValue((Object)Slices.utf8Slice((String)"$1:$10000")).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments) {
            String sheetId = ((Slice)((ScalarArgument)arguments.get(Sheet.ID_ARGUMENT)).getValue()).toStringUtf8();
            Sheet.validateSheetId(sheetId);
            String rangeArgument = ((Slice)((ScalarArgument)arguments.get(Sheet.RANGE_ARGUMENT)).getValue()).toStringUtf8();
            SheetsSheetTableHandle tableHandle = new SheetsSheetTableHandle(sheetId, rangeArgument);
            SheetFunctionHandle handle = new SheetFunctionHandle(tableHandle);
            List fields = (List)this.metadata.getColumnHandles(session, tableHandle).entrySet().stream().map(entry -> new Descriptor.Field((String)entry.getKey(), Optional.of(((SheetsColumnHandle)entry.getValue()).getColumnType()))).collect(ImmutableList.toImmutableList());
            Descriptor returnedType = new Descriptor(fields);
            return TableFunctionAnalysis.builder().returnedType(returnedType).handle((ConnectorTableFunctionHandle)handle).build();
        }
    }

    public static class SheetFunctionHandle
    implements ConnectorTableFunctionHandle {
        private final SheetsConnectorTableHandle tableHandle;

        @JsonCreator
        public SheetFunctionHandle(@JsonProperty(value="tableHandle") SheetsConnectorTableHandle tableHandle) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        }

        @JsonProperty
        public ConnectorTableHandle getTableHandle() {
            return this.tableHandle;
        }
    }
}

