/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.linkedin.coral.com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.materialize.LatticeTable;
import org.apache.calcite.materialize.Path;
import org.apache.calcite.materialize.Step;
import org.apache.calcite.util.mapping.IntPair;

class MutableNode {
    final LatticeTable table;
    final MutableNode parent;
    final Step step;
    int startCol;
    int endCol;
    String alias;
    final List<MutableNode> children = new ArrayList<MutableNode>();
    static final Ordering<MutableNode> ORDERING = Ordering.from(new Comparator<MutableNode>(){

        @Override
        public int compare(MutableNode o1, MutableNode o2) {
            int c = Ordering.natural().lexicographical().compare(o1.table.t.getQualifiedName(), o2.table.t.getQualifiedName());
            if (c == 0) {
                c = Ordering.natural().lexicographical().compare(IntPair.left(o1.step.keys), IntPair.left(o2.step.keys));
            }
            return c;
        }
    });

    MutableNode(LatticeTable table) {
        this(table, null, null);
    }

    MutableNode(LatticeTable table, MutableNode parent, Step step) {
        this.table = Objects.requireNonNull(table);
        this.parent = parent;
        this.step = step;
        if (parent != null) {
            parent.children.add(this);
            Collections.sort(parent.children, ORDERING);
        }
    }

    void flatten(List<MutableNode> flatNodes) {
        flatNodes.add(this);
        for (MutableNode child : this.children) {
            child.flatten(flatNodes);
        }
    }

    boolean isCyclic() {
        HashSet<MutableNode> descendants = new HashSet<MutableNode>();
        return this.isCyclicRecurse(descendants);
    }

    private boolean isCyclicRecurse(Set<MutableNode> descendants) {
        if (!descendants.add(this)) {
            return true;
        }
        for (MutableNode child : this.children) {
            if (!child.isCyclicRecurse(descendants)) continue;
            return true;
        }
        return false;
    }

    void addPath(Path path, String alias) {
        MutableNode n = this;
        for (Step step1 : path.steps) {
            MutableNode n2 = n.findChild(step1);
            if (n2 == null) {
                n2 = new MutableNode(step1.target(), n, step1);
                if (alias != null) {
                    n2.alias = alias;
                }
            }
            n = n2;
        }
    }

    private MutableNode findChild(Step step) {
        for (MutableNode child : this.children) {
            if (!child.table.equals(step.target()) || !child.step.equals(step)) continue;
            return child;
        }
        return null;
    }
}

