/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.Property;
import coral.shading.io.trino.sql.tree.QualifiedName;
import coral.shading.io.trino.sql.tree.Query;
import coral.shading.io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateMaterializedView
extends Statement {
    private final QualifiedName name;
    private final Query query;
    private final boolean replace;
    private final boolean notExists;
    private final List<Property> properties;
    private final Optional<String> comment;

    public CreateMaterializedView(Optional<NodeLocation> location, QualifiedName name, Query query, boolean replace, boolean notExists, List<Property> properties, Optional<String> comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.replace = replace;
        this.notExists = notExists;
        this.properties = properties;
        this.comment = comment;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateMaterializedView(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.replace, this.notExists, this.properties, this.comment);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateMaterializedView o = (CreateMaterializedView)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.replace, o.replace) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.properties, o.properties) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("query", this.query).add("replace", this.replace).add("notExists", this.notExists).add("properties", this.properties).add("comment", this.comment).toString();
    }
}

