/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Expression;
import coral.shading.io.trino.sql.tree.GroupingElement;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Rollup
extends GroupingElement {
    private final List<Expression> columns;

    public Rollup(List<Expression> columns) {
        this(Optional.empty(), columns);
    }

    public Rollup(NodeLocation location, List<Expression> columns) {
        this(Optional.of(location), columns);
    }

    private Rollup(Optional<NodeLocation> location, List<Expression> columns) {
        super(location);
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
    }

    @Override
    public List<Expression> getExpressions() {
        return this.columns;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRollup(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rollup rollup = (Rollup)o;
        return Objects.equals(this.columns, rollup.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columns);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("columns", this.columns).toString();
    }
}

