/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.Joiner;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Expression;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.QueryBody;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Values
extends QueryBody {
    private final List<Expression> rows;

    public Values(List<Expression> rows) {
        this(Optional.empty(), rows);
    }

    public Values(NodeLocation location, List<Expression> rows) {
        this(Optional.of(location), rows);
    }

    private Values(Optional<NodeLocation> location, List<Expression> rows) {
        super(location);
        Objects.requireNonNull(rows, "rows is null");
        this.rows = ImmutableList.copyOf(rows);
    }

    public List<Expression> getRows() {
        return this.rows;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitValues(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.rows;
    }

    @Override
    public String toString() {
        return "(" + Joiner.on(", ").join(this.rows) + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rows);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Values other = (Values)obj;
        return Objects.equals(this.rows, other.rows);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return Values.sameClass(this, other);
    }
}

