/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Identifier;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.WindowSpecification;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WindowDefinition
extends Node {
    private final Identifier name;
    private final WindowSpecification window;

    public WindowDefinition(Identifier name, WindowSpecification window) {
        this(Optional.empty(), name, window);
    }

    public WindowDefinition(NodeLocation location, Identifier name, WindowSpecification window) {
        this(Optional.of(location), name, window);
    }

    private WindowDefinition(Optional<NodeLocation> location, Identifier name, WindowSpecification window) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.window = Objects.requireNonNull(window, "window is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public WindowSpecification getWindow() {
        return this.window;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowDefinition(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.window);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowDefinition o = (WindowDefinition)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.window, o.window);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.window);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("window", this.window).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!WindowDefinition.sameClass(this, other)) {
            return false;
        }
        return this.name.equals(((WindowDefinition)other).name);
    }
}

