/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlRowTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlRowTypeSpec
extends SqlDataTypeSpec {
    public SqlRowTypeSpec(List<String> fieldNames, List<SqlDataTypeSpec> fieldTypeSpecs, SqlParserPos pos) {
        this(new SqlRowTypeNameSpec(pos, SqlRowTypeSpec.toIdentifierList(fieldNames, pos), fieldTypeSpecs), null, pos);
    }

    public SqlRowTypeSpec(List<String> fieldNames, List<SqlDataTypeSpec> fieldTypeSpecs, Boolean nullable, SqlParserPos pos) {
        this(new SqlRowTypeNameSpec(pos, SqlRowTypeSpec.toIdentifierList(fieldNames, pos), fieldTypeSpecs), nullable, pos);
    }

    private SqlRowTypeSpec(SqlRowTypeNameSpec rowTypeNameSpec, Boolean nullable, SqlParserPos pos) {
        super(rowTypeNameSpec, null, nullable, pos);
    }

    private static List<SqlIdentifier> toIdentifierList(List<String> fieldNames, SqlParserPos pos) {
        ArrayList<SqlIdentifier> results = new ArrayList<SqlIdentifier>();
        for (String fieldName : fieldNames) {
            results.add(new SqlIdentifier(fieldName, pos));
        }
        return results;
    }

    public List<String> getFieldNames() {
        return this.toStringList(((SqlRowTypeNameSpec)this.getTypeNameSpec()).getFieldNames());
    }

    private List<String> toStringList(List<SqlIdentifier> fieldNames) {
        ArrayList<String> results = new ArrayList<String>();
        for (SqlIdentifier fieldName : fieldNames) {
            results.add(fieldName.toString());
        }
        return results;
    }

    public List<SqlDataTypeSpec> getFieldTypeSpecs() {
        return ((SqlRowTypeNameSpec)this.getTypeNameSpec()).getFieldTypes();
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlRowTypeSpec((SqlRowTypeNameSpec)this.getTypeNameSpec(), this.getNullable(), pos);
    }

    @Override
    public SqlDataTypeSpec withNullable(Boolean nullable) {
        if (Objects.equals(this.getNullable(), nullable)) {
            return this;
        }
        return new SqlRowTypeSpec((SqlRowTypeNameSpec)this.getTypeNameSpec(), nullable, this.getParserPosition());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.getTypeNameSpec().unparse(writer, leftPrec, rightPrec);
    }
}

