/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import io.trino.filesystem.TrinoInput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Objects;

class LocalInput
implements TrinoInput {
    private final File file;
    private final RandomAccessFile input;

    public LocalInput(File file) throws IOException {
        this.file = Objects.requireNonNull(file, "file is null");
        this.input = new RandomAccessFile(file, "r");
    }

    @Override
    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.input.seek(position);
        this.input.readFully(buffer, bufferOffset, bufferLength);
    }

    @Override
    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        int readSize = (int)Math.min(this.file.length(), (long)bufferLength);
        this.readFully(this.file.length() - (long)readSize, buffer, bufferOffset, readSize);
        return readSize;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    public String toString() {
        return this.file.getPath();
    }
}

