/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;
import org.bson.Document;

public class MongoColumnHandle
implements ColumnHandle {
    private final String name;
    private final Type type;
    private final boolean hidden;
    private final Optional<String> comment;

    @JsonCreator
    public MongoColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="columnType") Type type, @JsonProperty(value="hidden") boolean hidden, @JsonProperty(value="comment") Optional<String> comment) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.hidden = hidden;
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="columnType")
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    public ColumnMetadata toColumnMetadata() {
        return ColumnMetadata.builder().setName(this.name).setType(this.type).setHidden(this.hidden).setComment(this.comment).build();
    }

    public Document getDocument() {
        return new Document().append("name", (Object)this.name).append("type", (Object)this.type.getTypeSignature().toString()).append("hidden", (Object)this.hidden).append("comment", this.comment.orElse(null));
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.hidden, this.comment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MongoColumnHandle other = (MongoColumnHandle)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.hidden, other.hidden) && Objects.equals(this.comment, other.comment);
    }

    public String toString() {
        return this.name + ":" + this.type;
    }
}

