/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Streams;
import com.google.common.io.Closer;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.trino.plugin.base.TemporaryTables;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.MongoIndex;
import io.trino.plugin.mongodb.MongoInsertTableHandle;
import io.trino.plugin.mongodb.MongoOutputTableHandle;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.MongoTable;
import io.trino.plugin.mongodb.MongoTableHandle;
import io.trino.plugin.mongodb.RemoteTableName;
import io.trino.plugin.mongodb.TypeUtils;
import io.trino.plugin.mongodb.ptf.Query;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.NotFoundException;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortingProperty;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.ptf.ConnectorTableFunctionHandle;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(MongoMetadata.class);
    private static final Type TRINO_PAGE_SINK_ID_COLUMN_TYPE = BigintType.BIGINT;
    private static final int MAX_QUALIFIED_IDENTIFIER_BYTE_LENGTH = 120;
    private final MongoSession mongoSession;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();

    public MongoMetadata(MongoSession mongoSession) {
        this.mongoSession = Objects.requireNonNull(mongoSession, "mongoSession is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.mongoSession.getAllSchemas();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        Preconditions.checkArgument((boolean)properties.isEmpty(), (Object)"Can't have properties for schema creation");
        this.mongoSession.createSchema(schemaName);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        this.mongoSession.dropSchema(schemaName);
    }

    public MongoTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        try {
            return this.mongoSession.getTable(tableName).getTableHandle();
        }
        catch (TableNotFoundException e) {
            log.debug((Throwable)e, "Table(%s) not found", new Object[]{tableName});
            return null;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        SchemaTableName tableName = MongoMetadata.getTableName(tableHandle);
        return this.getTableMetadata(tableName);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        List schemaNames = (List)optionalSchemaName.map(ImmutableList::of).orElseGet(() -> (ImmutableList)this.listSchemaNames(session));
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : schemaNames) {
            for (String tableName : this.mongoSession.getAllTables(schemaName)) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName.toLowerCase(Locale.ENGLISH)));
            }
        }
        return tableNames.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        List<MongoColumnHandle> columns = this.mongoSession.getTable(table.getSchemaTableName()).getColumns();
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (MongoColumnHandle columnHandle : columns) {
            columnHandles.put((Object)columnHandle.getName().toLowerCase(Locale.ENGLISH), (Object)columnHandle);
        }
        return columnHandles.buildOrThrow();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (NotFoundException notFoundException) {}
        }
        return columns.buildOrThrow();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTable().isEmpty()) {
            return this.listTables(session, prefix.getSchema());
        }
        return ImmutableList.of((Object)prefix.toSchemaTableName());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((MongoColumnHandle)columnHandle).toColumnMetadata();
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        RemoteTableName remoteTableName = this.mongoSession.toRemoteSchemaTableName(tableMetadata.getTable());
        this.mongoSession.createTable(remoteTableName, MongoMetadata.buildColumnHandles(tableMetadata), tableMetadata.getComment());
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        this.mongoSession.dropTable(table.getRemoteTableName());
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        this.mongoSession.setTableComment(table, comment);
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, Optional<String> comment) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        MongoColumnHandle column = (MongoColumnHandle)columnHandle;
        this.mongoSession.setColumnComment(table, column.getName(), comment);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        if (newTableName.toString().getBytes(StandardCharsets.UTF_8).length > 120) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Qualified identifier name must be shorter than or equal to '%s' bytes: '%s'", 120, newTableName));
        }
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        this.mongoSession.renameTable(table, newTableName);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        this.mongoSession.addColumn((MongoTableHandle)tableHandle, column);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        this.mongoSession.dropColumn((MongoTableHandle)tableHandle, ((MongoColumnHandle)column).getName());
    }

    public void setColumnType(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, Type type) {
        MongoTableHandle table = (MongoTableHandle)tableHandle;
        MongoColumnHandle column = (MongoColumnHandle)columnHandle;
        if (!MongoMetadata.canChangeColumnType(column.getType(), type)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot change type from %s to %s".formatted(column.getType(), type));
        }
        this.mongoSession.setColumnType(table, column.getName(), type);
    }

    private static boolean canChangeColumnType(Type sourceType, Type newType) {
        if (sourceType.equals(newType)) {
            return true;
        }
        if (sourceType == TinyintType.TINYINT) {
            return newType == SmallintType.SMALLINT || newType == IntegerType.INTEGER || newType == BigintType.BIGINT;
        }
        if (sourceType == SmallintType.SMALLINT) {
            return newType == IntegerType.INTEGER || newType == BigintType.BIGINT;
        }
        if (sourceType == IntegerType.INTEGER) {
            return newType == BigintType.BIGINT;
        }
        if (sourceType == RealType.REAL) {
            return newType == DoubleType.DOUBLE;
        }
        if (sourceType instanceof VarcharType || sourceType instanceof CharType) {
            return newType instanceof VarcharType || newType instanceof CharType;
        }
        if (sourceType instanceof DecimalType) {
            DecimalType sourceDecimal = (DecimalType)sourceType;
            if (newType instanceof DecimalType) {
                DecimalType newDecimal = (DecimalType)newType;
                return sourceDecimal.getScale() == newDecimal.getScale() && sourceDecimal.getPrecision() <= newDecimal.getPrecision();
            }
        }
        if (sourceType instanceof ArrayType) {
            ArrayType sourceArrayType = (ArrayType)sourceType;
            if (newType instanceof ArrayType) {
                ArrayType newArrayType = (ArrayType)newType;
                return MongoMetadata.canChangeColumnType(sourceArrayType.getElementType(), newArrayType.getElementType());
            }
        }
        if (sourceType instanceof RowType) {
            RowType sourceRowType = (RowType)sourceType;
            if (newType instanceof RowType) {
                RowType newRowType = (RowType)newType;
                List fields = (List)Streams.concat((Stream[])new Stream[]{sourceRowType.getFields().stream(), newRowType.getFields().stream()}).distinct().collect(ImmutableList.toImmutableList());
                for (RowType.Field field : fields) {
                    String fieldName = (String)field.getName().orElseThrow();
                    if (!MongoMetadata.fieldExists(sourceRowType, fieldName) || !MongoMetadata.fieldExists(newRowType, fieldName) || MongoMetadata.canChangeColumnType(MongoMetadata.findFieldByName(sourceRowType.getFields(), fieldName).getType(), MongoMetadata.findFieldByName(newRowType.getFields(), fieldName).getType())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static RowType.Field findFieldByName(List<RowType.Field> fields, String fieldName) {
        return (RowType.Field)fields.stream().filter(field -> ((String)field.getName().orElseThrow()).equals(fieldName)).collect(MoreCollectors.onlyElement());
    }

    private static boolean fieldExists(RowType structType, String fieldName) {
        for (RowType.Field field : structType.getFields()) {
            if (!((String)field.getName().orElseThrow()).equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        RemoteTableName remoteTableName = this.mongoSession.toRemoteSchemaTableName(tableMetadata.getTable());
        List<MongoColumnHandle> columns = MongoMetadata.buildColumnHandles(tableMetadata);
        this.mongoSession.createTable(remoteTableName, columns, tableMetadata.getComment());
        List handleColumns = (List)columns.stream().filter(column -> !column.isHidden()).collect(ImmutableList.toImmutableList());
        Closer closer = Closer.create();
        closer.register(() -> this.mongoSession.dropTable(remoteTableName));
        this.setRollback(() -> {
            try {
                closer.close();
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
            }
        });
        if (retryMode == RetryMode.NO_RETRIES) {
            return new MongoOutputTableHandle(remoteTableName, handleColumns, Optional.empty(), Optional.empty());
        }
        MongoColumnHandle pageSinkIdColumn = MongoMetadata.buildPageSinkIdColumn((Set)columns.stream().map(MongoColumnHandle::getName).collect(ImmutableSet.toImmutableSet()));
        ImmutableList allTemporaryTableColumns = ImmutableList.builderWithExpectedSize((int)(columns.size() + 1)).addAll(columns).add((Object)pageSinkIdColumn).build();
        RemoteTableName temporaryTable = new RemoteTableName(remoteTableName.getDatabaseName(), TemporaryTables.generateTemporaryTableName((ConnectorSession)session));
        this.mongoSession.createTable(temporaryTable, (List<MongoColumnHandle>)allTemporaryTableColumns, Optional.empty());
        closer.register(() -> this.mongoSession.dropTable(temporaryTable));
        return new MongoOutputTableHandle(remoteTableName, handleColumns, Optional.of(temporaryTable.getCollectionName()), Optional.of(pageSinkIdColumn.getName()));
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        MongoOutputTableHandle handle = (MongoOutputTableHandle)tableHandle;
        if (handle.getTemporaryTableName().isPresent()) {
            this.finishInsert(session, handle.getRemoteTableName(), handle.getTemporaryRemoteTableName().get(), handle.getPageSinkIdColumnName().get(), fragments);
        }
        this.clearRollback();
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> insertedColumns, RetryMode retryMode) {
        MongoTable table = this.mongoSession.getTable(((MongoTableHandle)tableHandle).getSchemaTableName());
        MongoTableHandle handle = table.getTableHandle();
        List<MongoColumnHandle> columns = table.getColumns();
        List handleColumns = (List)columns.stream().filter(column -> !column.isHidden()).peek(column -> MongoMetadata.validateColumnNameForInsert(column.getName())).collect(ImmutableList.toImmutableList());
        if (retryMode == RetryMode.NO_RETRIES) {
            return new MongoInsertTableHandle(handle.getRemoteTableName(), handleColumns, Optional.empty(), Optional.empty());
        }
        MongoColumnHandle pageSinkIdColumn = MongoMetadata.buildPageSinkIdColumn((Set)columns.stream().map(MongoColumnHandle::getName).collect(ImmutableSet.toImmutableSet()));
        ImmutableList allColumns = ImmutableList.builderWithExpectedSize((int)(columns.size() + 1)).addAll(columns).add((Object)pageSinkIdColumn).build();
        RemoteTableName temporaryTable = new RemoteTableName(handle.getSchemaTableName().getSchemaName(), TemporaryTables.generateTemporaryTableName((ConnectorSession)session));
        this.mongoSession.createTable(temporaryTable, (List<MongoColumnHandle>)allColumns, Optional.empty());
        this.setRollback(() -> this.mongoSession.dropTable(temporaryTable));
        return new MongoInsertTableHandle(handle.getRemoteTableName(), handleColumns, Optional.of(temporaryTable.getCollectionName()), Optional.of(pageSinkIdColumn.getName()));
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        MongoInsertTableHandle handle = (MongoInsertTableHandle)insertHandle;
        if (handle.getTemporaryTableName().isPresent()) {
            this.finishInsert(session, handle.getRemoteTableName(), handle.getTemporaryRemoteTableName().get(), handle.getPageSinkIdColumnName().get(), fragments);
        }
        this.clearRollback();
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInsert(ConnectorSession session, RemoteTableName targetTable, RemoteTableName temporaryTable, String pageSinkIdColumnName, Collection<Slice> fragments) {
        Closer closer = Closer.create();
        closer.register(() -> this.mongoSession.dropTable(temporaryTable));
        try {
            RemoteTableName pageSinkIdsTable = new RemoteTableName(temporaryTable.getDatabaseName(), TemporaryTables.generateTemporaryTableName((ConnectorSession)session));
            MongoColumnHandle pageSinkIdColumn = new MongoColumnHandle(pageSinkIdColumnName, TRINO_PAGE_SINK_ID_COLUMN_TYPE, false, Optional.empty());
            this.mongoSession.createTable(pageSinkIdsTable, (List<MongoColumnHandle>)ImmutableList.of((Object)pageSinkIdColumn), Optional.empty());
            closer.register(() -> this.mongoSession.dropTable(pageSinkIdsTable));
            MongoCollection<Document> pageSinkIdsCollection = this.mongoSession.getCollection(pageSinkIdsTable);
            List pageSinkIds = (List)fragments.stream().map(slice -> new Document(pageSinkIdColumnName, (Object)slice.getLong(0))).collect(ImmutableList.toImmutableList());
            pageSinkIdsCollection.insertMany(pageSinkIds);
            MongoCollection<Document> temporaryCollection = this.mongoSession.getCollection(temporaryTable);
            temporaryCollection.aggregate((List)ImmutableList.of((Object)Aggregates.lookup((String)pageSinkIdsTable.getCollectionName(), (String)pageSinkIdColumnName, (String)pageSinkIdColumnName, (String)"page_sink_id"), (Object)Aggregates.match((Bson)Filters.ne((String)"page_sink_id", (Object)ImmutableList.of())), (Object)Aggregates.project((Bson)Projections.exclude((String[])new String[]{"page_sink_id"})), (Object)Aggregates.merge((String)targetTable.getCollectionName()))).toCollection();
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
            }
        }
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new MongoColumnHandle("$merge_row_id", (Type)BigintType.BIGINT, true, Optional.empty());
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.of(handle);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle handle) {
        MongoTableHandle table = (MongoTableHandle)handle;
        return OptionalLong.of(this.mongoSession.deleteDocuments(table.getRemoteTableName(), table.getConstraint()));
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        MongoTableHandle tableHandle = (MongoTableHandle)table;
        Optional partitioningColumns = Optional.empty();
        ImmutableList.Builder localProperties = ImmutableList.builder();
        MongoTable tableInfo = this.mongoSession.getTable(tableHandle.getSchemaTableName());
        Map<String, ColumnHandle> columns = this.getColumnHandles(session, tableHandle);
        for (MongoIndex index : tableInfo.getIndexes()) {
            for (MongoIndex.MongodbIndexKey key : index.getKeys()) {
                if (key.getSortOrder().isEmpty() || columns.get(key.getName()) == null) continue;
                localProperties.add((Object)new SortingProperty((Object)columns.get(key.getName()), key.getSortOrder().get()));
            }
        }
        return new ConnectorTableProperties(TupleDomain.all(), Optional.empty(), partitioningColumns, Optional.empty(), (List)localProperties.build());
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        MongoTableHandle handle = (MongoTableHandle)table;
        if (limit == 0L) {
            return Optional.empty();
        }
        if (limit > Integer.MAX_VALUE) {
            return Optional.empty();
        }
        if (handle.getLimit().isPresent() && (long)handle.getLimit().getAsInt() <= limit) {
            return Optional.empty();
        }
        return Optional.of(new LimitApplicationResult((Object)new MongoTableHandle(handle.getSchemaTableName(), handle.getRemoteTableName(), handle.getFilter(), handle.getConstraint(), OptionalInt.of(Math.toIntExact(limit))), true, false));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain remainingFilter;
        MongoTableHandle handle = (MongoTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        TupleDomain newDomain = oldDomain.intersect(constraint.getSummary());
        if (newDomain.isNone()) {
            remainingFilter = TupleDomain.all();
        } else {
            Map domains = (Map)newDomain.getDomains().orElseThrow();
            HashMap<ColumnHandle, Domain> supported = new HashMap<ColumnHandle, Domain>();
            HashMap<MongoColumnHandle, Domain> unsupported = new HashMap<MongoColumnHandle, Domain>();
            for (Map.Entry entry : domains.entrySet()) {
                MongoColumnHandle columnHandle = (MongoColumnHandle)entry.getKey();
                Domain domain = (Domain)entry.getValue();
                Type columnType = columnHandle.getType();
                if (TypeUtils.isPushdownSupportedType(columnType)) {
                    supported.put((ColumnHandle)entry.getKey(), (Domain)entry.getValue());
                    continue;
                }
                unsupported.put(columnHandle, domain);
            }
            newDomain = TupleDomain.withColumnDomains(supported);
            remainingFilter = TupleDomain.withColumnDomains(unsupported);
        }
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        handle = new MongoTableHandle(handle.getSchemaTableName(), handle.getRemoteTableName(), handle.getFilter(), (TupleDomain<ColumnHandle>)newDomain, handle.getLimit());
        return Optional.of(new ConstraintApplicationResult((Object)handle, remainingFilter, false));
    }

    public Optional<TableFunctionApplicationResult<ConnectorTableHandle>> applyTableFunction(ConnectorSession session, ConnectorTableFunctionHandle handle) {
        if (!(handle instanceof Query.QueryFunctionHandle)) {
            return Optional.empty();
        }
        ConnectorTableHandle tableHandle = ((Query.QueryFunctionHandle)handle).getTableHandle();
        ConnectorTableSchema tableSchema = this.getTableSchema(session, tableHandle);
        Map<String, ColumnHandle> columnHandlesByName = this.getColumnHandles(session, tableHandle);
        List columnHandles = (List)tableSchema.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnSchema::getName).map(columnHandlesByName::get).collect(ImmutableList.toImmutableList());
        return Optional.of(new TableFunctionApplicationResult((Object)tableHandle, columnHandles));
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"rollback action is already set");
    }

    private void clearRollback() {
        this.rollbackAction.set(null);
    }

    public void rollback() {
        Optional.ofNullable(this.rollbackAction.getAndSet(null)).ifPresent(Runnable::run);
    }

    private static SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        return ((MongoTableHandle)tableHandle).getSchemaTableName();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        MongoTable mongoTable = this.mongoSession.getTable(tableName);
        List columns = (List)mongoTable.getColumns().stream().map(MongoColumnHandle::toColumnMetadata).collect(ImmutableList.toImmutableList());
        return new ConnectorTableMetadata(tableName, columns, (Map)ImmutableMap.of(), mongoTable.getComment());
    }

    private static List<MongoColumnHandle> buildColumnHandles(ConnectorTableMetadata tableMetadata) {
        return tableMetadata.getColumns().stream().map(m -> new MongoColumnHandle(m.getName(), m.getType(), m.isHidden(), Optional.ofNullable(m.getComment()))).collect(Collectors.toList());
    }

    private static void validateColumnNameForInsert(String columnName) {
        if (columnName.contains("$") || columnName.contains(".")) {
            throw new IllegalArgumentException("Column name must not contain '$' or '.' for INSERT: " + columnName);
        }
    }

    private static MongoColumnHandle buildPageSinkIdColumn(Set<String> otherColumnNames) {
        String baseColumnName = "trino_page_sink_id";
        Object columnName = baseColumnName;
        int suffix = 1;
        while (otherColumnNames.contains(columnName)) {
            columnName = baseColumnName + "_" + suffix;
            ++suffix;
        }
        return new MongoColumnHandle((String)columnName, TRINO_PAGE_SINK_ID_COLUMN_TYPE, false, Optional.empty());
    }
}

