/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.jdbc.DynamicFilteringStats;
import io.trino.plugin.jdbc.ForJdbcDynamicFiltering;
import io.trino.plugin.jdbc.JdbcDynamicFilteringSessionProperties;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class JdbcDynamicFilteringSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(JdbcDynamicFilteringSplitManager.class);
    private static final ConnectorSplitSource.ConnectorSplitBatch EMPTY_BATCH = new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of(), false);
    private final ConnectorSplitManager delegateSplitManager;
    private final DynamicFilteringStats stats;

    @Inject
    public JdbcDynamicFilteringSplitManager(@ForJdbcDynamicFiltering ConnectorSplitManager delegateSplitManager, DynamicFilteringStats stats) {
        this.delegateSplitManager = Objects.requireNonNull(delegateSplitManager, "delegateSplitManager is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        if (table instanceof JdbcProcedureHandle) {
            return this.delegateSplitManager.getSplits(transaction, session, table, dynamicFilter, constraint);
        }
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        boolean hasLimit = tableHandle.getLimit().isPresent();
        if (dynamicFilter == DynamicFilter.EMPTY || hasLimit || !JdbcDynamicFilteringSessionProperties.dynamicFilteringEnabled(session)) {
            return this.delegateSplitManager.getSplits(transaction, session, table, dynamicFilter, constraint);
        }
        return new DynamicFilteringSplitSource(transaction, session, (JdbcTableHandle)table, dynamicFilter, constraint);
    }

    private class DynamicFilteringSplitSource
    implements ConnectorSplitSource {
        private final ConnectorTransactionHandle transaction;
        private final ConnectorSession session;
        private final JdbcTableHandle table;
        private final DynamicFilter dynamicFilter;
        private final Constraint constraint;
        private final long dynamicFilteringTimeoutNanos;
        private final long startNanos;
        @GuardedBy(value="this")
        private Optional<ConnectorSplitSource> delegateSplitSource = Optional.empty();

        DynamicFilteringSplitSource(ConnectorTransactionHandle transaction, ConnectorSession session, JdbcTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
            this.transaction = Objects.requireNonNull(transaction, "transaction is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
            this.constraint = Objects.requireNonNull(constraint, "constraint is null");
            this.dynamicFilteringTimeoutNanos = (long)JdbcDynamicFilteringSessionProperties.getDynamicFilteringWaitTimeout(session).getValue(TimeUnit.NANOSECONDS);
            this.startNanos = System.nanoTime();
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
            long remainingTimeoutNanos = this.getRemainingTimeoutNanos();
            if (remainingTimeoutNanos > 0L && this.dynamicFilter.isAwaitable()) {
                log.debug("Waiting for dynamic filter (query: %s, table: %s, remaining timeout: %s)", new Object[]{this.session.getQueryId(), this.table, Duration.succinctNanos((long)remainingTimeoutNanos)});
                return ((CompletableFuture)this.dynamicFilter.isBlocked().thenApply(object -> EMPTY_BATCH)).completeOnTimeout(EMPTY_BATCH, remainingTimeoutNanos, TimeUnit.NANOSECONDS);
            }
            Duration waitingTime = Duration.succinctNanos((long)(System.nanoTime() - this.startNanos));
            log.debug("Enumerating splits (query %s, table: %s, waiting time: %s, awaitable: %s, completed: %s)", new Object[]{this.session.getQueryId(), this.table, waitingTime, this.dynamicFilter.isAwaitable(), this.dynamicFilter.isComplete()});
            JdbcDynamicFilteringSplitManager.this.stats.processDynamicFilter(this.dynamicFilter, waitingTime);
            return this.getDelegateSplitSource().getNextBatch(maxSize);
        }

        public void close() {
            this.getOptionalDelegateSplitSource().ifPresent(ConnectorSplitSource::close);
        }

        public boolean isFinished() {
            if (this.getRemainingTimeoutNanos() > 0L && this.dynamicFilter.isAwaitable()) {
                return false;
            }
            return this.getDelegateSplitSource().isFinished();
        }

        private long getRemainingTimeoutNanos() {
            return this.dynamicFilteringTimeoutNanos - (System.nanoTime() - this.startNanos);
        }

        private synchronized ConnectorSplitSource getDelegateSplitSource() {
            if (this.delegateSplitSource.isPresent()) {
                return this.delegateSplitSource.get();
            }
            this.delegateSplitSource = Optional.of(JdbcDynamicFilteringSplitManager.this.delegateSplitManager.getSplits(this.transaction, this.session, (ConnectorTableHandle)this.table.intersectedWithConstraint((TupleDomain<ColumnHandle>)this.dynamicFilter.getCurrentPredicate()), this.dynamicFilter, this.constraint));
            return this.delegateSplitSource.get();
        }

        private synchronized Optional<ConnectorSplitSource> getOptionalDelegateSplitSource() {
            return this.delegateSplitSource;
        }
    }
}

