/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.inject.Inject;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcMergeSink;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcPageSink;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public class JdbcPageSinkProvider
implements ConnectorPageSinkProvider {
    private final JdbcClient jdbcClient;
    private final RemoteQueryModifier queryModifier;
    private final QueryBuilder queryBuilder;

    @Inject
    public JdbcPageSinkProvider(JdbcClient jdbcClient, RemoteQueryModifier remoteQueryModifier, QueryBuilder queryBuilder) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.queryModifier = Objects.requireNonNull(remoteQueryModifier, "remoteQueryModifier is null");
        this.queryBuilder = Objects.requireNonNull(queryBuilder, "queryBuilder is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        return new JdbcPageSink(session, (JdbcOutputTableHandle)tableHandle, this.jdbcClient, pageSinkId, this.queryModifier, JdbcClient::buildInsertSql);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        return new JdbcPageSink(session, (JdbcOutputTableHandle)tableHandle, this.jdbcClient, pageSinkId, this.queryModifier, JdbcClient::buildInsertSql);
    }

    public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        return new JdbcMergeSink(session, mergeHandle, this.jdbcClient, pageSinkId, this.queryModifier, this.queryBuilder);
    }
}

