/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;

public final class ExecutorUtil {
    private ExecutorUtil() {
    }

    public static <T> List<T> processWithAdditionalThreads(Collection<Callable<T>> tasks, Executor executor) throws ExecutionException {
        List wrapped = (List)tasks.stream().map(Task::new).collect(ImmutableList.toImmutableList());
        ExecutorCompletionService<TaskResult> completionService = new ExecutorCompletionService<TaskResult>(executor);
        ArrayList<Future<TaskResult>> futures = new ArrayList<Future<TaskResult>>(wrapped.size());
        Context tracingContext = Context.current();
        try {
            for (int i = 0; i < wrapped.size(); ++i) {
                int index = i;
                Task task = (Task)wrapped.get(i);
                futures.add(completionService.submit(() -> {
                    if (!task.take()) {
                        return null;
                    }
                    try (Scope scope = tracingContext.makeCurrent();){
                        TaskResult taskResult = new TaskResult(index, task.callable.call());
                        return taskResult;
                    }
                }));
            }
            ArrayList<Object> results = new ArrayList<Object>(Collections.nCopies(wrapped.size(), null));
            int pending = wrapped.size();
            for (int i = wrapped.size() - 1; i >= 0; --i) {
                Future ready = completionService.poll();
                while (ready != null) {
                    TaskResult taskResult = (TaskResult)ready.get();
                    if (taskResult != null) {
                        results.set(taskResult.taskIndex(), taskResult.result());
                        --pending;
                    }
                    ready = completionService.poll();
                }
                Task task = (Task)wrapped.get(i);
                if (!task.take()) continue;
                try {
                    results.set(i, task.callable.call());
                    --pending;
                    continue;
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }
            while (pending > 0) {
                TaskResult taskResult = (TaskResult)completionService.take().get();
                if (taskResult == null) continue;
                results.set(taskResult.taskIndex(), taskResult.result());
                --pending;
            }
            ArrayList<Object> arrayList = results;
            return arrayList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted", e);
        }
        finally {
            futures.forEach(future -> future.cancel(true));
        }
    }

    @ThreadSafe
    private static final class Task<T> {
        private final Callable<T> callable;
        @GuardedBy(value="this")
        private boolean taken;

        public Task(Callable<T> callable) {
            this.callable = Objects.requireNonNull(callable, "callable is null");
        }

        public synchronized boolean take() {
            if (this.taken) {
                return false;
            }
            this.taken = true;
            return true;
        }
    }

    private record TaskResult<T>(int taskIndex, T result) {
    }
}

